var requests = {};
var Appad = {
  config: {
    siteUrl: 'http://localhost/nova/',
    AssetUrl: 'http://localhost/nova/assets/'   
  },
  init: function(config) {
    _this = this;
    $.extend(_this.config, config);
  },
  delete_row:function($elm){
    var row = $elm.closest("tr").get(0);
    var dataTbl = $elm.parents('.dataTable').data("tbl");
    if ($.fn.DataTable.fnIsDataTable( dataTbl ) ) {
      var index = dataTbl.fnGetPosition(row); 
      dataTbl.fnDeleteRow(index, function (dtSettings, row) {
        dataTbl.fnDraw(false);        
      }, true);
    }
  },
  displayMsg:function(msgText){
    $(".disp-js-msg").show();
    $(".js-msg-text").html(msgText);
    setTimeout(function(){ $(".disp-js-msg").hide(); }, 3000);
  },
  ajax: function(objConfig) {
    return $.ajax({
      type: objConfig.type, 
      url: objConfig.url,
      context:(objConfig.context != undefined)?objConfig.context:{},
      beforeSend:function(xhr,settings){
        if (settings.context != undefined && !jQuery.isEmptyObject(settings.context)  && settings.context.hasClass('btn_loading')) {
          settings.context.button('loading');
        }
        (objConfig.beforeSend != undefined)?objConfig.beforeSend(xhr,settings):'';
      }, 
      headers: (objConfig.headers != undefined)?objConfig.headers:{}, 
      async: (objConfig.async != undefined)?objConfig.async:true,
      data : (objConfig.data != undefined)?objConfig.data:{},
      dataType : (objConfig.dataType != undefined)?objConfig.dataType:'json',
      cache: (objConfig.cache != undefined)?objConfig.cache:true,
      contentType: (objConfig.contentType != undefined)?objConfig.contentType:'application/x-www-form-urlencoded',
      success: function(data) {
        objConfig.success(data);
      },
      error: function(data, textStatus, jqXHR) {
        objConfig.error(data, textStatus, jqXHR)   
      },
      complete:function(){
        if(typeof this.button != "undefined"){
          this.button('reset');  
        }
      }
    });
},
abortajax:function(name){
  if(typeof(requests[name])!="undefined"){
    $.each(requests[name],function(k,v){
      v.abort();
    });
  }
},
addAjaxArray:function(name,req){
  if(typeof requests[name] == "undefined")
  {
    requests[name] = [];
  }
  requests[name].push(req);
},
refresh_table:function(table_name){
  var a=$("#"+table_name).data("a");
  var dataTbl = a.getDataTable();

  a.setAjaxParam("min_date",$("#start_date").val());
  a.setAjaxParam("max_date",$("#end_date").val());
  a.setAjaxParam("pickup_location",$("#pickup_location").val());
  a.setAjaxParam("category",$("#categories").val());

  if (dataTbl) 
  {
    dataTbl.ajax.reload();
  }
},
init_mng_boooking_list:function(){

  $("body").on('change','.booking_export_filter',function()
  {
    _this.refresh_table('tblmng_booking');
  });

  var a = new Datatable;
  a.setAjaxParam("min_date",$("#start_date").val());
  a.setAjaxParam("max_date",$("#end_date").val());
  a.setAjaxParam("pickup_location",$("#pickup_location").val());
  a.setAjaxParam("category",$("#categories").val());
  a.init({
    src: $("#tblmng_booking"),
    onSuccess: function(a, e) {},
    onError: function(a) {},
    onDataLoad: function(a) {},
    loadingMessage: "Loading...",
    dataTable: {
     "bSortCellsTop": true,
     "autoWidth": false,
     "filter": true,
     "order": [ 0, "desc" ],
     "aoColumns": [
     { "title": "#","data": "id" },     
     { "data": "booking_no","title":"No"},  
     { "data": "firstname","title":"Name"},  
     { "data": "address","title":"Address"},       
     { "data": "name","title":"Car"},     
     { "data": "pickup_location_name","title":"Pickup"},
     { "data": "dropoff_location_name","title":"Dropoff"},
     { "data": "pickup_date","title":"Pickup Date Time"},
     { "data": "dropoff_date","title":"Dropoff Date Time"},
     { "data": "booking_date","title":"Booking Date"},
     { "data": "booking_status","title":"Status"},
     { "data": "booking_price","title":"Price"}     
     ],
     ajax: {
      url: config.siteUrl+"agency/bookings"
    }
  }
});
  $("#tblmng_booking").data("a",a);
}
}
jQuery(document).ready(function() {
  Appad.init(config)
});