<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stop_sale_period_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'stop_sale_period';
	protected $CI;
	public $after_create = array( 'after_create' );
	public $before_update = array('before_update');
	public $after_get = array( 'after_get' );
	public $allow_after_get = false;
	public $get_offers_location_data = false;
	public $allow_before_update = false;


	/*'locationId'  => array(
			'field' => 'locationId',
			'label' => 'locationId Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_LOCATION_REQUIRED',				
				),
			),

		'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'categoryId Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
				),
),*/

public $validate = array(
	'start_date'  => array(
		'field' => 'start_date',
		'label' => 'start_date Name',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:START_DATE_REQUIRED',				
			),
		),
	'end_date'  => array(
		'field' => 'end_date',
		'label' => 'end_date Name',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:END_DATE_REQUIRED',				
			),
		)
	);

public function alpha_dash_space($str)
{
	return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
} 

public function __construct()
{
	parent::__construct();
	$this->CI=& get_instance();
}

public function before_delete($data){

	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	return $data;
}

public function before_update($data)
{
	if($this->allow_before_update == true)
	{
		$stopsaleId = $data["id"];

		/*Insert Facilities*/
		$this->insert_enimeties_data($stopsaleId,"cars","carId","stop_sale_period_cars_detail_model",$data["db_sel_cars"]);
		/*Insert Facilities*/

		/*Characterisitcs insert*/
		$this->insert_enimeties_data($stopsaleId,"locations","locationId","stop_sale_period_location_detail_model",$data["db_sel_location"]);
		/*Characterisitcs insert ends*/

		unset($data["id"]);
		unset($data["db_sel_cars"]);		
		unset($data["db_sel_location"]);
	}

	return $data;
}

public function after_get($data)
{
	if(!empty($data) && $this->allow_after_get == true)
	{
		$this->load->model("locations_model");
		$this->load->model("cars_model");
		$this->load->model("stop_sale_period_cars_detail_model");
		$this->load->model("stop_sale_period_location_detail_model");
		
		$car_fields = "cars.*,stop_sale_period_cars_detail.carId";
		$locations_fields = "locations.*";	
		
		$where = array('stop_sale_period_cars_detail.stopsaleId'=>$data["id"]);
		$data["db_sel_cars"] = $this->cars_model->set_fields($car_fields)->join('stop_sale_period_cars_detail', 'stop_sale_period_cars_detail.carId = cars.id')->as_array()->get_many_by($where);


		if($this->get_offers_location_data == true)
		{
			$where_char = array('stop_sale_period_location_detail.stopsaleId'=>$data["id"]);
			$data["db_sel_location"] = $this->locations_model->set_fields($locations_fields)->join('stop_sale_period_location_detail', 'stop_sale_period_location_detail.locationId = locations.id')->as_array()->get_many_by($where_char);
		}
	}
	return $data;
}

public function after_create($stopsaleId)
{
	/*Insert Facilities*/
	$this->insert_enimeties_data($stopsaleId,"cars","carId","stop_sale_period_cars_detail_model");
	/*Insert Facilities*/

	/*Characterisitcs insert*/
	$this->insert_enimeties_data($stopsaleId,"locations","locationId","stop_sale_period_location_detail_model");
	/*Characterisitcs insert ends*/

	return $stopsaleId;
}



public function insert_enimeties_data($stopsaleId,$post_name,$field_name,$modal_name,$existing_items = array())
{	
	$insert_batch_array = array();
	$post_data = $this->input->post($post_name);
	$i = 0;
	$this->load->model($modal_name);

	if(!empty($existing_items))
	{
		$item_string = null;
		foreach ($post_data as $key => $value) 
		{
			$item_string .= '"'.$value.'"'.",";	
		}
		$item_string = rtrim($item_string,",");
		$where[] = array("stopsaleId = '".$stopsaleId."'",null,false);
		$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
		$this->{$modal_name}->delete_by($where);
		$post_data = array_diff($post_data,$existing_items);
	}	
	if(!empty($post_data))
	{
		foreach ($post_data as $key => $value) 
		{
			/*car_pickup_location_detail*/
			$insert_batch_array[$i]['stopsaleId'] = $stopsaleId;
			$insert_batch_array[$i][$field_name] = $value;				
			$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
			$i++;
		}
		if(!empty($insert_batch_array))
		{

			$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
		}
	}
	return $status;
}


}
