<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Season_location_working_hours_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'season_location_working_hours';
	
	protected $CI;
	public $validate = array(
		'seasonId'  => array(
			'field' => 'seasonId',
			'label' => 'Season',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SEASON_ID_REQUIRED'
			),
		),
		'locationId'  => array(
			'field' => 'locationId',
			'label' => 'Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_ID_REQUIRED'
			),
		),
		'working_from'  => array(
			'field' => 'working_from',
			'label' => 'Working From',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:WORKING_FROM_TIME_REQUIRED'
			),
		),
		'working_to'  => array(
			'field' => 'working_to',
			'label' => 'Working to',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:WORKING_TO_TIME_REQUIRED'
			),
		)
	);
	public $after_get = array('after_get');
	public $after_get_allow = false;
	public function __construct()
	{
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($this->after_get_allow === true)
			{
				$where = array("seasonId"=>$data["seasonId"]);
				$this->after_get_allow = false;
				$locations_details = $this->set_fields("locationId,working_from,working_to")->get_many_by($where);
				$this->after_get_allow = true;

				if(!empty($locations_details))
				{
					$final_location_details = array();
					foreach ($locations_details as $key => $value) 
					{
						$final_location_details[$value["locationId"]] = $value;
					}
				}
				$data["locations_details"] = $final_location_details;
			}
		}
		return $data;
	}
}
