<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Rental_days_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'rental_days';
	protected $CI;
	public $validate = array(
		'day'  => array(
			'field' => 'day',
			'label' => 'Day',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:RENTAL_DAY_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),
	);
	
	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}
}
