<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class refferal_list_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'refferal_list';
	protected $CI;
	public $is_image_uploaded;
	public $validate = array(
		/*'email'  => array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL',
				),
	),*/

	'name'  => array(
		'field' => 'name',
		'label' => 'Name',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:EMAIL_REQUIRED'				
			),
		),

	'url'  => array(
		'field' => 'url',
		'label' => 'url',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:URL_REQUIRED'
			),
		),
	'code'  => array(
		'field' => 'code',
		'label' => 'code',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:REFFERAL_CODE_REQUIRED'
			),
		),
	'share_url'  => array(
		'field' => 'share_url',
		'label' => 'share_url',
		'rules' => 'trim|required|xss_clean',
		'error_msg' => array(
			'required'  => 'lang:SHARE_URL_REQUIRED'
			),
		),	
	);

	public $before_update_allowed = true;
	public $after_create = array( 'after_create' );
	public $before_update = array( 'before_update' );
	public $after_get = array('after_get');

	public $before_delete = array('before_delete');
	public $after_update = array('after_update');
	
	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
		$this->is_image_uploaded = true;
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}
		return $data;
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($data["booking_form_image"] != '' && $data["booking_form_image"] != null)
			{
				$data["booking_form_url"] = base_url()."image/refferal_list/".$data["id"]."/250/250/".$data["booking_form_image"];	
				$data["general_booking_form_url"] = base_url()."image/refferal_list/".$data["id"]."/800/800/".$data["booking_form_image"];	

			}
		}
		return $data;
	}


	public function before_update($data)
	{	

		if($this->before_update_allowed == true)
		{
			$pageid = $data["id"];
			$image_data = $this->get($pageid);
			if($_FILES['booking_form_image']["name"] != "")
			{	
				$update_new_image_ar = $this->upload_image($pageid);
				if($update_new_image_ar["status"] == "success")
				{
					if($update_new_image_ar["status"] == "success")
					{
						$exist_check_path = FCPATH."assets/upload/refferal_list/".$pageid."/".$image_data["booking_form_image"];	
						if(file_exists($exist_check_path) && $exist_check_path!="")
						{
							unlink($exist_check_path);
						}
					}
					$data['booking_form_image'] = $update_new_image_ar['file_name'];
				}
				else{
					$data['before_return']['msg']=lang("INVALID_REQUEST");	
				}
			}
			unset($data["id"]);


			if(isset($data["change_password"]) && $data["change_password"] == true)
			{
				if($this->CI->current_session["password"] != $data["old"])
				{
					$data['before_return']['msg']=lang(WRONG_PASS);
					return $data;
				}
				unset($data["old"]);
				unset($data["change_password"]);				
			}


		}
		return $data;
	}


	public function after_create($pageid,$data)
	{

		if($_FILES['booking_form_image'] && $_FILES['booking_form_image']['error']==UPLOAD_ERR_OK)
		{
			$status_ar = $this->upload_image($pageid);
			if($status_ar["status"] == "success")
			{
				$update_data = array();
				$update_data['booking_form_image'] = $status_ar['file_name'];	
				$this->before_update_allowed = false;
				$this->update($pageid,$update_data,true);
				$this->before_update_allowed = true;
			}
			else{
				$data['before_return']['msg']=lang(INVALID_REQUEST);	
			}	
		}

		if(!empty($data))
		{
			$url =	base_url()."agency/";
			$admin = SITE_NM;
			$key = array('{NAME}','{USER_EMAIL}','{PASSWORD}','{LOGIN_LINK}','{ADMIN}', '{MSG_EXT}');
			$val = array($data["name"],$data["email"],$data["password"],$url,$admin,'');
			send_mail('Agency Register',$key,$val,$data["email"]);


			$update_data = array();
			$update_data['password'] =md5($data["password"]);	
			$this->before_update_allowed = false;
			$this->update($pageid,$update_data,true);
			$this->before_update_allowed = true;

		}

		return $data;
	}

	public function after_update($data)
	{
		if(!empty($data))
		{
			$this->load->model("admin_model");
			$array = array('id'=>$this->CI->current_session["id"],'session_update'=>true,'skip_validation'=>true,'type'=>'admin');
			$this->admin_model->check_agency_login($array);	
		}
		return $data;	
	}

	public function upload_image($id)
	{
		$asset_upload_dir = FCPATH.'assets/upload/'; 
		$asset_locations_dir = FCPATH.'assets/upload/refferal_list/'; 
		$upload_dir = FCPATH.'assets/upload/refferal_list/'.$id.'/'; 

		if(!file_exists($asset_upload_dir)){

			mkdir($asset_upload_dir,0777);
			chmod($asset_upload_dir,0777);
		}

		if(!file_exists($asset_locations_dir)){
			mkdir($asset_locations_dir,0777);
			chmod($asset_locations_dir,0777);
		}

		if(!file_exists($upload_dir)){
			mkdir($upload_dir,0777);
			chmod($upload_dir,0777);
		}	

		$data = array('status'=>'error');
		$maxSize = IMAGE_UPLOAD_MAX_SIZE;

		if($_FILES['booking_form_image']['error']==UPLOAD_ERR_OK){
			$this->load->library('image_lib');
			$name = $_FILES['booking_form_image']['name'];
			$size = $_FILES['booking_form_image']['size'];
			$ext = substr($name, strrpos($name, ".") + 1);

			if ($size < ($maxSize)) {

				$th_arr=array();	
				$config['upload_path'] = $upload_dir;
				$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
				$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$field_name = "booking_form_image";
				if ( ! $this->upload->do_upload($field_name))
				{
					$this->form_validation->set_message('insert',$this->upload->display_errors());
					$data["status"] = "error";
					$data["msg"] = $this->upload->display_errors();					
				}
				else
				{
					$fileUpd = array('upload_data' => $this->upload->data());
					$data["status"] = "success";
					$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
				}
			}
			else{
				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
				$data["status"] = 'error';
				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
			}	
		}
		return $data;
	}




}
