<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Offers_model extends My_Model

{

	public $primary_key = 'id';

	public $get_insurance_details = false;

	public $allow_before_update = true;

	public $allow_after_get = true;

	public $get_offers_location_data = true;

	public $recursive_set = false;

	public $_table = 'offers';

	public $before_delete = array( 'before_delete' );

	public $after_create = array( 'after_create' );

	public $before_update = array('before_update');

	public $after_get = array( 'after_get' );

	protected $CI;

	public $validate = array(

		'title'  => array(

			'field' => 'title',

			'label' => 'title Name',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_TITLE_REQUIRED'				

				),

			),

		'groupId'  => array(

			'field' => 'groupId',

			'label' => 'groupId Name',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:CAR_GROUP_REQUIRED',				

				),

			),

		'type'  => array(

			'field' => 'type',

			'label' => 'Type',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_TYPE_REQUIRED'				

				),

			),



		'cars'  => array(

			'field' => 'cars[]',

			'label' => 'cars',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_CARS_REQUIRED'				

				),

			),



		'locations'  => array(

			'field' => 'locations[]',

			'label' => 'locations',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_LOCATIONS_REQUIRED'				

				),

			),



		'start_date'  => array(

			'field' => 'start_date',

			'label' => 'start_date',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_START_DATE_REQUIRED'				

				),

			),



		'end_date'  => array(

			'field' => 'end_date',

			'label' => 'end_date',

			'rules' => 'trim|required|xss_clean',

			'error_msg' => array(

				'required'  => 'lang:OFFER_END_DATE_REQUIRED'				

				),

			),



		);







public function __construct()

{

	

	parent::__construct();

	$this->CI=& get_instance();

}



public function before_delete($data)

{

	if(!$this->current_session)

	{	

		$data['before_return']['msg']=lang(INVALID_REQUEST);				

	}

	$image_data = $this->get($data);

	$exist_check_path = FCPATH."assets/nova/offers/".$image_data["image"];			

	if(file_exists($exist_check_path) && $exist_check_path!='')

	{

		unlink($exist_check_path);

	}

	return $data;

}

public function after_get($data)

{

	if(!empty($data))

	{

		if($data["image"] != '')

		{

			$data["image_path"] = base_url()."image/offers/305/196/".$data["image"];
			$data["offer_image_path"] = base_url()."image/offers/196/196/".$data["image"];

		}

		else

		{	

			$data["image_path"] = base_url()."image/default/305/196/no_available_image.gif";
			$data["offer_image_path"] = base_url()."image/default/196/196/no_available_image.gif";

		}		

		$data["sign"] = ($data["type"] == "p") ? ' % ' : '&euro;';	

	}



	if(!empty($data) && $this->allow_after_get == true)

	{

		$this->load->model("locations_model");

		$this->load->model("cars_model");

		$this->load->model("offers_cars_detail_model");

		$this->load->model("offers_location_detail_model");

	

		$car_fields = "cars.*,offers_cars_detail.carId";

		$locations_fields = "locations.*";	

		$where = array('offers_cars_detail.offerId'=>$data["id"]);

		

		$this->cars_model->after_get_allow = false;

		$this->cars_model->after_get_category_name_allow = false;

		$this->cars_model->after_get_group_name_allow = false;



		$data["db_sel_cars"] = $this->cars_model->set_fields($car_fields)->join('offers_cars_detail', 'offers_cars_detail.carId = cars.id')->as_array()->get_many_by($where);

		

		$this->cars_model->after_get_allow = true;

		$this->cars_model->after_get_category_name_allow = true;

		$this->cars_model->after_get_group_name_allow = true;



		if($this->get_offers_location_data == true)

		{

			$where_char = array('offers_location_detail.offerId'=>$data["id"]);

			if($this->recursive_set === true)

			{

				$this->locations_model->after_get_allow = false;	

			}

			$data["db_sel_location"] = $this->locations_model->set_fields($locations_fields)->join('offers_location_detail', 'offers_location_detail.locationId = locations.id')->as_array()->get_many_by($where_char);

			if($this->recursive_set === true)

			{

				$this->locations_model->after_get_allow = true;

			}

		}

	}

	return $data;

} 



public function before_update($data)

{

	if($this->allow_before_update == true)

	{

		$offerId = $data["id"];

		$image_data = $this->get($data["id"]);

		if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK)

		{	

			$update_new_image_ar = $this->upload_image($data["id"]);

			if($update_new_image_ar["status"] == "success")

			{

				if($update_new_image_ar["status"] == "success")

				{

					$exist_check_path = FCPATH."assets/upload/offers/".$image_data["image"];	

					if(file_exists($exist_check_path) && $exist_check_path!=''){

						unlink($exist_check_path);

					}

				}

				$data['image'] = $update_new_image_ar['file_name'];

			}

			else{

				$data['before_return']['msg']=lang(INVALID_REQUEST);	

			}

		}



		/*Insert Facilities*/

		$this->insert_enimeties_data($offerId,"cars","carId","offers_cars_detail_model",$data["db_sel_cars"]);

		/*Insert Facilities*/



		/*Characterisitcs insert*/

		$this->insert_enimeties_data($offerId,"locations","locationId","offers_location_detail_model",$data["db_sel_location"]);

		/*Characterisitcs insert ends*/

		unset($data["id"]);

		unset($data["db_sel_cars"]);		

		unset($data["db_sel_location"]);

	}



	return $data;

}



public function after_create($offerId){

	if($_FILES['image']){

		$status_ar = $this->upload_image();

		if($status_ar["status"] == "success")

		{

			$upddata = array();

			$upddata['image'] = $status_ar['file_name'];	

			$this->allow_before_update = false;

			$this->update($offerId,$upddata,true);

		}

		else{

			$data['before_return']['msg']=lang(INVALID_REQUEST);	

		}	

	}



	/*Insert Facilities*/

	$this->insert_enimeties_data($offerId,"cars","carId","offers_cars_detail_model");

	/*Insert Facilities*/



	/*Characterisitcs insert*/

	$this->insert_enimeties_data($offerId,"locations","locationId","offers_location_detail_model");

	/*Characterisitcs insert ends*/



	return $offerId;

}





public function insert_enimeties_data($offerId,$post_name,$field_name,$modal_name,$existing_items = array())

{	

	$insert_batch_array = array();

	$post_data = $this->input->post($post_name);

	$i = 0;

	$this->load->model($modal_name);



	if(!empty($existing_items))

	{

		$item_string = null;

		foreach ($post_data as $key => $value) 

		{

			$item_string .= '"'.$value.'"'.",";	

		}

		$item_string = rtrim($item_string,",");

		$where[] = array("offerId = '".$offerId."'",null,false);

		$where[] = array("$field_name NOT IN (".$item_string.")",null,false);

		$this->{$modal_name}->delete_by($where);

		$post_data = array_diff($post_data,$existing_items);

	}	

	if(!empty($post_data))

	{

		foreach ($post_data as $key => $value) {

			$insert_batch_array[$i]['offerId'] = $offerId;

			$insert_batch_array[$i][$field_name] = $value;				

			$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');

			$i++;

		}

		if(!empty($insert_batch_array))

		{



			$status = $this->{$modal_name}->insert_many($insert_batch_array,true);

		}

	}

	return $status;

}





public function upload_image($id)

{

	$asset_upload_dir = FCPATH.'assets/upload/'; 

	$upload_dir = FCPATH.'assets/upload/offers/'; 



	if(!file_exists($asset_upload_dir)){

		mkdir($asset_upload_dir,777);

	}



	if(!file_exists($upload_dir)){

		mkdir($upload_dir,0777);

	}	



	$data = array('status'=>'error');

	$maxSize = IMAGE_UPLOAD_MAX_SIZE;



	if($_FILES['image']['error']==UPLOAD_ERR_OK){

		$this->load->library('image_lib');

		$name = $_FILES['image']['name'];

		$size = $_FILES['image']['size'];

		$ext = substr($name, strrpos($name, ".") + 1);



		if ($size < ($maxSize)) {



			$th_arr=array();	

			$config['upload_path'] = $upload_dir;

			$config['file_name'] =md5(date("Y-m-d H:i:s").rand());

			$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';

			$this->load->library('upload', $config);

			$this->upload->initialize($config);

			$field_name = "image";

			if ( ! $this->upload->do_upload($field_name))

			{

				$this->form_validation->set_message('insert',$this->upload->display_errors());

				$data["status"] = "error";

				$data["msg"] = $this->upload->display_errors();					

			}

			else

			{

				$fileUpd = array('upload_data' => $this->upload->data());

				$data["status"] = "success";

				$data['file_name'] = $fileUpd['upload_data']['file_name'] ;

			}

		}

		else{

			$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);

			$data["status"] = 'error';

			$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				

		}	

	}

	return $data;

}





}

