<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class admin_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'admin';
	public $after_create = array( 'after_register' );
	public $before_update = array( 'before_update' );
	public $after_update = array( 'after_update' );
	public $after_get = array( 'after_get_login' );
	public $after_get_allow = true;
	protected $CI;
	public $validate = array(
		'username'  => array(
			'field' => 'username',
			'label' => 'First Name',
			'rules' => 'required|is_unique[admin.username]',
			'error_msg' => array(
				'required'  => 'lang:USER_NAME_REQUIRED'
				),
			),
		'password'  => array(
			'field' => 'password',
			'label' => 'Password',
			'rules' => 'trim|required|min_length[4]',
			'error_msg' => array(
				'required'  => 'lang:PASSWORD_REQUIRED'
				),
			),
		'roles'  => array(
			'field' => 'roles[]',
			'label' => 'Roles',
			'rules' => 'trim|required|multiple_select',
			'error_msg' => array(
				'required'  => 'lang:ROLES_REQUIRED',
				'multiple_select'  => 'lang:ROLES_REQUIRED'
				),
			),
		'email'  => array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email|is_unique[admin.email]',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL',
				'is_unique'=>'lang:USER_ALREADY_EXIST'
				),
			),
		);

	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
	}

	public function after_register($data)
	{
		$roles = $this->input->post('roles');
		if(!empty($roles))
		{
			$data1 = array();
			foreach($roles as $key=>$roles1) 
			{
				$data1[$i]["adminId"] =$data;
				$data1[$i]["roleId"] = $roles1;
				$data1[$i]["createdDate"] = date('Y-m-d H:i:s');
				$i++;
			}
			$this->load->model("admin/subadmin_roles_model");
			$this->subadmin_roles_model->insert_many($data1,true);
		}
	}

	public function before_update($data){
		if(!empty($data))
		{
			if(isset($data["change_password"]) && $data["change_password"] == true)
			{
				if($this->CI->current_session["password"] != $data["old"])
				{
					$data['before_return']['msg']=lang(WRONG_PASS);
					return $data;
				}
				unset($data["old"]);
				unset($data["change_password"]);				
			}
		}
		return $data;
	}

	public function after_update($data){
		$array = array('id'=>$this->CI->current_session["id"],'session_update'=>true,'skip_validation'=>true,'type'=>'admin');
		$this->check_login($array);
		return $data;	
	}

	public function after_get_login($data)
	{
		if(!empty($data))
		{
			if(!$this->isAjax && $this->after_get_allow == true)
			{
				$this->load->model("admin/subadmin_roles_model");   
				$this->load->model("adminrole_model");
				$this->load->model("adminsection_model");

				$adminId = $data['id'];
				$type=$data['adminType'];
				$data['sections']=array();
				$current_class_nm = $this->router->fetch_class();
				$data['is_allowed']=false;

				if($type=='g')
				{
					$where_ar_services[] = array("(subadmin_roles.adminId = '".$adminId."' AND adminrole.status = 'a') or adminrole.status='d'",null,false);
					$subadmin_menu_roles = $this->subadmin_roles_model->set_fields("adminrole.id as roleId")->join('adminrole', 'subadmin_roles.roleId = adminrole.id','left')->group_by("adminrole.id")->get_many_by($where_ar_services);
				}
				else
				{
					/*Main admin*/
					$subadmin_menu_roles = $this->adminrole_model->set_fields("adminrole.id as roleId")->get_all();
					/*Main admin*/
				}

				if(!empty($subadmin_menu_roles))
				{
					$subadmin_menu_roles_ar = array();
					foreach ($subadmin_menu_roles as $key => $role) {
						$subadmin_menu_roles_ar[] = $role["roleId"];
					}
				}
				/*Custom */

				$menu_where[] = array("adminrole.id IN(".implode(",", $subadmin_menu_roles_ar).")",null,false);
				$menu = $this->adminrole_model->set_fields("adminrole.*,adminsection.id as sectionid,adminsection.section_name,adminsection.type as sectiontype,adminsection.order as sectionorder,adminsection.image as sectionimage")->join('adminsection', 'adminsection.id = adminrole.sectionId')->order_by("adminsection.order")->order_by("adminrole.seq")->get_many_by($menu_where);	
				if(!empty($menu))
				{
					foreach ($menu as $key => $roles)
					{
						$section_id=$roles['section']['id'];
						if(!isset($data['sections'][$section_id]))
						{
							$data['sections'][$section_id]=array();
							$data['sections'][$section_id]['roles']=array();
						}
						$data['sections'][$section_id]['section_details']=$roles['section'];
						if(isset($data['sections'][$section_id]['section_details']['classnm']) && $data['sections'][$section_id]['section_details']['classnm']=='active'){
							$section_active=$section_id;
						}
						if($section_id==$section_active){
							$data['sections'][$section_id]['section_details']['classnm']='active';
						}
						unset($roles['section']);
						array_push($data['sections'][$section_id]['roles'],$roles);

						if($roles['pagenm']==$current_class_nm."/" && $data['is_allowed']==false && $roles['status']=='a')
						{
							$data['is_allowed'] = true;
						}
						else if($roles['pagenm']==$current_class_nm."/" && $data['is_allowed']==false && $roles['status']=='d' && $data['is_allowed']==false)
						{
							$data['is_allowed']=true;
						}
					}
				}

				/*Custom*/
				$section_active='';
			}

			

			

			
			
		}		
		return $data;
	}

	public function check_login($array = array('skip_validation'=>false))
	{
		$response = array('status'=>'success','msg'=>'');
		$user_details = array();
		$flag = false;
		if($array["skip_validation"] != true)
		{
			$this->form_validation->set_rules('username', 'lang:USERNAME_REQUIRED', 'required',array('required' => 'lang:USERNAME_REQUIRED'));
			$this->form_validation->set_rules('password', 'lang:PASSWORD_REQUIRED', 'required',array('required' => 'lang:PASSWORD_REQUIRED'));
			
			if($this->form_validation->run() == true)
			{
				$username = $this->input->post("username");
				$password = md5($this->input->post("password"));
				$cond_array = array('username'=>$username,'password'=>$password);
				$flag = true;
			}
			else{
				$response["status"] = "fail";
				$response["msg"] = validation_errors();
			}
		}

		if(isset($array["session_update"]) && $array["session_update"] == true)
		{
			$flag = true;
			$cond_array = array('id'=>$array["id"]);
		}

		if($flag == true)
		{
			$user_details = $this->as_array()->get_by($cond_array);				
		}
		if(!empty($user_details) && $user_details["status"] == "y"){
			unset($user_details['sections']);
			$sess_nm = ADMIN_SESS_NM;
			$this->session->set_userdata($sess_nm,$user_details);
			$response["status"] = "success";
			$response["msg"] = lang(MSG_SUCC_LOGIN);			
		}
		else if(empty($user_details)){
			$response["status"] = "fail";
			$response["msg"] = (!empty(validation_errors())) ? validation_errors() : lang(INVALID_USERNAME_PASSWORD);
		}
		else{
			$response["status"] = "fail";
			$response["msg"] = lang(MSG_NOT_ACTIVATE);
		}

		return $response;
	}	

	public function check_agency_login($array = array('skip_validation'=>false))
	{
		$response = array('status'=>'success','msg'=>'');
		$user_details = array();
		$flag = false;
		if($array["skip_validation"] != true)
		{
			$this->form_validation->set_rules('email', 'lang:EMAIL_REQUIRED', 'required',array('required' => 'lang:EMAIL_REQUIRED'));
			$this->form_validation->set_rules('password', 'lang:PASSWORD_REQUIRED', 'required',array('required' => 'lang:PASSWORD_REQUIRED'));
			
			if($this->form_validation->run() == true)
			{
				$email = $this->input->post("email");
				$password = md5($this->input->post("password"));
				$cond_array = array('email'=>$email,'password'=>$password);
				$flag = true;
			}
			else{
				$response["status"] = "fail";
				$response["msg"] = validation_errors();
			}
		}

		if(isset($array["session_update"]) && $array["session_update"] == true)
		{
			$flag = true;
			$cond_array = array('id'=>$array["id"]);
		}

		if($flag == true)
		{
			$this->load->model("refferal_list_model");
			$user_details = $this->refferal_list_model->get_by($cond_array);				
		}
		
		if(!empty($user_details) && $user_details["status"] == "y")
		{
			$sess_nm = AGENCY_SESS_NM;
			$this->session->set_userdata($sess_nm,$user_details);
			$response["status"] = "success";
			$response["msg"] = lang(MSG_SUCC_LOGIN);			
		}
		else if(empty($user_details)){
			$response["status"] = "fail";
			$response["msg"] = (!empty(validation_errors())) ? validation_errors() : lang(INVALID_USERNAME_PASSWORD);
		}
		else{
			$response["status"] = "fail";
			$response["msg"] = lang(MSG_NOT_ACTIVATE);
		}

		return $response;
	}


	public function forgot_password($array = array()){
		$response = array('status'=>'success','msg'=>'');


		if($array["skip_validation"] != true)
		{
			$this->form_validation->set_rules('email', 'lang:EMAIL_REQUIRED', 'required|valid_email',array('required' => 'lang:EMAIL_REQUIRED','valid_email'=>'lang:MSG_VALID_EMAIL'));
			if($this->form_validation->run() == true)
			{
				$email = $this->input->post('email');
				$forgotten_password_code = md5(time().mt_rand());
				$where = array('email'=>$email);
				$user_detail = $this->as_array()->get_by($where);
				if($user_detail)
				{	
					$update_array = array('forgotten_password_code'=>$forgotten_password_code);
					$temp = $this->update($user_detail["id"],$update_array,true);
					if($temp){
						$response["status"] = "success";
						$response["msg"] = lang(MSG_SUCC_FORGOTPASS);
						$response["activation_code"] = $forgotten_password_code;
						$url = base_url()."resetpassword/".$forgotten_password_code;
						$key = array('{USERNAME}','{USER_EMAIL}','{NEW_PASSWORD}','{ADMIN}', '{MSG_EXT}');
						$val = array($user_detail['uName'],$user_detail['uEmail'],$url,site_name(),'');
						send_mail('ADMIN Forgot password',$key,$val,$user_detail["email"]);
					}
				}else{
					$response["status"] = "fail";
					$response["msg"] = lang(MSG_INVALID_USER);
				}
				
			}
			else{
				$response["status"] = "fail";
				$response["msg"] = validation_errors();
			}
		}
		return $response;
	}

	public function manage_session()
	{
		$admin  =   $this->session->userdata(ADMIN_SESS_NM);
		$array = array('id'=>$admin["id"],'session_update'=>true,'skip_validation'=>true,'type'=>'admin');
		/*$this->check_login($array);*/
		
		/*printr($admin);*/
		$this->CI->current_login_type = "n";   
		if($admin && !empty($admin))
		{
			$admin_details = $this->as_array()->get($admin["id"]);
			/*printr($admin_details);*/
			$roles = $admin_details['sections'];
			$admin['sections']=$roles;
			$admin['is_allowed']=$admin_details['is_allowed'];

			$lastIp = $admin['last_ip'];
			$currentIP = $this->input->ip_address();
			if(($lastIp!=$currentIP || get_cookie('tm')===false) && !$this->CI->isAjax)
			{
				$update_array = array('last_ip'=>$currentIP);
				$this->update($admin["id"],$update_array,true);
				/*$params=array("apiKey"=>$this->CI->config->item("ipinfo_key"));
				$this->CI->load->library("ipinfo",$params);
				$data=$this->CI->ipinfo->getCity($currentIP);
				set_timezone($data,'tm');*/
			}
		}

		if($this->CI->isadminurl && isset($admin) && !empty($admin))
		{
			$this->CI->admin_session = $admin;
			$this->CI->current_session = $admin;
			$this->CI->menutype = 'a';
			$this->CI->current_login_type = "admin";				
		}

		//printr($this->CI->current_session);
	}

	public function manage_agency_session()
	{
		$agency = $this->session->userdata(AGENCY_SESS_NM);
		$this->CI->current_login_type = "n";   
		if($this->CI->isagencyurl && $agency && !empty($agency))
		{
			$this->CI->agency_session = $agency;
			$this->CI->current_session = $agency;
			$this->CI->menutype = 'a';
			$this->CI->current_login_type = "agency";	
		}
	}
}
