<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class sitemap extends MY_Controller 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("locations_model");
	}

	public function index($output = '')
	{	
		$this->load->model("content_model");
		$this->load->model("car_groups_model");		
		$this->load->model("cities_model");

		$this->output->set_title(lang(SITEMAP_TITLE));	

		$where[] = array("display_type = 'page' AND (display_position='1' OR display_position='both' OR display_position='sitemap') AND status = 'y'",null,false);
		$this->data["pages"] = $this->content_model->set_fields("id,page_title,slug")->order_by("sort_order")->get_many_by($where);

		$car_groups_where[] = array("car_groups.status = 'y' AND c.status = 'y'");
		$group_cars = $this->car_groups_model->set_fields("car_groups.group_name,c.name,c.id")->join("cars as c","c.groupId = car_groups.id","left")->get_many_by($car_groups_where);

		if(!empty($group_cars))
		{
			$final_response = array();
			foreach ($group_cars as $key => $value) 
			{
				$final_response[$value["group_name"]]["group_name"] = $value["group_name"];
				$temp = array(
					"name"=>$value["name"],
					"id"=>$value["id"],
					"detail_link"=>base_url()."car/".$value["id"]				
					);	
				$final_response[$value["group_name"]]["cars"][] = $temp;
			}
		}
		$this->data["car_groups"] = $final_response;

		$car_cities_where[] = array("cities.status = 'y' AND l.status = 'y'");
		$this->cities_model->after_get_location_allow = false;
		$cities = $this->cities_model->set_fields("cities.city_name,cities.id as city_id,l.location_name,l.location_short_name,l.id as location_id")->join("locations as l","l.city = cities.id","left")->order_by("l.location_name")->get_many_by($car_cities_where);
		$this->cities_model->after_get_location_allow = true;

		if(!empty($cities))
		{
			$final_response = array();
			foreach ($cities as $key => $value) 
			{
				$final_response[$value["city_name"]]["city_name"] = $value["city_name"];
				$final_response[$value["city_name"]]["id"] = $value["city_id"];
				$final_response[$value["city_name"]]["city_url"] = base_url()."car-hire-city/".$value["city_id"];

				$temp = array(
					"location_name"=>$value["location_name"],
					"id"=>$value["location_id"],
					"location_url"=>base_url()."car-hire-location/".$value["location_id"]				
					);	
				$final_response[$value["city_name"]]["location_array"][] = $temp;
			}
		}
		$this->data["cities"] = $final_response;

		$default_location_ar = $this->site_settings_model->get_by('constant','LOCATION');
		$this->data["default_location_id"] = $default_location_ar["value"];

		$this->locations_model->after_get_allow = false;
		$this->data["location_data"] = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
		$this->locations_model->after_get_allow = true;

		if($output != '')
		{
			$this->layout = false;
			$this->view = false;
			$this->data["footer_links_ar"] = $this->content_model->get_footer_links();		
			$this->locations_model->after_get_allow = false;
			$pop_loc_where = array("status"=>'y',"at_home"=>'1');
			$popular_location_ar = $this->locations_model->set_fields("id,location_name")->get_many_by($pop_loc_where);
			$this->locations_model->after_get_allow = true;
			if(count($popular_location_ar) > 0)
			{
				$this->popular_location = true;
				$this->data["popular_location_ar"] = $popular_location_ar;
			}
			header("Content-Type: text/xml;charset=iso-8859-1");
			$this->load->view('sitemap/sitemap', $this->data);
		}
	}
}
