<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Signin extends MY_Controller {



	function __construct()

	{	

		$this->login_type	='both';

		$this->layout		='default';

		$this->access      ='nologin';

		parent::__construct();

		$this->_init();		

	}



	private function _init()

	{

		$this->sections['section_header'] = 'sections/header';

		$this->sections['section_footer'] = 'sections/footer';

		$this->sections['section_form']="signin/index";

		if($this->isAjax==true){

			$this->sections['section_popup'] = 'sections/popup/modal';

		}

		else{

			$this->sections['section_popup'] = 'sections/popup/page';

		}



	}



	public function index()

	{

		if($this->input->post())

		{

			$this->load->model("user_model");

			$result = $this->user_model->check_login();

			if($result["status"] == "success")

			{

				$this->session->set_flashdata('success',$result["msg"]);

				$redirect_sess_url = $this->session->userdata("redirect_sess_url");

				if($redirect_sess_url != "")

				{	

					$this->session->unset_userdata("redirect_sess_url");

					redirect($redirect_sess_url,"refresh");

				}

				else

				{

					redirect(base_url()."dashboard");	

				}

			}

			else{

				$this->session->set_flashdata('error',$result["msg"]);

				redirect(base_url()."signin");

			}

		}

		if(!$this->input->post())

		{

			if($this->isAjax){

				$this->layout=false;				

			}

			$this->page_title=lang(SIGNIN_TEXT);

			$this->output->set_title($this->page_title);

			$this->view="general/popup_page";

		}

	}

}

