<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class resetpassword extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'user';
		$this->access   = 'nologin';
		$this->layout		='default';
		parent::__construct();
		$this->_init();
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';

		$this->sections['section_form']="resetpassword/index";
		if($this->isAjax){
			$this->sections['section_popup'] = 'sections/popup/modal';
		}
		else{
			$this->sections['section_popup'] = 'sections/popup/page';
		}


	}
	public function index($token)
	{
		$this->load->model("user_model");
		if(!$this->input->post())
		{
			$where = array('forgotten_password_code'=>$token);
			$admin_detail = $this->user_model->as_array()->get_by($where);
			if($admin_detail)
			{
				$this->data["login_url"] = base_url()."signin";
				$this->data["form_url"] = base_url()."resetpassword/".$token;
				$this->output->set_title(lang("Reset Password"));
				$this->body_class = "modal-inline";
				$this->view="general/popup_page";
				$this->page_title=lang("Reset Password");
			}
			else{
				$this->session->set_flashdata("error",lang(LINK_EXPIRED));
				redirect(base_url()."signin");
			}
		}

		if($this->input->post()){
			$response = array('status'=>'success','msg'=>'');
			$this->user_model->validate = array(
				'new'  => array(
					'field' => 'new',
					'label' => 'Password',
					'rules' => 'required|min_length[4]|matches[new_confirm]',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED",
						'min_length'  => "lang:PASSWORD_MINIMUM_LENGTH",
						'matches'  => "lang:MSG_PASSWORD_NOTMATCH"
						),
					),
				'new_confirm'  => array(
					'field' => 'new_confirm',
					'label' => 'Confirm Password',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED"						
						),
					)
				);
			$where = array('forgotten_password_code'=>$token);
			$user_detail = $this->user_model->as_array()->get_by($where);
			if($user_detail){
				$new_pwd = $this->input->post('new');
				$update_array = array('password'=>$new_pwd,'forgotten_password_code'=>'');
				$temp = $this->user_model->update($user_detail["id"],$update_array);
				if($temp){
					$this->session->set_flashdata('success',lang(MSG_PASSWORD_CHANGE_SUCCESSFULL));
					redirect(base_url()."signin");
				}else{
					$this->session->set_flashdata('error',validation_errors());
					redirect(base_url()."resetpassword/".$token);
				}
			}else{
				$this->session->set_flashdata('error',lang(LINK_EXPIRED));
				redirect(base_url()."signin");
			}
		}		
	}	
}
