<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class referral_booking extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	= '';
		$this->layout		= 'refferal_booking';
		$this->access      = '';
		parent::__construct();
		$this->_init();
		$this->page = "referral_booking";

	}
	
	private function _init()
	{
		$this->load->helper('text');
		$this->load->helper('string');
		$this->load->model("locations_model");
	}

	public function index($code)
	{	
		if(!$this->input->post())
		{
			$this->load->model("refferal_list_model");

			$refferer_data = $this->refferal_list_model->get_by("code",$code);

			if(!empty($refferer_data))
			{
				$this->body_class = "nocookiebar nova-iframe-booking";
				$this->page_type = 'add';
				$this->page_name = lang("Refferal Booking");
				$this->output->set_title(lang("Refferal Booking"));
				$this->data['form_url']	= base_url()."search/?";
				$this->data['code']	= $code;
				$this->data['booking_form_title'] = $refferer_data["booking_form_title"];
				$this->data['booking_form_image'] = $refferer_data["general_booking_form_url"];

				$this->data["locations"] = $this->locations_model->get_many_by("status",'y');
				$default_location_ar = $this->site_settings_model->get_by('constant','LOCATION');
				$this->data["default_location_id"] = $default_location_ar["value"];
				$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($default_location_ar["value"]);
				$this->data["pickup_location_time"] = $this->get_opening_time_from_location($default_location_ar["value"]);

				$this->locations_model->after_get_allow = false;
				$default_location_array = $this->locations_model->set_fields("id,location_name,working_from,working_to")->get($default_location_ar["value"]);
				$this->locations_model->after_get_allow = true;

				$working_from_ar = explode(":",$default_location_array["working_from"]);
				array_pop($working_from_ar);
				$this->data["working_from"] = implode(":",$working_from_ar);

				$this->data["working_to"] = $this->data["working_from"];	

				$this->data["selected_pickup_location"] = $this->data["selected_dropoff_location"] = $default_location_array["location_name"];

				$this->data["pickup_location"] = $this->data["dropoff_location"] = $default_location_ar["value"];
				$this->data["pickup_date"] = $this->data["dropoff_date"] = date("Y-m-d");


				$this->load->start_inline_scripting();
				echo "Appfd.initRefferalOperations();";
				$this->load->end_inline_scripting(false,false);

			}
		}


	}


	
}
