<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pricing extends MY_Controller {

	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();		
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
	}

	public function index()
	{
		$this->output->set_title(lang("Pricing"));	
		
		$this->load->js('js/jquery.ba-throttle-debounce.min.js');
		$this->load->js('js/jquery.stickyheader.js');
		$this->load->model("content_model");
		$this->load->model("rental_days_model");
		$this->load->model("cars_model");
		$this->load->model("pricing_model");

		$content_where = array('display_position'=>'pricing','display_type'=>'page','status'=>'y');
		$content_data = $this->content_model->get_by($content_where);
		if(!empty($content_data))
		{
			$this->data["title"] = $content_data["page_title"];
			$this->data["description"] = $content_data["page_description"];
			$this->data["meta_title"] = $content_data["page_title"];
			$this->data["meta_keyword"] = $content_data["meta_keyword"];
			$this->data["meta_description"] = $content_data["meta_description"];
			if($content_data["meta_keyword"] != '' && $content_data["meta_keyword"] != null)
			{
				$this->meta_keyword = $content_data["meta_keyword"];		
			}
			if($content_data["meta_description"] != '' && $content_data["meta_description"] != null)
			{
				$this->meta_description = $content_data["meta_description"];
			}
		}

		$totalRental_days = $this->rental_days_model->order_by("day")->get_many_by("status",'y');

		$this->cars_model->after_get_allow = false; 
		$this->cars_model->after_get_category_name_allow = false; 
		$this->cars_model->after_get_group_name_allow = false; 		
		
		$cars_data = $this->cars_model->set_fields("cars.id,cars.image,cars.name,cars.groupId,cars.categoryId,cat.category,car_g.group_name")
		->join('categories as cat','cars.categoryId = cat.id','left')
		->join('car_groups as car_g','cars.groupId = car_g.id','left')
		->order_by("cars.created","desc")
		->get_many_by("cars.status",'y');
		
		$this->cars_model->after_get_allow = true; 
		$this->cars_model->after_get_category_name_allow = true; 
		$this->cars_model->after_get_group_name_allow = true; 		
		
		if(!empty($cars_data))
		{
			$final_price_array = array();
			foreach ($cars_data as $car_key => $car_value) 
			{
				if(!empty($totalRental_days))
				{
					$days = array();
					$car_value['days'] = array();
					foreach ($totalRental_days as $key => $day_value)
					{
						
						$temp = array();
						$start_date = date('Y-m-d');
						$end_date = date('Y-m-d', strtotime($start_date . ' +'.$day_value['day'].' day'));

						$this->pricing_model->pickup_date = $start_date;
						$this->pricing_model->dropoff_date = $end_date;
						$this->pricing_model->car_category = $car_value["categoryId"];
						$this->pricing_model->car_group = $car_value["groupId"];
						$this->pricing_model->car_id = $car_value["id"];
						$date_difference = date_difference($start_date,$end_date);
						$date_difference = ($date_difference > 1) ? $date_difference : 1;
						$this->pricing_model->booking_total_days = $date_difference;
						/*$this->pricing_model->get_advanced_price();*/
						$reponse = $this->pricing_model->get_car_price();

						if($reponse["advanced_price"] > 0)
						{
							$price = $reponse["advanced_price"];
						}
						else{

							$price = $reponse["basic_price"];

							/*$basic_price_status = $this->pricing_model->get_basic_price();
							if($basic_price_status)
							{
								if($this->pricing_model->basic_price > 0)
								{
									$price = $this->pricing_model->basic_price;
								}								
							}else{
								$price = 0;
							}*/
						}



						if($price > 0)
						{
							$car_value['days'][$day_value['day']] = round($price,2);;
						}
					}
				}
				unset($car_value["id"]);
				$final_price_array[] = $car_value;
			}
		}

		$this->data["final_data"] = $final_price_array;
		$this->data['days']	=	$totalRental_days;
	}
}
