<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Faq extends MY_Controller 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->helper('text');
		$this->load->model("faq_model");
	}

	public function index()
	{
		$this->load->model("content_model");
		$content_where = array('page_title'=>'FAQ','display_type'=>'page','status'=>'y');
		$content_data = $this->content_model->get_by($content_where);
		if($content_data["meta_keyword"] != '' && $content_data["meta_keyword"] != null)
		{
			$this->meta_keyword = $content_data["meta_keyword"];		
		}
		if($content_data["meta_description"] != '' && $content_data["meta_description"] != null)
		{
			$this->meta_description = $content_data["meta_description"];
		}
		$this->data["content_data"] = $content_data;
		
		$this->load->model("faq_sections_model");
		$common_section_ar = $this->faq_sections_model->get_by("name",'Common');
		$this->output->set_title(lang("Faq"));
		$where_ar = array("faq.status"=>'y','faq.sectionId'=>$common_section_ar["id"],"fc.status"=>'y');
		$this->data["faq_data"] = $this->faq_model
		->set_fields("faq.*,fc.id as cat_id,fc.name as category_name")
		->join("faq_category as fc","fc.id = faq.categoryId","left")
		->get_many_by($where_ar);

		if(!empty($this->data["faq_data"]))
		{
			$faqs = array();
			foreach ($this->data["faq_data"] as $key => $value) 
			{
				$faqs[$value["category_name"]][] = $value;
			}	
			$this->data["faq_data"] = $faqs;
		}
	}
}
