<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Bookings extends MY_Controller
{
	function __construct()
	{
		$this->login_type	= 'agency';
		$this->access   = 'login';
		$this->from_admin = "true";
		parent::__construct();
		$this->_init();		
		$this->page ='agency/manage_booking/';
		$this->current_url = base_url()."agency/manage_booking/";
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/agency/header';
		$this->sections['section_sidebar'] = 'sections/agency/menu';
		$this->sections['section_footer'] = 'sections/agency/footer';
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("categories_model");
	}
	public function index()
	{	
		$this->load->js('js/components-date-time-pickers.js');

		$this->load->css('plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css');
		$this->load->js('plugins/bootstrap-datepicker/bootstrap-datepicker.min.js');
		
		$this->load->model("locations_model");
		$this->load->model("categories_model");

		$this->grid_resorces();
		$this->page_name = lang("Bookings");
		$this->output->set_title(lang("Bookings"));
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'manage_booking';
		$this->data['tbl_id']		=	'tblmng_booking';

		$this->data["booking_page"] = true;
		$this->data["is_agency"] = true;
		$this->data["export_button_href"] = base_url()."agency/bookings/export_booking_details";

		$this->data["categories"] = $this->categories_model->get_many_by('status','y');

		$this->locations_model->after_get_allow = false;
		$this->data["locations"] = $this->locations_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = true;

		$this->load->start_inline_scripting();
		echo "Appad.init_mng_boooking_list();";
		$this->load->end_inline_scripting(false,false);
		
		$this->view = "layouts/admin/datatable";		
		
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('b.id,b.booking_no,concat(u.firstName," ",u.lastName) as firstname,b.address,c.name,p.location_name as pickup_location_name,d.location_name as dropoff_location_name,b.pickup_date,b.dropoff_date,b.booking_date,b.booking_status,b.booking_price,api_reservation_id,pickup_time,dropoff_time',false)
		->join('users as u','u.id = b.user_id')
		->join('cars as c','c.id = b.car_id')
		->join('locations as p','p.id = b.pickup_location')
		->join('locations as d','d.id = b.dropoff_location')
		->edit_column('address', '$1', 'get_booking_address(address)')
		->edit_column('pickup_date', '$1', 'get_booking_datetime(pickup_date,pickup_time)')
		->edit_column('dropoff_date', '$1', 'get_booking_datetime(dropoff_date,dropoff_time)')
		->edit_column('booking_status', '$1', 'get_booking_status(booking_status,id,"")')
		->unset_column("api_reservation_id")
		->unset_column("pickup_time")
		->unset_column("dropoff_time")
		->where("refferal_id",$this->current_session["id"])
		->from('bookings as b');

		$minDate = $this->input->get("min_date");
		$max_date = $this->input->get("max_date");
		$pickup_location = $this->input->get("pickup_location");
		$category = $this->input->get("category");
		if($minDate != NULL && $max_date != NULL){
			$this->datatables->where('b.pickup_date >=', $minDate);
			$this->datatables->where('b.pickup_date <=', $max_date);
		}elseif($minDate != NULL && $max_date == NULL){
			$this->datatables->where('b.pickup_date >=', $minDate);
		}elseif($minDate == NULL && $max_date != NULL){
			$this->datatables->where('b.pickup_date <=', $max_date);
		}
		if($pickup_location > 0){
			$this->datatables->where('b.pickup_location =', $pickup_location);
		}
		if($category > 0){
			$this->datatables->where('b.car_category =', $category);
		}	


		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}


	public function export_booking_details()
	{
		$this->load->library('excel');
		$start_date = $this->input->post("start_date");
		$end_date = $this->input->post("end_date");
		$categories = $this->input->post("categories");
		$review_export = $this->input->post("review_export");

		$boookings_where[] = array('refferal_id = "'.$this->current_session["id"].'"',null,false);
		$boookings_where[] = array('booking_status IN("p","a","c")',null,false);
		$booking_export_array = array();
		
		if($start_date != "" && $end_date != "")
		{	
			$boookings_where[] = array('bookings.pickup_date >= "'.$start_date.'" AND bookings.dropoff_date <= "'.$end_date.'"',null,false);
		}	
		if($categories > 0)
		{
			$boookings_where[] = array('bookings.car_category = "'.$categories.'"',null,false);
		}	

		$this->bookings_model->after_get_user_info_allow = true;
		$booking_records = $this->bookings_model->order_by("id","desc")->get_many_by($boookings_where);
		$this->bookings_model->after_get_user_info_allow = false;
		$booking_total_amount = 0;

		if(!empty($booking_records))
		{
			$i = 1;

			if($review_export == "review_export")
			{
				$booking_export_array[0] = array("Name","Email","Booking date","Desciption","Order Ref","Product search code","Feedback Date","Customer Ref","Amount","Currency","Product link","Category","Logon");

				foreach ($booking_records as $key => $booking_data) 
				{

					if(empty($booking_data["user_info"]))
					{
						continue;
					}

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["firstname"]." ".$booking_data["user_info"]["lastname"];

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["email"];

					$booking_export_array[$i][]	= 	$booking_data["booking_date"];
					$booking_export_array[$i][]	= 	strip_tags($booking_data["car_info"]["description"]);
					$booking_export_array[$i][]	= 	(string)$booking_data["booking_no"];
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	"";
					$booking_export_array[$i][]	= 	$booking_data["booking_price"];
					$booking_export_array[$i][]	= 	"eur";
					$booking_export_array[$i][]	= 	base_url()."car/".$booking_data["car_id"];;
					$booking_export_array[$i][]	= 	$booking_data["car_info"]['category'];
					$booking_export_array[$i][]	= 	"";
					$i++;
				}

				$filename = 'review_details.xls'; 
				$file_title = "Review";
			}
			else
			{
				$filename = 'booking_details.xls'; 
				$file_title = "Bookings";
				$booking_export_array[0] = array("booking_no","Refferal","User Name","User Phone No","User Driving Licence No","Pickup Location","Pickup Date","Pickup Time","Dropoff Location","Dropoff Date","Dropoff Time","Car Name","Car Category","Booking Price","");
				foreach ($booking_records as $key => $booking_data) 
				{

					if(empty($booking_data["user_info"]))
					{
						continue;
					}

					$booking_export_array[$i][]	= 	(string)$booking_data["booking_no"];

					$booking_export_array[$i][]	= 	(isset($booking_data["refferal_name"]) && $booking_data["refferal_name"] != '') ? $booking_data["refferal_name"] : 'N/A';

					$booking_export_array[$i][]	= 	$booking_data["user_info"]["firstname"]." ".$booking_data["user_info"]["lastname"];
					$booking_export_array[$i][]	= 	(string)$booking_data["user_info"]["contactNo"];
					$booking_export_array[$i][]	= 	(string)$booking_data["user_info"]["drivinglicence_no"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_location_ar"]["location_name"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_date"];
					$booking_export_array[$i][]	= 	$booking_data["pickup_time"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_location_ar"]["location_name"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_date"];
					$booking_export_array[$i][]	= 	$booking_data["dropoff_time"];
					$booking_export_array[$i][]	= 	$booking_data["car_info"]["name"];
					$booking_export_array[$i][]	= 	$booking_data["car_info"]["category"];
					$booking_export_array[$i][]	= 	$booking_data["booking_price"];
					$booking_total_amount += $booking_data["booking_price"];
					$i++;
				}
			}


			$this->excel->setActiveSheetIndex(0);
			$this->excel->getActiveSheet()->setTitle($file_title );
			foreach(range('A','N') as $columnID) {
				$this->excel->getActiveSheet()->getColumnDimension($columnID)
				->setAutoSize(true);
			}
			$this->excel->getActiveSheet()->getStyle('A1:M1')->getFont()->setBold(true);
			$this->excel->getActiveSheet()->getProtection()->setSheet(true);
			$this->excel->getActiveSheet()->fromArray($booking_export_array);


			if($review_export == "review_export")
			{
				foreach (range('E', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('E'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}
			}
			else
			{
				foreach (range('A', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('A'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}

				foreach (range('D', $this->excel->getActiveSheet()->getHighestDataRow()) as $col) 
				{
					$this->excel->getActiveSheet()->getStyle('D'.$col)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER);
				}




			}


			header('Content-Type: application/vnd.ms-excel'); 
			header('Content-Disposition: attachment;filename="'.$filename.'"'); 
			header('Cache-Control: max-age=0'); 
			$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
			$objWriter->save('php://output');
		}
		else{
			$this->session->set_flashdata("error",lang("NO_BOOKING_REC_FOUND"));
			redirect($this->current_url.'agency/dashboard');
		}
	}


}
