<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_slider extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("slider_img_model");
		$this->page ='admin/manage_slider/';
		$this->current_url = base_url()."admin/manage_slider/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	public function index()
	{
		$this->grid_resorces();
		$this->load->js('plugins/mediaelements/build/mediaelement-and-player.js');
		$this->load->css('plugins/mediaelements/build/mediaelementplayer.css');
		$this->output->set_title(lang("Manage Slider Images"));
		$this->page_name = lang("Manage Slider Images");
		$this->data['page_url']	=	'manage_slider';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_slider';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_slider();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,image,caption,status,type',false)
		->edit_column('image', '$1', 'display_image(id,image,"slider",null,150,type)') 
		->edit_column('status', '$1', 'get_status(status,id,"manage_contents/change_user_status")')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		->unset_column("type")
		->from('slider_img');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		if($this->input->post())
		{
			$data = array();
			$data['created']	=	date("Y-m-d H:i:s");
			$data['caption'] = $this->input->post('caption');
			$data['link'] = $this->input->post('link');
			$status = $this->slider_img_model->insert($data);
			if($status)
			{
				$this->session->set_flashdata('message',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}
			else{
				$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
				$this->session->set_flashdata('error',$msg_t);
				redirect($this->current_url."add");
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add Slider Image";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->view = $this->page."add_edit_slider";
		}
	}

	public function edit($id=NULL)
	{
		if($id != NULL && $id > 0){
			if($this->input->post())
			{
				$data = array();
				$data['caption'] = $this->input->post('caption');
				$data['link'] = $this->input->post('link');
				$data['id'] = $id;

				$update_status = $this->slider_img_model->update($id,$data);
				if($update_status) 
				{
					$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
					redirect($this->current_url,"refresh");
				}else{
					$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
					$this->session->set_flashdata('error',$msg_t);
					redirect($this->current_url.'edit/'.$id,"refresh");
				}
			}
			else if(!$this->input->post()){
				$this->data["slider_data"] = $this->slider_img_model->as_array()->get($id);
				if($this->data["slider_data"])
				{
					$text = "Edit Slider Image - ".$this->data["slider_data"]["caption"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));


					$exist_check_path = FCPATH."assets/nova/slider/".$this->data["slider_data"]["image"];			
					if(file_exists($exist_check_path) && $exist_check_path!="")
					{
						$this->data["image_url"] = base_url()."image/slider/200/200/".$this->data["slider_data"]["image"];
					}
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit_slider";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{
		
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$slider_id = $this->input->post('slider_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			$this->load->model("slider_img_model");
			if($slider_id > 0){
				$this->slider_data = $this->slider_img_model->set_fields("id,status")->as_array()->get($slider_id);
			
				if(!empty($this->slider_data))
				{
					if($this->slider_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$this->slider_img_model->is_image_uploaded = false;
					$response = $this->slider_img_model->update($slider_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->slider_img_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_slider";

			}
		}
	}
}
