<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class manage_refferal_booking extends My_Controller
{
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		$this->from_admin = "true";
		parent::__construct();
		$this->_init();		
		$this->modal_name = "refferal_list_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_refferal_booking/';
		$this->current_url = base_url()."admin/manage_refferal_booking/";
		$this->load->helper('string');
		$this->table_id = "tblmng_refferal_booking";
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
	}
	public function index()
	{	
		
		$this->grid_resorces();
		$this->page_name = lang("Manage Referral Booking");
		$this->output->set_title(lang("Manage Referral Booking"));
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'manage_refferal_booking';
		$this->data['tbl_id']		=	$this->table_id;
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_refferal_boooking_list();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,name,url,bookings,code,share_url,createdDate,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"manage_refferal_bookings/change_status")')
		->edit_column('share_url', '$1', 'get_refferal_share_url(share_url,id)')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('refferal_list');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	
	public function add()
	{	
		if($this->input->post())
		{
			$name = $this->input->post('name');
			$email_post = $this->input->post('email');
			$password = $this->input->post('password');			
			$url = $this->input->post('url');
			$code = $this->input->post('code');
			$share_url = $this->input->post('share_url');
			$data = array(
				'name' => $name,
				'email' => $email_post,
				'password' => $password,
				'url' => $url,
				'code' => $code,
				'share_url' => $share_url,
				'createdDate' => date('Y-m-d H:i:s')
				);

			if($this->input->post('booking_form_title') != '')
			{
				$data["booking_form_title"] = $this->input->post('booking_form_title');
			}

			$status = $this->{$this->modal_name}->insert($data);
			if($status)
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}
			else{
				$this->session->set_flashdata('error',lang(validation_errors()));
				redirect($this->current_url."add");	
			}
		}

		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->page_type = 'add';
			$this->page_name = lang("Add Refferal");
			$this->output->set_title(lang("Add Refferal"));
			$this->data['page_url']	=	'manage_refferal_booking/add';
			$this->data['form_url']	= $this->current_url.'/add';	
			$this->data["dispAllfield"] = true;
			$code = date("d").random_string('alnum', 5);
			$this->data["code"] = $code;
			$this->data["share_url"] = "<iframe src='".base_url()."referral_booking/".$code."'></iframe>";
			/*	$share_url = '<div id="tt-div"></div><script language="javascript" type="text/javascript">var headID = document.getElementsByTagName("head")[0];var ttScript = document.createElement("script");var nova_client = "'.$code.'";ttScript.type = "text/javascript";ttScript.src = "'.base_url().'assets/nova/js/refferal.js";var siterefurl = "'.base_url().'";headID.appendChild(ttScript);</script>';	*/
			$share_url = '<div id="nova-booking"></div>&#13;&#10;';
			$share_url .= '<script language="javascript" type="text/javascript">&#13;&#10;';
			$share_url .= 'var nova_client = "'.$code.'";&#13;&#10;';
			$share_url .= 'var nova_width = "100%";&#13;&#10;';
			$share_url .= 'var nova_height = "650";&#13;&#10;';
			$share_url .= '</script>&#13;&#10;';
			$share_url .= '<script type="text/javascript" src="'.base_url().'assets/nova/js/refferal.js"></script>';
			/*$this->data["share_url"] = "<iframe src='".base_url()."referral_booking/".$code."'></iframe>";*/
			$this->data["share_url"] = $share_url;
			$this->data["password"] = random_string('alnum', 8);
			$this->view = $this->page."add_edit";		
		}
	}

	public function edit($id)
	{
		$where = array('id'=>$id);
		$referral_data = $this->{$this->modal_name}->get_by($where);
		if(!empty($referral_data))
		{
			if($this->input->post())
			{
				/*$email_post = $this->input->post('email');*/
				$name = $this->input->post('name');
				$url = $this->input->post('url');
				$code = $this->input->post('code');
				$share_url = $this->input->post('share_url');
				$data = array(
					/*'email' => $email_post,*/
					'name' => $name,
					'url' => $url,
					'code' => $code,
					'share_url' => $share_url,
					);

				$data["id"] = $id;

				if($this->input->post('booking_form_title') != '')
				{
					$data["booking_form_title"] = $this->input->post('booking_form_title');
				}

				$status = $this->{$this->modal_name}->update($id,$data,true);
				if($status)
				{
					$this->session->set_flashdata('success',lang("MSG_REC_EDIT"));
					redirect($this->current_url);				
				}
				else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."edit/".$id);	
				}
			}	

			if(!$this->input->post())
			{
				$this->page_type = 'edit';
				$this->page_name = lang("Edit Refferal");
				$this->output->set_title(lang("Edit Refferal"));
				$this->data['page_url']	=	'manage_refferal_booking/edit';
				$this->data['form_url']	= $this->current_url.'/edit/'.$id;	
				$this->data["code"] = $referral_data["code"];
				/*$this->data["email"] = $referral_data["email"];*/
				$this->data["name"] = $referral_data["name"];
				$this->data["url"] = $referral_data["url"];
				$this->data["share_url"] = $referral_data["share_url"];
				$this->data["booking_form_title"] = $referral_data["booking_form_title"];				
				$this->view = $this->page."add_edit";
			}
		}
		else
		{
			$this->session->set_flashdata("error",lang("INVLID_BOOKING_ID"));
			redirect(base_url()."bookings","refresh");
		}
		$this->view = $this->page."add_edit";		
	}


	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$booking_id = $this->input->post('booking_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($booking_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($booking_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($booking_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id)
	{
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
	/* end of the delete user code */

}
