<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_pricing extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "pricing_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_pricing/';
		$this->current_url = base_url()."admin/manage_pricing/";
		$this->table_id = "tblmng_pricing";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index($type='',$id='',$advance_id = 0)
	{
		$this->grid_resorces();
		$text = "Manage Pricing";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$advance_price_id = 0;
		if($this->input->get("type") && $type == '')
		{
			$data['type'] =$this->input->get("type");
			$advance_price_id =  $this->input->get('advance_id');
		}
		else if($type != '')
		{
			$data['type']	= $type;
		}
		else{
			$data['type']	='b';
		}

		if($advance_id > 0)
		{
			$advance_price_id =  $advance_id;
		}	


		if($data['type'] == 'b'){
			$this->data['add_button_href']	=	$this->current_url.'add_pricing';
			$editurl = $this->current_url."edit_pricing";
		}elseif($data['type'] == 'a'){
			$this->data['add_button_href']	=	$this->current_url.'add_advanced_pricing';
			$editurl = $this->current_url."edit_advanced_pricing";

			$this->data['backbutton']	=	true;
			$this->data['backbutton_href']	=	$this->current_url.'add_advanced_pricing';

		}
		if($id > 0){
			$this->data['add_button_href']	=	$this->current_url.'add_advanced_pricing';
		}
		$this->data['pricingtype'] = $data['type'];
		/*var_dump($type);exit();*/		
		$this->data['tbl_id']	=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_pricing();";
		echo "Appad.init_manage_pricing_operations();";		
		$this->load->end_inline_scripting(false,false);
		$this->data['dispDropDown']=true;
		$this->view = "layouts/admin/datatable";		

		$deleteurl = $this->current_url."delete";
		$advancedurl = $this->current_url."";

		$array = array(
			'edit'=>$editurl,
			'delete'=>$deleteurl,
			'view_advanced_price'=>$advancedurl
			);
		if($data['type'] == "a")
		{
			$array["is_advanced"] = true;
		}
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('DISTINCT dp.pricingId as dppricingid,p.id,cat.category,s.season_name,p.categoryId',false)		
		->join('day_price as dp','dp.pricingId = p.id')
		->join('categories as cat','cat.id = p.categoryId')
		->join('season as s','s.id = p.seasonId','left')	
		->add_column('price', '$1', 'get_pricing(id)')		
		->edit_column('season_name', '$1', 'get_season_name(season_name,seasonId)')
		->add_column('operation',get_operation_btn('$1',$array,null,'$2'),'id,categoryId')
		->unset_column("categoryId")
		->unset_column("dppricingid")
		->where('type',$data['type']);

		if($advance_price_id > 0){
			$this->datatables->where('p.categoryId',$advance_price_id);
		}

		$this->datatables->from('pricing as p');		

		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add_pricing()
	{

		$data = array();
		if($this->input->post())
		{
			$categoryId = $this->input->post('categoryId');
			$where_ar = array("type"=>'b',"categoryId"=>$categoryId);
			$exist_check = $this->{$this->modal_name}->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add_pricing");	
			}
			else{
				$data = array(
					'categoryId' => $categoryId,
					'type' => 'b',
					'seasonId' => 0,					
					'created' => date('Y-m-d H:i:s'),
					'updated' => date('Y-m-d H:i:s')
					);
				$status = $this->{$this->modal_name}->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add_pricing");	
				}				
			}
		}
		if(!$this->input->post())
		{
			$this->load->model("categories_model");
			$this->load->model("rental_days_model");
			$this->page_type = 'add';
			$text = "Add Basic Pricing";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add_pricing";
			$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by('status','y');
			$this->data["days"] = $this->rental_days_model->set_fields("id,day")->order_by("day")->get_many_by('status','y');
			$this->view = $this->page."pricing_add_edit";
		}
	}

	public function edit_pricing($id=NULL){

		if($id != NULL && $id > 0){
			$data = array();
			$this->data["pricing_data"] = $this->{$this->modal_name}->as_array()->get($id);
			if($this->input->post())
			{
				$categoryId = $this->input->post('categoryId');
				$where_ar[] = array("categoryId = '".$categoryId."'",null,false);
				$where_ar[] = array("id != '".$id."' AND type='b'",null,false);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit_pricing/".$id);	
				}
				else{				
					$data = array(
						'categoryId' => $categoryId,
						'type' => 'b',
						'updated' => date('Y-m-d H:i:s')
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
							/*redirect($this->current_url.'edit_pricing/'.$id,"refresh");*/
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit_pricing/'.$id,"refresh");
						}
					}					
				}
			}
			else if(!$this->input->post())
			{

				if($this->data["pricing_data"])
				{
					$this->load->model("categories_model");
					$this->load->model("rental_days_model");
					$this->load->model("day_price_model");

					$text = "Edit Basic Pricing";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit_pricing/'.$id;	
					$this->data["action"] = "edit";
					
					$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by('status','y');
					$this->data["days"] = $this->rental_days_model->set_fields("id,day")->order_by("day")->get_many_by('status','y');

					$day_price_where = array("pricingId"=>$id);
					$pricing_day_data = $this->day_price_model->get_many_by($day_price_where);
					
					if(!empty($pricing_day_data))
					{
						$pricing_day_data_ar = array();
						foreach ($pricing_day_data as $key => $value) {
							if($value['dayId'] != NULL && $value['dayId'] != ''){
								$pricing_day_data_ar[$value['dayId']] = $value['price'];
							}
						}
					}
					$this->data['pricing_day_data'] = $pricing_day_data_ar;
					$this->view = $this->page."pricing_add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function add_advanced_pricing()
	{
		$data = array();
		if($this->input->post())
		{
			$categoryId = $this->input->post('categoryId');
			$seasonId = $this->input->post('seasonId');
			
			$where_ar = array("type"=>'a',"categoryId"=>$categoryId,"seasonId"=>$seasonId);
			$exist_check = $this->{$this->modal_name}->join("day_price as dp","dp.pricingId = pricing.id")->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add_advanced_pricing");	
			}
			else{
				$data = array(
					'categoryId' => $categoryId,
					'type' => 'a',
					'seasonId' =>$seasonId,					
					'created' => date('Y-m-d H:i:s'),
					'updated' => date('Y-m-d H:i:s')
					);


				$this->{$this->modal_name}->validate = array(
					'categoryId'  => array(
						'field' => 'categoryId',
						'label' => 'Category',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
							),
						),
					'seasonId'  => array(
						'field' => 'seasonId',
						'label' => 'Season',
						'rules' => 'trim|required|xss_clean',
						'error_msg' => array(
							'required'  => 'lang:CAR_SEASON_REQUIRED',				
							),
						),
					);

				$status = $this->{$this->modal_name}->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					/*redirect($this->current_url."advanced");	*/
					redirect($this->current_url.'view_advance_pricing/'.$categoryId,"refresh");

				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add_advanced_pricing");	
				}				
			}
		}
		if(!$this->input->post())
		{
			$this->load->model("categories_model");
			$this->load->model("rental_days_model");			
			$this->load->model("season_model");
			$this->page_type = 'add';
			$text = "Add Advanced Pricing";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add_advanced_pricing";
			$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by('status','y');
			$this->data["seasons"] = $this->season_model->set_fields("id,season_name")->get_many_by('status','y');
			$this->data["days"] = $this->rental_days_model->set_fields("id,day")->order_by("day")->get_many_by('status','y');
			$this->view = $this->page."advanced_pricing_add_edit";
		}
	}


	public function edit_advanced_pricing($id=NULL)
	{
		if($id != NULL && $id > 0)
		{
			$data = array();
			$this->data["pricing_data"] = $this->{$this->modal_name}->as_array()->get($id);



			if($this->input->post())
			{
				$categoryId = $this->input->post('categoryId');
				$seasonId = $this->input->post('seasonId');

				$where_ar[] = array("pricing.categoryId = '".$categoryId."'",null,false);
				$where_ar[] = array("pricing.seasonId = '".$seasonId."'",null,false);
				$where_ar[] = array("pricing.id != '".$id."'",null,false);
				$where_ar[] = array("pricing.type = 'a'",null,false);

				$exist_check = $this->{$this->modal_name}->join("day_price as dp","dp.pricingId = pricing.id")->get_by($where_ar);

				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit_advanced_pricing/".$id);	
				}
				else{				
					$data = array(
						'categoryId' => $categoryId,
						'seasonId' => $seasonId,
						'type' => 'a',
						'updated' => date('Y-m-d H:i:s')
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							/*redirect($this->current_url."advanced","refresh");*/
							/*redirect($this->current_url.'edit_advanced_pricing/'.$id,"refresh");*/
							redirect($this->current_url.'view_advance_pricing/'.$this->data["pricing_data"]["categoryId"],"refresh");
						}
						else
						{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit_advanced_pricing/'.$id,"refresh");
						}
					}					
				}
			}
			else if(!$this->input->post())
			{
				if($this->data["pricing_data"])
				{
					$this->load->model("categories_model");
					$this->load->model("rental_days_model");
					$this->load->model("day_price_model");
					$this->load->model("season_model");
					
					$text = "Edit Advanced Pricing";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit_advanced_pricing/'.$id;	
					$this->data["action"] = "edit";
					
					$this->data["categories"] = $this->categories_model->set_fields("id,category")->get_many_by('status','y');
					$this->data["days"] = $this->rental_days_model->set_fields("id,day")->order_by("day")->get_many_by('status','y');

					$this->data["seasons"] = $this->season_model->set_fields("id,season_name")->get_many_by('status','y');


					$day_price_where = array("pricingId"=>$id);
					$pricing_day_data = $this->day_price_model->get_many_by($day_price_where);
					
					if(!empty($pricing_day_data))
					{
						$pricing_day_data_ar = array();
						foreach ($pricing_day_data as $key => $value) {
							if($value['dayId'] != NULL && $value['dayId'] != ''){
								$pricing_day_data_ar[$value['dayId']] = $value['price'];
							}
						}
					}
					$this->data['pricing_day_data'] = $pricing_day_data_ar;

					$this->data['cancel_url'] = $this->current_url.'view_advance_pricing/'.$this->data["pricing_data"]["categoryId"];

					/*printr($this->data['pricing_day_data']);
					exit();*/
					$this->view = $this->page."advanced_pricing_add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	public function view_advance_pricing($id = 0)
	{
		$this->load->model("pricing_model");
		$this->load->model("rental_days_model");

		$dataHtml = array();
		$final_array 	=  array();
		$final_season	=  array();	
		$seasonNameFinal=	array();
		$finalDataAll =	array();

		$field_id = $this->input->post('field_id');
		$adv_fld_id = ($id > 0) ? $id : $this->input->post('adv_fld_id');

		
		$this->pricing_model->after_get_allow = true;
		$p_where_ar[] = array("categoryId = '".$adv_fld_id."' AND type = 'a'",null,false); 
		$dataMain = $this->pricing_model->get_many_by($p_where_ar);
		$dataRental_days = $this->rental_days_model->order_by("day")->get_many_by('status','y');
		$this->pricing_model->after_get_allow = false;
		$cat_name = '';
		$this->data["html"] ='<table class="table dataTable no-footer"><thead><tr><th>'.$dataMain[0]["category"].' </th>'; 
		foreach ($dataRental_days as $key => $value_d) {
			$this->data["html"] .='<th> Day '.$value_d["day"].' </th>';
		}
		$this->data["html"] .='<tr></thead><tbody>';
		if(!empty($dataMain))
		{
			$i=0;
			$hasTypeAdvance = false;
			if($this->isAjax)
			{
				/*printr($dataMain);*/
			}
			
			foreach ($dataMain as $key => $value) 
			{
				if($value['price_type'] == 'a')
				{
					$hasTypeAdvance = true;
				}	
				$this->data["html"] .='<tr><th>'.$value['season'];


				if($value["season_date"] != '')
				{
					$this->data["html"] .= " (".$value["season_date"].") ";
				}				
				$this->data["html"] .='</th>';
				foreach ($dataRental_days as $k => $v) 
				{
					$dispVal = ($value['pricing_ar'][$v["id"]] > 0) ?  $value['pricing_ar'][$v["id"]] : 'N/A';
					$this->data["html"] .='<th>'.$dispVal.'</th>';
				}
				$this->data["html"] .='</tr>';
			}
			$this->data["html"] .= '</tbody></table>';
		}


		if($this->isAjax)
		{
			$this->view = false;
			$this->layout = false;
			$this->json = true;
		}
		else if($id > 0)
		{
			/*$this->index('a',$id,$id);*/

			$this->grid_resorces();
			$text = "Manage Pricing";
			$this->output->set_title(lang($text));
			$this->page_name = lang($text);
			$this->data['add_button'] = true;
			$advance_price_id = $id;

			$this->data["extra_header_table"] = $this->data["html"];
			unset($this->data["html"]);
			
			$this->data['add_button_href']	=	$this->current_url.'add_advanced_pricing';
			$editurl = $this->current_url."edit_advanced_pricing";
			$this->data['backbutton']	=	true;
			$this->data['backbutton_href']	=	$this->current_url.'add_advanced_pricing';

			$this->data['pricingtype'] = 'a';
			$this->data['tbl_id']	=	$this->table_id;

			$this->session->set_userdata("adv_fld_id_js",$id);

			$this->load->start_inline_scripting();
			echo "Appad.init_mng_pricing();";
			echo "Appad.init_manage_pricing_operations();";		
			/*echo "var adv_fld_id_js = '".$id."'";	*/	
			$this->load->end_inline_scripting(false,false);
			$this->data['dispDropDown']=true;
			$this->view = "layouts/admin/datatable";		

			$deleteurl = $this->current_url."delete";
			$advancedurl = $this->current_url."";

			$array = array(
				'edit'=>$editurl,
				'delete'=>$deleteurl,
				'view_advanced_price'=>$advancedurl
				);
			if($data['type'] == "a")
			{
				$array["is_advanced"] = true;
			}

			$this->load->library('Datatables');
			$this->load->helper('datatable_helper');
			
			$this->datatables->select('p.id,cat.category,s.season_name,p.categoryId',false)
			->join('categories as cat','cat.id = p.categoryId')
			->join('season as s','s.id = p.seasonId','left')	
			->add_column('price', '$1', 'get_pricing(id)')		
			->edit_column('season_name', '$1', 'get_season_name(season_name,seasonId)')
			->add_column('operation',get_operation_btn('$1',$array,null,'$2'),'id,categoryId')
			->unset_column("categoryId")
			->where('type','a');

			$this->datatables->where('p.categoryId',$advance_price_id);
			$this->datatables->from('pricing as p');		

			if($this->isAjax)
			{
				$this->layout=false;
				$this->view=false;
				echo $this->datatables->generate();
				exit;
			}
			$results = $this->datatables->generate('raw');
			$this->data['columns'] = $results['columns'];
		}
	}

	public function delete($id)
	{
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
