<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_newsletter_template extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "newsletter_template_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_newsletter_template/';
		$this->current_url = base_url()."admin/manage_newsletter_template/";
		$this->table_id = "tblmng_newsletter_template";
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Newsletter Templates";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->view = "layouts/admin/datatable";	
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_newsletter_templates();";
		$this->load->end_inline_scripting(false,false);	
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$send_email_url = $this->current_url."send";
		
		$array = array(
			'delete'=>$deleteurl,
			"edit"=>$editurl,
			"send_email"=>$send_email_url
			);

		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('n.id,n.subject,n.message,n.status',false)
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('newsletter_template as n');
		if($this->isAjax){
			$this->layout = false;
			$this->view = false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function send($id)
	{

		if($this->isAjax)
		{
			$this->load->model("newsletter_model");
			$this->load->model("newsletter_template");

			$template_data = $this->newsletter_template->get($id);

			if(!empty($template_data))
			{
				$subject = $template_data['subject'];
				$message = $template_data['message'];

				/*Mail code*/
				$newsletter_users = $this->newsletter_model->get_many_by("status",'y');
				if(!empty($newsletter_users))
				{
					foreach ($newsletter_users as $key => $value) 
					{
						send_mail(null,array(), array(),$value["email"],$message,$subject);
					}
				}
				/*Mail code ends*/
				$this->data["success"] = true;
				$this->data["msg"] = lang("NEWSLETTER_SENT_SUCCESSFULLY");
			}
			else
			{
				$this->data["success"] = true;
				$this->data["msg"] = lang("INVALID_NEWSLETTER_ID");
			}
		}
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$subject = $this->input->post('subject');
			$message = $this->input->post('message');
			
			$data = array(
				'subject' => $subject,
				'message' => $message,
				'createdDate'=>date('Y-m-d H:i:s')
				);
			$status = $this->{$this->modal_name}->insert($data);
			if($status)
			{
				$this->session->set_flashdata('success',lang(MSG_REC_ADD));
				redirect($this->current_url);				
			}else{
				$this->session->set_flashdata('error',lang(validation_errors()));
				redirect($this->current_url."add");	
			}
			
		}
		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->page_type = 'add';
			$text = "Add Newsletter Template";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";			
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			$this->data["template_data"] = $this->{$this->modal_name}->as_array()->get($id);
			
			if($this->input->post())
			{
				$subject = $this->input->post('subject');
				$message = $this->input->post('message');

				$data = array(
					'subject' => $subject,
					'message' => $message						
					);

				if(!empty($data))
				{
					$update_status = $this->{$this->modal_name}->update($id,$data);

					if(!empty($update_status)) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url,"refresh");
					}else{
						$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
				}
				
			}
			else if(!$this->input->post()){
				$this->load->helper(array('url','language'));
				$this->load->js("plugins/ckeditor/ckeditor.js");
				if($this->data["template_data"])
				{
					$text = "Edit Template";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;
					$this->data["message"] = $this->data["template_data"]["message"];
					$this->data["subject"] = $this->data["template_data"]["subject"];
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}
	
	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$template_id = $this->input->post('template_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($template_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($template_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($template_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
