<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_currencies extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "currencies_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_currencies/';
		$this->current_url = base_url()."admin/manage_currencies/";
		$this->table_id = "tblmng_currencies";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{

		$this->grid_resorces();
		$text = "Manage Currencies";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_currencies();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,code,symbol,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('currencies');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$currency_code_post = $this->input->post('currency_code');
			$where_ar = array("code"=>$currency_code_post);
			$exist_check = $this->{$this->modal_name}->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'code' => $currency_code_post,
					'symbol' => $this->input->post('currency_symbol')
					);
				$status = $this->{$this->modal_name}->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add Currency";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			if($this->input->post())
			{
				$currency_code_post = $this->input->post('currency_code');
				$where_ar[] = array("code = '".$currency_code_post."' AND id != '".$id."'",null,null);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{
					$data = array(
						'code' => $currency_code_post,
						'symbol' => $this->input->post('currency_symbol')
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->{$this->modal_name}->get_insurance_details = true;
				$this->data["currency_data"] = $this->{$this->modal_name}->as_array()->get($id);
				if($this->data["currency_data"])
				{
					$text = "Edit Currency - ".$this->data["currency_data"]["code"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	

	public function change_status()
	{

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$cid = $this->input->post('cid');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($cid > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($cid);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($cid,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
