<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_constants extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("constant_model");
		$this->page ='admin/manage_constants/';
		$this->current_url = base_url()."admin/manage_constants/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	public function index()
	{

		$this->grid_resorces();
		$text = "Manage Constant";
		$this->page_name = lang($text);
		$this->output->set_title(lang($text));
		$this->data['tbl_id']		=	'tblmng_constant';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_constant();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$array = array('edit'=>$editurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->db->query("SET @row_number:=0;");
		$this->datatables->select("@row_number:=@row_number+1 as No",false);
		$this->datatables->select('id,constantName,constantValue',false)
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		->unset_column('id')
		->from('constant');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];		
	}

	public function add(){
		if($this->input->post())
		{
			$data = array(
				'constantName' => $this->input->post('constant_name'),
				'constantValue' => $this->input->post('constant_value'),
				'type' =>'m',
				'createdDate' =>date('Y-m-d H:i:s'),

				);



			$exist_check = $this->constant_model->get_by('constantName',$this->input->post('constant_name'));

			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(PLEASE_TRY_AGAIN));
				redirect($this->current_url."add","refresh");
			}
			else{
				$id = $this->constant_model->insert($data);
				if($id > 0) 
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url."add","refresh");
				}else{
					$this->session->set_flashdata('error',lang(PLEASE_TRY_AGAIN));
					redirect($this->current_url."add","refresh");
				}
			}

			
		}else{
			$text = "Add Constant"; 
			$this->page_type = 'add';
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url.'add';	
			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			if($this->input->post()){

				$data = array(
					'constantValue' => $this->input->post('constant_value')
					);
				$update_status = $this->constant_model->update($id,$data);
				if($update_status) 
				{
					$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
					redirect($this->current_url,"refresh");
				}else{
					$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
					redirect($this->current_url.'edit/'.$id,"refresh");
				}
			}else if(!$this->input->post()){
				$this->data["constant_data"] = $this->constant_model->as_array()->get($id);
				if($this->data["constant_data"])
				{
					$text = "Edit Constant - ".$this->data["constant_data"]["constantName"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->constant_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
			}
		}
	}
}
