<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_car_facilities extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "car_facilities_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_car_facilities/';
		$this->current_url = base_url()."admin/manage_car_facilities/";
		$this->table_id = "tblmng_car_facilities";
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{

		$this->grid_resorces();
		$text = "Manage Facilities";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_car_facilities();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,facility_name,price,daily_cost,maximum_cost,status',false)
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->edit_column('daily_cost', '$1', 'get_daily_cost_text(daily_cost,id)')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('car_facilities');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$facility_name_post = $this->input->post('facility_name');
			$description = $this->input->post('description');
			$price = $this->input->post('price');
			$maximum_cost = $this->input->post('maximum_cost');
			$daily_cost = $this->input->post('daily_cost');
			$type = $this->input->post('type');
			$multiple_maximum = $this->input->post('multiple_maximum');
			$popup_title = $this->input->post('popup_title');
			$popup_desc = $this->input->post('popup_desc');
			$exist_check = $this->{$this->modal_name}->get_by("facility_name",$facility_name_post);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'facility_name' => $facility_name_post,
					'description' => $description,
					'price' => $price,
					'maximum_cost' => $maximum_cost,
					'daily_cost' => $daily_cost,
					'type'=>$type,
					'multiple_maximum'=>$multiple_maximum,
					'popup_title'=>$popup_title,
					'popup_desc'=>$popup_desc,
					'created'=>date('Y-m-d H:i:s')
					);
				$status = $this->{$this->modal_name}->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
			
		}
		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->page_type = 'add';
			$text = "Add Facility";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";

			$this->load->start_inline_scripting();
			echo "Appad.init_mng_car_facilities_operations();";
			$this->load->end_inline_scripting(false,false);


			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL)
	{
		if($id != NULL && $id > 0)
		{
			$data = array();
			if($this->input->post())
			{
				$facility_name_post = $this->input->post('facility_name');
				$description = $this->input->post('description');
				$price = $this->input->post('price');
				$maximum_cost = $this->input->post('maximum_cost');
				$daily_cost = $this->input->post('daily_cost');
				$type = $this->input->post('type');
				$multiple_maximum = $this->input->post('multiple_maximum');
				$popup_title = $this->input->post('popup_title');
				$popup_desc = $this->input->post('popup_desc');
				
				$where_ar[] = array("facility_name = '".$facility_name_post."' AND id != '".$id."'",null,null);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{
					$data = array(
						'facility_name' => $facility_name_post,
						'description' => $description,
						'price' => $price,
						'maximum_cost' => $maximum_cost,
						'daily_cost' => $daily_cost,
						'type'=>$type,
						'multiple_maximum'=>$multiple_maximum,
						'popup_title'=>$popup_title,
						'popup_desc'=>$popup_desc,
						'id'=>$id
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["facility_data"] = $this->{$this->modal_name}->as_array()->get($id);
				if($this->data["facility_data"])
				{
					$this->load->helper(array('url','language'));
					$this->load->js("plugins/ckeditor/ckeditor.js");
					$text = "Edit Facilities - ".$this->data["facility_data"]["facility_name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";

					$path = 'assets/upload/facilities/'.$this->data["facility_data"]["image"];
					if(!file_exists(FCPATH.$path) && $path!="")
					{
						$this->data["image_url"]  = base_url()."assets/images/no_available_image.gif"; 
					}
					else
					{
						$this->data["image_url"] = base_url().$path; 
					}	

					$this->load->start_inline_scripting();
					echo "Appad.init_mng_car_facilities_operations();";
					$this->load->end_inline_scripting(false,false);
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$facility_id = $this->input->post('facility_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($facility_id > 0){
				$this->group_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($facility_id);
				if(!empty($this->group_data))
				{
					if($this->group_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($facility_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
