<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MY_Controller {

	function __construct()

	{

		$this->login_type	= 'admin';

		$this->access   = 'login';

		$this->permission_check   = false;		

		parent::__construct();

		$this->_init();

	}

	private function _init()

	{

		$this->sections['section_header'] = 'sections/admin/header';

		$this->sections['section_sidebar'] = 'sections/admin/menu';

		$this->sections['section_footer'] = 'sections/admin/footer';	

		$this->current_url = base_url()."admin/dashboard/";	

		$this->booking_url = base_url()."admin/manage_booking/";	

	}

	public function index()

	{

		$this->load->library('Datatables');

		$this->load->helper('datatable_helper');



		$this->load->model("bookings_model");

		$this->load->model("cars_model");



		$this->load->js('nova/js/amcharts.js');

		$this->load->js('nova/js/serial.js');



		$this->load->js('js/components-date-time-pickers.js');

		$this->load->model("locations_model");

		$this->load->model("categories_model");

		$this->grid_resorces();



		$this->output->set_title(lang("Dashboard"));

		

		$this->load->js('plugins/datatables/jquery.dataTables.min.js');

		$this->data['tbl_id']		=	'tblmng_booking_dashboard';

		

		/*$this->data["categories"] = $this->categories_model->get_many_by('status','y');		

		$this->data["locations"] = $this->locations_model->get_many_by('status','y');*/

		

		$editurl = $this->booking_url."edit";

		$deleteurl = $this->booking_url."delete";		

		

		$array = array('edit'=>$editurl,'delete'=>$deleteurl);

		

		$this->datatables->select('b.id,b.booking_no,concat(u.firstName," ",u.lastName) as firstname,c.name,b.booking_price,p.location_name as pickup_location_name,d.location_name as dropoff_location_name,b.pickup_date,b.dropoff_date,b.booking_date,b.booking_status,b.driverage',false)

		->join('users as u','u.id = b.user_id')

		->join('cars as c','c.id = b.car_id')

		->join('locations as p','p.id = b.pickup_location')

		->join('locations as d','d.id = b.dropoff_location')

		->add_column('operation',get_operation_btn('$1',$array),'id')			

		->where("b.booking_status",'p')

		->unset_column("booking_status")

		->from('bookings as b');

		

		$this->load->start_inline_scripting();

		echo "Appad.init_dashboard_boooking_list();";

		$this->load->end_inline_scripting(false,false);



		if($this->isAjax)

		{

			$this->layout=false;

			$this->view=false;

			echo $this->datatables->generate();

			exit;

		}	

		else{

			$results = $this->datatables->generate('raw');

			$this->data['columns'] = $results['columns'];

			$where_booking_ar[] = array('booking_status ="a"',null,false);

			



			$this->bookings_model->after_get_allow = false;

			$total_money_ar = $this->bookings_model->set_fields("SUM(booking_price) AS total_booking_price")->get_by($where_booking_ar);

			$total_booking_ar = $this->bookings_model->set_fields("COUNT(id) AS total_bookings")->get_by('booking_status','a');



			$top_booked_cars =  $this->bookings_model->set_fields("count(bookings.id) as totalbookings,cars.name")->join('cars', 'cars.id = bookings.car_id')->get_by('booking_status','a');		



			$dateVal = $start_date = date('Y-m-d');

			$end_date	='';



			$where_ar[]  = array('dropoff_date',$dateVal,false); 

			$where_ar[]  = array('booking_status="a"',null,false); 

			$total_cars_arriving_ar = $this->bookings_model->set_fields("COUNT(id) AS total_cars_arriving")->get_by($where_ar);





			$where_ar1[]  = array('pickup_date',$dateVal,false); 

			$where_ar1[]  = array('booking_status="a"',null,false);

			$total_cars_leaving_ar = $this->bookings_model->set_fields("COUNT(id) AS total_cars_leaving")->get_by($where_ar1);

			$this->bookings_model->after_get_allow = true;



			$this->data['total_money'] = 	($total_money_ar["total_booking_price"] > 0) ? $total_money_ar["total_booking_price"] : 0;

			$this->data['total_booking'] = $total_booking_ar["total_bookings"];

			$this->data['top_booked_cars'] = $top_booked_cars;

			$this->data['total_cars_arriving'] = $total_cars_arriving_ar["total_cars_arriving"];

			$this->data['total_cars_leaving'] = $total_cars_leaving_ar["total_cars_leaving"];;



			$this->load->start_inline_scripting();

			echo "Appad.initDashboard();";

			$this->load->end_inline_scripting(false,false);

			$this->data["booking_grid"] = $this->load->view("layouts/admin/datatable",$this->data,true);

			$this->view = "admin/dashboard/index";	

		}





	}



	public function count_data()

	{

		if($this->isAjax)

		{

			$this->view = false;

			$this->layout = false;

			$this->json = true;



		}

		else{

			$this->session->set_flashdata("error",lang("INVALID_URL"));

			redirect(base_url(),"redirect");

		}	

	}



	public function get_chart_data()

	{

		if($this->isAjax)

		{

			$this->view = false;

			$this->layout = false;

			$this->json = true;

			$type = $this->input->post("type");

			$this->load->model("dashboard_chart_model");

			if($type == "yearly")

			{

				$chartdata = $this->dashboard_chart_model->get_chart_data_monthly();

				$this->data["data"] = $chartdata;				

			}

			else{

				$chartdata = $this->dashboard_chart_model->get_chart_data_daily();

				$this->data["data"] = $chartdata;				

			}

		}

		else{

			$this->session->set_flashdata("error",lang("INVALID_URL"));

			redirect(base_url(),"redirect");

		}	



	}







}

