<?php
/**
* A base controller for CodeIgniter with view autoloading, layout support,
* model loading, helper loading, asides/partials and per-controller 404
*
* @link http://github.com/jamierumbelow/codeigniter-base-controller
* @copyright Copyright (c) 2012, Jamie Rumbelow <http://jamierumbelow.net>
*/
class MY_Controller extends CI_Controller
{
/* --------------------------------------------------------------
* VARIABLES
* ------------------------------------------------------------ */
public $site_name;
/*user,admin*/
public $login_type=false;
/*nologin,login*/
public $access='login';
public $body_class='';
public $isAjax=false;
public $controller_name="";
public $method_name="";
public $meta_keyword="";
public $meta_description="";

public $menutype = '';
public $menu_array = array();
public $current_login_type = "";
public $current_session;
public $user_session = array();
public $admin_session = array();
public $agency_session = array();
public $msg_in_seperate_template = false;
public $message_type = "alert";
public $message_text="";
public $message_class="";
public $message_title="";
public $message_session="";
public $page_title="";
public $timezone="UTC";
public $is_user_login=false;
public $is_admin_login=false;
public $isadminurl=false;
public $isagencyurl=false;
public $permission_check=true;
public $admin_id=0;
public $admin_username="";
public $menu = array();
/**
* The current request's view. Automatically guessed
* from the name of the controller and action
*/
protected $view = '';
protected $json=false;
/**
* An array of variables to be passed through to the
* view, layout and any asides
*/
protected $data = array();
/**
* The name of the layout to wrap around the view.
*/
protected $layout;
/**
* An arbitrary list of asides/partials to be loaded into
* the layout. The key is the declared name, the value the file
*/
protected $sections = array();
/* --------------------------------------------------------------
* GENERIC METHODS
* ------------------------------------------------------------ */
/**
* Initialise the controller, tie into the CodeIgniter superobject
* and try to autoload the models and helpers
*/
public function __construct()
{
  parent::__construct();

  $this->session->set_userdata('db_count',0);

  $this->lang->load('message');
  $this->isAjax= $this->input->is_ajax_request();
  $this->site_name = $this->config->item('site_name');
  $this->controller_name = $this->router->fetch_class();
  $this->method_name = $this->router->fetch_method();
  $this->msg_succ = $this->session->flashdata('success');
  $this->msg_error = $this->session->flashdata('error');
  $this->msg_info = $this->session->flashdata('message');
  $this->msg_404error = $this->session->flashdata('404_error');
  $this->isadminurl = admin_url();
  $this->isagencyurl = agency_url();
  $this->beforeload();
}

public function beforeload(){

  /*All session data*/
  $this->data['isAjax']=$this->isAjax;

  /*Loads all constant*/
  $this->load->model("site_settings_model");
  $def_constans = $this->site_settings_model->get_all();
  /*Loads all constant ends*/
  
  $this->ismodalcont = false;

  if($this->controller_name == "signin" || $this->controller_name == "signup" || ($this->controller_name=="forgotpassword" && $this->isAjax == false) )
  {
    $this->ismodalcont = true;
  }

  if($this->isadminurl == true)
  {

    $this->load->model("admin_model");
    $this->load->model("adminsection_model");    
    $this->load->model("admin/subadmin_roles_model");  
    $this->admin_model->manage_session();

    if(!empty($this->admin_session) && $this->admin_session["is_allowed"] === false && $this->admin_session["adminType"]!='s' && $this->permission_check==true && $this->access != "")
    {
      $this->session->set_flashdata('error','You don\'t have permission access this page '.$this->controller_name);
      redirect(base_url()."admin/dashboard","refresh");
      exit();
    }
    $this->menu = $this->admin_session["sections"];
  }
  else if($this->isagencyurl == "true")
  {
    $this->load->model("admin_model");
    $this->admin_model->manage_agency_session();

  }
  else{
    $this->load->model("user_model");
    $this->load->model("content_model");

    $this->user_model->manage_session();
    if(READ_JSON_MODE === false)
    {
      $header_link_ar[] = array("display_position='header' OR display_position='both' AND status = 'y'",null,false);
      $this->data["header_links"] = $this->content_model->get_many_by($header_link_ar);  
    }
    else
    {
      if(file_exists(FCPATH.'assets/upload/site_content/header_links.json'))
      {
        $string = file_get_contents(FCPATH.'assets/upload/site_content/header_links.json');
        $this->data["header_links"] = json_decode($string, true);  
      }
    }
  }

  check_session();
  /*All session data*/
  $this->is_user_login=$this->user_loggedin();
  $this->is_admin_login=$this->admin_loggedin();

  if($this->msg_404error!=''){
    $this->session->keep_flashdata('404_error');
  }
  if($this->msg_succ != "")
  {
    $this->message_session = "success";
    $this->message_class = "success";
    $this->message_title = "Success";
    if(!empty($this->msg_succ) && is_array($this->msg_succ))
    {
      foreach ($this->msg_succ as $key => $value) 
      {
        $this->message_text.= $value."<br />";
      }
    }
    else{
      $this->message_text = $this->msg_succ;
    }
  }
  else if($this->msg_info!=""){
    $this->message_class = "info";
    $this->message_session = "message";
    $this->message_title = "Info";
    if(!empty($this->msg_info) && is_array($this->msg_info))
    {
      foreach ($this->msg_info as $key => $value) 
      {
        $this->message_text .= $value."<br />";
      }
    }
    else{
      $this->message_text = $this->msg_info;
    }
  } 
  else{
    $this->message_class = "danger";
    $this->message_session = "error";
    $this->message_title = "Error";
    if(!empty($this->msg_error) && is_array($this->msg_error))
    {
      foreach ($this->msg_error as $key => $value) {
        $this->message_text .= $value."<br />";
      }
    }
    else{
      $this->message_text = $this->msg_error;
    }
  }



  $this->load->css('plugins/bootstrap/css/bootstrap.min.css');
  $this->load->css('css/flags16.css');
  /*$this->load->css('plugins/uniform/css/uniform.default.css');*/
  $this->load->css('plugins/icheck/skins/all.css');
  $this->load->css('plugins/icheck/skins/square/red.css');

  $this->load->css('plugins/font-awesome/css/font-awesome.min.css');
  /*$this->load->css('plugins/bootstrap-modal/css/bootstrap-modal-bs3patch.css');*/
  $this->load->css('plugins/bootstrap-modal/css/bootstrap-modal.css');
  /*bootstrap datepicker*/
  /*$this->load->css('plugins/bootstrap-datepicker/css/bootstrap-datepicker3.css');*/
  /*bootsrtap datepicker*/
  $this->load->css('plugins/mediaelements/build/mediaelementplayer.css');  
  //$this->load->css('plugins/jquery-ui/jquery-ui.min.css');
  
  $this->load->js('js/html5.js');
  $this->load->js('js/jquery.min.js');
  $this->load->js('js/jquery.validate.min.js');
  $this->load->js('plugins/bootstrap/js/bootstrap.min.js');
  $this->load->js('plugins/bootstrap-modal/js/bootstrap-modalmanager.js');
  $this->load->js('plugins/bootstrap-modal/js/bootstrap-modal.js');
  $this->load->js('js/jquery.cokie.min.js');
  $this->load->js('nova/js/validate.js');
  /*$this->load->js('plugins/uniform/jquery.uniform.min.js');*/
  $this->load->js('plugins/icheck/icheck.js');
  $this->load->css('nova/css/google_font.css');
  if($this->isadminurl == "true" || $this->isagencyurl == "true")
  {
    $this->load->css('plugins/simple-line-icons/simple-line-icons.min.css');
    $this->load->css('plugins/bootstrap-switch/css/bootstrap-switch.min.css');
    $this->load->js('plugins/bootstrap-switch/js/bootstrap-switch.min.js');
  }
  else
  {
    $this->load->css('css/google_roboto_font.css');
    /*$this->load->css('css/components-md.css');*/
    $this->load->css('nova/css/components-md.min.css');
    
    $this->load->css('css/bootstrap-slider.css');
    $this->load->css('css/style.css');
    $this->load->css('css/custom.css');
    $this->load->css('css/media.css');
  }
  $this->load->js('plugins/jquery-slimscroll/jquery.slimscroll.min.js');
  $this->load->js('js/jquery.blockui.min.js');
  $this->load->css('plugins/bootstrap-toastr/toastr.min.css');
  $this->load->js('plugins/bootstrap-toastr/toastr.min.js');
  $this->load->js('nova/js/app.js');
  $this->load->js('js/quick-sidebar.js');
  
  if($this->controller_name != "login" && $this->isadminurl == "true")
  {
    /*$this->load->css('plugins/bootstrap-daterangepicker/daterangepicker-bs3.css');*/
    $this->load->css('plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css');

    $this->load->js('plugins/bootstrap-daterangepicker/moment.min.js');
    $this->load->js('plugins/bootstrap-daterangepicker/daterangepicker.js');
    $this->load->js('plugins/bootstrap-datepicker/bootstrap-datepicker.min.js');
    $this->load->js('plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js');
    $this->load->js('plugins/jquery-slimscroll/jquery.slimscroll.min.js');
    $this->load->js('js/jquery.blockui.min.js');


  }
  $this->load->start_inline_scripting();
/*if($this->admin_session){
echo "Appad.init(config);";
}else{
}*/
$this->load->end_inline_scripting(false,false);




if($this->isadminurl == "true")
{
  /*admin_id*/
  if (!class_exists("admin_model") ) {
    $this->load->model("admin_model");
  }
  $this->admin_model->after_get_allow=false;
  $admin_ar = $this->admin_model->set_fields('id,username')->get_by("adminType","s");
  if(!empty($admin_ar))
  {
    $this->admin_id = $admin_ar["id"];
    $this->admin_username = $admin_ar["username"];

  }
  /*admin_id*/
}

/*$db_count = $this->session->userdata('db_count');
echo "\n\n\n beforeload Total Queries ".$db_count." \n\n\n "; */

}
public function afterload()
{
  if(!$this->isAjax)
  {
    if($this->isadminurl != "true")
    {
      $this->load->model("content_model");
      $this->load->model("locations_model");

      if(READ_JSON_MODE === false)
      {
        $this->load->model("cities_model");
        $this->data["branch_offices"] = $this->cities_model->get_many_by('status','y'); 
      }
      else
      {
        if(file_exists(FCPATH.'assets/upload/site_content/branch_offices_links.json'))
        {
          $string = file_get_contents(FCPATH.'assets/upload/site_content/branch_offices_links.json');
          $this->data["branch_offices"] = json_decode($string, true);  
        }
      }


      if(READ_JSON_MODE === false)
      {
        $this->data["footer_links_ar"] = $this->content_model->get_footer_links();
      }
      else
      {
        if(file_exists(FCPATH.'assets/upload/site_content/footer_links.json'))
        {
          $string = file_get_contents(FCPATH.'assets/upload/site_content/footer_links.json');
          $this->data["footer_links_ar"] = json_decode($string, true);  
        }
      }

      $this->locations_model->after_get_allow = false;
      $pop_loc_where = array("status"=>'y',"at_home"=>'1');
      $popular_location_ar = $this->locations_model->set_fields("id,location_name")->get_many_by($pop_loc_where);
      $this->locations_model->after_get_allow = true;
      if(count($popular_location_ar) > 0)
      {
        $this->popular_location = true;
        $this->data["popular_location_ar"] = $popular_location_ar;
      }

      $logo_data = $this->site_settings_model->set_fields("value")->get_by('constant','SITE_LOGO');
      if(!empty($logo_data))
      {
        /*$this->data["logo_img"] = base_url()."image/logo/295/41/".$logo_data["value"];*/
        $this->data["logo_img"] = base_url()."assets/nova/img/site_setting/".$logo_data["value"];
      }
      else{
        $this->data["logo_img"] = asset_url().'images/logo.png';
      }
    }
  }

  if($this->isadminurl == "true" || $this->isagencyurl == "true")
  {
    $this->load->css('nova/css/components-md.min.css');
    $this->load->css('nova/css/plugins-md.min.css');
    $this->load->css('nova/css/custom.css');
    $this->load->css('nova/css/icons.css');
    if($this->isagencyurl == "true")
    {
        $this->load->js('plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js');
      $this->load->js('agency/js/common.js');
    }
    else
    {
      $this->load->js('nova/js/common.js');
    }
    $this->load->css('nova/css/layout.css');
  }
  else
  {
    $this->load->js('js/typeahead.bundle.js');
    $this->load->css('css/typeahead.css');
    /* $this->load->js('plugins/bootstrap-datepicker/bootstrap-datepicker.min.js');*/
    $this->load->js('plugins/jquery-ui/jquery-ui.min.js');
    $this->load->js('js/bootstrap-slider.js');
    $this->load->js('js/google-places.js');
    /*$this->load->js('http://maps.googleapis.com/maps/api/js?key=AIzaSyDY0kkJiTPVd2U7aTOAwhc9ySH6oHxOIYM&sensor=false&libraries=places',true);*/
    $this->load->js('js/all-style.js');
    $this->load->js('js/jquery.cookieBar.js');
    $this->load->js('js/common.js');
    $this->load->css('css/layout.css');
    $this->load->css('css/cookieBar.css');
  }

  if($this->controller_name != "login" && ($this->isadminurl == "true" || $this->isagencyurl == "true"))
  {
    $this->load->css('nova/css/themes/dark.css');
    $this->load->js('nova/js/layout.js');
  }

/*if($this->isadminurl)
{
$this->load->css('nova/css/custom.css'); 
}*/
$this->sections['section_css'] = 'sections/css';
$this->sections['section_meta'] = 'sections/meta';
$this->sections['section_js'] = 'sections/js';
$this->sections['section_message'] = 'sections/message';
if($this->isadminurl == "true")
{
  $this->sections['chat_section'] = 'sections/admin/chat_section';
}
else
{
 $this->sections['chat_section'] = 'sections/chat_section';
}
$this->output->append_title(site_name());
$this->output->set_meta("title",site_name());
if($this->meta_keyword != '' && $this->meta_keyword != null && $this->meta_description != '' && $this->meta_description != null)
{
  $this->meta_keyword = rtrim($this->meta_keyword,",");
  $this->output->set_meta("keywords",$this->meta_keyword);
  $this->output->set_meta("description",$this->meta_description);
}
else{
 $this->meta_keyword = rtrim($this->meta_keyword,",");
 $this->output->set_meta("keywords",lang("DEFAULT_META_KEYWORD"));
 $this->output->set_meta("description",lang("DEFAULT_META_DESCRIPTION")); 
}

$footer_links = array();

$cookie_user = $this->rememberme->verifyCookie();
/*printr($cookie_user);
exit();*/
if ($cookie_user)
{
  $this->load->model("user_model");
  $user = $this->user_model->cookie_login($cookie_user);
}

if(!empty($this->admin_session) && $this->admin_session){
}else{        
/*$this->load->js('js/bootstrap3-typeahead.js');
$this->load->js('js/common.js');*/ 
}
if(!$this->isAjax)
{
  $this->data['controller_name']=$this->router->fetch_class();
  $this->data['method_name']=$this->router->fetch_method();
  $this->data['body_class']=$this->body_class;
}
/*Get menu ends*/

/*$db_count = $this->session->userdata('db_count');
echo "\n\n\n Total Queries ".$db_count;*/  

}
/* --------------------------------------------------------------
* VIEW RENDERING
* ------------------------------------------------------------ */
/**
* Override CodeIgniter's despatch mechanism and route the request
* through to the appropriate action. Support custom 404 methods and
* autoload the view into the layout.
*/
public function _remap($method)
{
  try
  {
    if (method_exists($this, $method))
    {
      $parameters = array_slice($this->uri->rsegments, 2);
      call_user_func_array(array($this, $method), $parameters);
    }
    else
    {
      if (method_exists($this, '_404'))
      {
        call_user_func_array(array($this, '_404'), array($method));
      }
      else
      {
        show_404(strtolower(get_class($this)).'/'.$method);
      }
    }
    $this->afterload();
    $this->_load_view();
  }
  catch(Exception $e)
  {
    show_error($e->getMessage());
  }
}
/*Function to check user is admin or not*/
public function admin_loggedin(){
  if($this->admin_session && !empty($this->admin_session))
    return true;
  else
    return false;   
}
/*Function to check user is admin or not*/

/*Function to check user is admin or not*/
public function agency_loggedin(){
  if($this->agency_session && !empty($this->agency_session))
    return true;
  else
    return false;   
}
/*Function to check user is admin or not*/


/*Function to check user is loggedin or not*/
public function user_loggedin(){

/*printr($this->session->all_userdata());
printr($this->user_session);
exit("Found");*/

if($this->user_session && !empty($this->user_session))
  return true;
else
  return false;  
}
/*Function to check user is loggedin or not ends*/
/*Function to check any of user or admin is loggedin or not*/
public function both_loggedin(){
  if(!empty($this->user_session) || !empty($this->admin_session))
    return true;
  else
    return false;   
}
/*Function to check tc is loggedin or not ends*/
/**
* Automatically load the view, allowing the developer to override if
* he or she wishes, otherwise being conventional.
*/
protected function _load_view()
{
  /*If $this->view == FALSE, we don't want to load anything*/
  if ($this->view !== FALSE && $this->json===false)
  {
    /* If $this->view isn't empty, load it. If it isn't, try and guess based on the controller and action name*/
    $view = (!empty($this->view)) ? $this->view : $this->router->directory . $this->router->class . '/' . $this->router->method;
    $layout = FALSE;
    /*If we didn't specify the layout, try to guess it*/
    if (!isset($this->layout))
    {
      if (file_exists(APPPATH . 'views/layouts/' . $this->router->class . '.php'))
      {
        $layout = $this->router->class;
      }
      else
      {
        if($this->admin_session || $this->agency_session){
          $layout = 'admin/default';
        }
        else{
          $layout = 'default';
        }
      }   
    }
    elseif($this->layout !== FALSE)
    {
      $layout=$this->layout;
    }
    if ($layout == FALSE)
    {
      $this->output->unset_template();
    }
    else{
      $this->layout=$layout;
      $this->output->set_template($this->layout);
    }
    $data_all=$this->output->load_template_data();
    /*printr($data_all);*/
    $this->data=array_merge($this->data,$data_all);
    /*printr($this->data);*/
    /*Do we have any asides? Load them.*/
    if (!empty($this->sections))
    {
      foreach ($this->sections as $name => $file)
      {
        $this->load->section($name, $file,$this->data);
      }
    }
    $this->load->view($view,$this->data);  
  }
  else if($this->json===true){
    $this->output->set_content_type('application/json')->set_output(json_encode($this->data));
  }
}
/*com cust function*/
protected function grid_resorces(){
  $this->load->css('plugins/datatables/plugins/bootstrap/datatables.bootstrap.css');
  $this->load->css('plugins/datatables/plugins/responsive/responsive.bootstrap.min.css');
  $this->load->css('plugins/datatables/plugins/yadcf/jquery.datatables.yadcf.css');

  $this->load->js('plugins/datatables/jquery.dataTables.min.js');
  $this->load->js('plugins/datatables/plugins/bootstrap/datatables.bootstrap.js');
  $this->load->js('plugins/datatables/plugins/responsive/dataTables.responsive.min.js');
  $this->load->js('plugins/datatables/plugins/yadcf/jquery.dataTables.columnFilter.js');
  $this->load->js('plugins/datatables/plugins/yadcf/jquery.dataTables.yadcf.js');
  $this->load->js('plugins/datatables/plugins/api/fnPagingInfo.js');
  $this->load->js('js/datatable.js');
}
/*com cust function*/

public function __destruct() {
  $this->db->close();
}

}