function change_dropoff_pickup_time(type,val){
  var same_as = $(type).attr("data-sameas");
  $.ajax({
    url: config.siteUrl + "common_methods/get_opening_time_from_location",
    type: "POST",
    data: {
      'type': type,
      'location_id': val
    },
    dataType: "JSON",
    async: true,
    success: function(data) {
      if (type == 'pickup_location') {
        $("#pickup").html(data.time_data);
      } else {
        $("#dropoff").html(data.time_data);
      }
      if (typeof same_as != "undefined" && !$("#same_as").is(':checked') && same_as != "false") {
        temp = $("#pickup_time").html();
        $("#dropoff_time").html(temp);
        var tmp = $("#pickup_location option:selected").val();
        $("#dropoff_location").val(tmp).change();      
        /*$("#dropoff_location option[value=" + tmp + "]").attr("selected", "selected")*/   
      }
    }
  });

}


$(document).ready(function(){


  car_id = (typeof car_id != "undefined") ? car_id : 0; 

  $('#pickup_location_typeahead').typeahead({
    minLength: 0,
    highlight:true    
  },
  {
    limit:100,
    source: function (query, syncResult,asyncResult) 
    {
      $.get(config.siteUrl+'common_methods/get_autosuggest_list', { query: query,pickup_location:pickup_location,dropoff_location:dropoff_location,car_id:car_id }, function (data) 
      {
        pickup_location_objects = [];
        pickup_location_map = {}; 

        $.each(data.location_tags, function(i, object) {
          pickup_location_map[object.label] = object;
          pickup_location_objects.push(object.label);
        });
        asyncResult(pickup_location_objects);
      });
    },
    
  });       


  $('#pickup_location_typeahead').on('typeahead:selected', function(evt, item) {
    var val_id = pickup_location_map[item].id;
    $('#pickup_location').val(val_id);
    change_dropoff_pickup_time("pickup_location",val_id);

    if (typeof same_as != "undefined" && !$("#same_as").is(':checked') && same_as != "false") {
      $('#dropoff_location').val(val_id);
      $("#dropoff_location_typeahead").val(pickup_location_map[item].label);
      temp = $("#pickup_time").html();
      $("#dropoff_time").html(temp);
    }
    return item;
  });


  $('#dropoff_location_typeahead').typeahead({
    minLength: 0,
    hint:true,
    highlight:true
  },
  {
    limit:100,
    source: function (query, syncResult,asyncResult) {
      $.get(config.siteUrl+'common_methods/get_autosuggest_list', { query: query,pickup_location:pickup_location,dropoff_location:dropoff_location,car_id:car_id }, function (data) 
      {
        /*data = $.parseJSON(data);*/
        dropoff_location_objects = [];
        dropoff_location_map = {};
        $.each(data.location_tags, function(i, object) {
          dropoff_location_map[object.label] = object;
          dropoff_location_objects.push(object.label);
        });
        asyncResult(dropoff_location_objects);
      });
    }   
  });

  $('#dropoff_location_typeahead').on('typeahead:selected', function(evt, item) {
    var val_id = dropoff_location_map[item].id;
    $('#dropoff_location').val(val_id);
    change_dropoff_pickup_time("dropoff_location",val_id);
    return item;
  });


  

  $("body").on('click','.bookcar-btn',function(){

    $("#searchfilterform").valid();

  });

  if($("#pickup_date").length > 0 || $("#dropoff_date").length > 0 )
  {
    $('#pickup_date').datepicker({
      numberOfMonths: 2,
      firstDay: 1,
      dateFormat: 'yy-mm-dd',
      minDate: '+1',
      maxDate: '+'+config.max_date_js+'M',
      showAnim: '',
      beforeShow: function() {
        $('#pickup_date').addClass('active');    
      },
      onSelect: function(dateStr) 
      {
        var d1 = $(this).datepicker("getDate");
        d1.setDate(d1.getDate());
        $("#dropoff_date").datepicker("option", "minDate", d1);
      },
      onClose: function() {
        $('#pickup_date').removeClass('active');
      }
    });


    $('#dropoff_date').datepicker({
      defaultDate: new Date(),
      numberOfMonths: 2,
      firstDay: 1,
      dateFormat: 'yy-mm-dd',
      maxDate: '+'+config.max_date_js+'M',
      showAnim: '',
      beforeShow: function() {
        $('#dropoff_date').addClass('active');    
      },
      onClose: function() {
        $('#dropoff_date').removeClass('active');
      }
    });


    $("body").on("change", "#pickup_location,#dropoff_location", function(e) {
      e.preventDefault();
      var type = $(this).attr('name');
      var same_as = $(this).attr("data-sameas");
      $.ajax({
        url: config.siteUrl + "common_methods/get_opening_time_from_location",
        type: "POST",
        data: {
          'type': type,
          'location_id': $(this).val()
        },
        dataType: "JSON",
        async: true,
        success: function(data) {
          if (type == 'pickup_location') {
            $("#pickup").html(data.time_data);
          } else {
            $("#dropoff").html(data.time_data);
          }
          if (!$("#same_as").is(':checked') && same_as != "false") {
            temp = $("#pickup_time").html();
            $("#dropoff_time").html(temp);
            var tmp = $("#pickup_location option:selected").val();
            $("#dropoff_location option[value=" + tmp + "]").attr("selected", "selected");
          }
        }
      });
    });
  }

});