<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'users';
	public $after_create = array( 'after_register' );
	public $before_update = array( 'before_update' );
	public $after_update = array( 'after_update' );
	public $after_get = array( 'after_get' );
	public $after_get_country_allow = true;
	public $guest_regiter_email_template = false;



	/*public $protected_attributes = array('id');*/
	protected $CI;
	public $validate = array(
		'firstname'  => array(
			'field' => 'firstname',
			'label' => 'First Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:USER_FIRST_NAME_REQUIRED'
				),
			),
		'lastname'  => array(
			'field' => 'lastname',
			'label' => 'Last Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:USER_LAST_NAME_REQUIRED'
				),
			),
		'email'  => array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email|is_unique[users.email]',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL',
				'is_unique'=>'lang:USER_ALREADY_EXIST'
				),
			),
		'confirm_email'  => array(
			'field' => 'confirm_email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL'
				),
			),		
		'password'  => array(
			'field' => 'password',
			'label' => 'Password',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PASSWORD_REQUIRED'
				),
			),	
		'cnfpassword'  => array(
			'field' => 'cnfpassword',
			'label' => 'Password',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PASSWORD_REQUIRED'
				),
			),
		);

public function __construct()
{
	parent::__construct();
	$this->current_session=$this->current_session;
	$this->current_login_type=$this->current_login_type;
	$this->CI=& get_instance();
}

public function after_get($data)
{
	if(!empty($data))
	{

		$exist_check_path = FCPATH."assets/upload/profile/".$data["id"]."/".$data["image"];
		if(file_exists($exist_check_path) && $exist_check_path!='')
		{
			$data["image_path"] = base_url()."image/profile/".$data["id"]."/150/150/".$data["image"];
		}
		else{
			$data["image_path"] = base_url()."image/default/150/150/no_available_image.gif";
		}		
		$data['firstname']=ucfirst($data['firstname']);
		$data['lastname']=ucfirst($data['lastname']);
		$data["full_name"] = $data['firstname']." ".$data['lastname'];
		$country_id=$data['country'];

		if($country_id > 0 && $this->after_get_country_allow == true)
		{
			$this->load->model("countries_model");
			$country_name=$this->countries_model->set_fields('country_name')->get($country_id);	
			$data['country_name']=$country_name['country_name'];
		}
	}
	return $data;
}

public function before_update($data){


	if(!empty($data))
	{

		if(isset($data["id"]) && $data["id"] > 0)
		{
			$image_data = $this->get($data["id"]);
			if(isset($_FILES['image'])  && $_FILES['image']['error']==UPLOAD_ERR_OK)
			{	
				$update_new_image_ar = $this->upload_image($data["id"]);
				if($update_new_image_ar["status"] == "success")
				{
					if($update_new_image_ar["status"] == "success" && isset($image_data))
					{
						$exist_check_path = FCPATH."assets/upload/profile/".$data["id"]."/".$image_data["image"];	
						if(file_exists($exist_check_path) && $exist_check_path!=''){
							unlink($exist_check_path);
						}
					}
					$data['image'] = $update_new_image_ar['file_name'];
				}
			}
		}

		if(isset($data["change_password"]) && $data["change_password"] == true)
		{
			if($this->CI->current_session["password"] != $data["old"])
			{
				$data['before_return']['msg']=lang("WRONG_PASS");
				return $data;
			}
			unset($data["old"]);
			unset($data["change_password"]);				
		}
		else{
			if(isset($data["password"]) && $data["password"] != "")
			{
				$data["password"] = md5($data["password"]);

			}
			$data['last_updated_date']=date("Y-m-d H:i:s");
		}		
	}	
	unset($data["id"]);
	return $data;
}
public function after_update()
{	
	$user_id = ($this->current_session["id"] > 0) ? $this->current_session["id"] : $this->session->userdata("user")["id"];

	$array = array('id'=>$user_id,'session_update'=>true,'skip_validation'=>true,'type'=>$this->current_login_type);
	$this->check_login($array);
}


public function cookie_login($id) 
{
	$array = array('id'=>$id,'session_update'=>true,'skip_validation'=>true,'type'=>"user");
	$this->check_login($array);
}

public function check_login($array = array('skip_validation'=>false)){
	$response = array('status'=>'success','msg'=>'');
	$user_details = array();
	$flag = false;
	if($array["skip_validation"] != true)
	{
		$this->form_validation->set_rules('email', 'lang:EMAIL_REQUIRED', 'required|valid_email',array('required' => 'lang:EMAIL_REQUIRED','valid_email'=>'lang:MSG_VALID_EMAIL'));
		$this->form_validation->set_rules('password', 'lang:PASSWORD_REQUIRED', 'required',array('required' => 'lang:PASSWORD_REQUIRED'));

		if($this->form_validation->run() == true)
		{
			$email = $this->input->post("email");
			$password = md5($this->input->post("password"));
			$rememberme = $this->input->post("rememberme");
			$cond_array = array('email'=>$email,'password'=>$password);	

			$flag = true;		
		}
		else{
			$response["status"] = "fail";
			$response["msg"] = validation_errors();
		}
	}

	if($array["session_update"] && $array["session_update"] == true)
	{
		$flag = true;
		$cond_array = array('id'=>$array["id"]);
	}

	if($flag == true)
	{
		$user_details = $this->as_array()->get_by($cond_array);

	}

	if(isset($rememberme) && $rememberme == '1')
	{
		$this->rememberme->setCookie($user_details["id"]);
	}

	if(!empty($user_details) && $user_details["status"] == "y"){
		$sess_nm = USER_SESS_NM;
		$this->session->set_userdata($sess_nm,$user_details);
		$response["status"] = "success";
		$response["msg"] = lang("MSG_SUCC_LOGIN");			
	}
	else if(empty($user_details)){
		$response["status"] = "fail";
		$response["msg"] = (!empty(validation_errors())) ? validation_errors() : lang("INVALID_USERNAME_PASSWORD");
	}
	else{
		$response["status"] = "fail";
		$response["msg"] = lang("MSG_NOT_ACTIVATE");
	}
	return $response;
}	

public function upload_image($id)
{

	$asset_upload_dir = FCPATH.'assets/upload/'; 
	$upload_profile_dir = FCPATH.'assets/upload/profile/'; 
	$upload_dir = FCPATH.'assets/upload/profile/'.$id.'/'; ; 

	if(!file_exists($asset_upload_dir)){
		mkdir($asset_upload_dir,777);
	}

	if(!file_exists($upload_profile_dir)){
		mkdir($upload_profile_dir,777);
	}
	
	if(!file_exists($upload_dir)){
		mkdir($upload_dir,0777);
	}	

	$data = array('status'=>'error');
	$maxSize = IMAGE_UPLOAD_MAX_SIZE;

	if($_FILES['image']['error']==UPLOAD_ERR_OK){
		$this->load->library('image_lib');
		$name = $_FILES['image']['name'];
		$size = $_FILES['image']['size'];
		$ext = substr($name, strrpos($name, ".") + 1);

		if ($size < ($maxSize)) {

			$th_arr=array();	
			$config['upload_path'] = $upload_dir;
			$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
			$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$field_name = "image";
			if ( ! $this->upload->do_upload($field_name))
			{
				$this->form_validation->set_message('insert',$this->upload->display_errors());
				$data["status"] = "error";
				$data["msg"] = $this->upload->display_errors();					
			}
			else
			{
				$fileUpd = array('upload_data' => $this->upload->data());
				$data["status"] = "success";
				$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
			}
		}
		else{
			$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
			$data["status"] = 'error';
			$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
		}	
	}
	return $data;
}


protected function after_register($id)
{
	$user_detail = $this->as_array()->get($id);

	if($this->guest_regiter_email_template == true)
	{
		/*$url =	base_url()."activate/".$user_detail["activation_code"];
		$admin = SITE_NM;
		$key = array('{BOOKING_ID}','{USERNAME}','{SITE_NM}','{ACTIVATION_LINK}','{USER_EMAIL}','{PASSWORD}','{SITE_NAME}');
		$val = array('',$user_detail["full_name"],site_name(),$url,$user_detail["email"],$user_detail["password"],site_name());
		send_mail('Guest Register',$key,$val,$user_detail["email"]);*/
	}
	else
	{
		if($user_detail["reg_type"] != 'n')
		{
			$data_mail = array(
				'name'		=>	$user_detail["full_name"],
				'email'	=>	$user_detail["email"],
				'password' => $user_detail["password"]			
				);	
			$abc = $this->template->load('/mail/email_template','/mail/social_user_registration',$data_mail,TRUE); 
			send_mail(ADMIN_EMAIL,$user_detail["email"],"Successfull registration :".SITE_NM,$abc);
		}
		else{
			$url =	base_url()."activate/".$user_detail["activation_code"];
			$admin = SITE_NM;
			$key = array('{USERNAME}','{USER_EMAIL}','{PASSWORD}','{ACTIVATION_LINK}','{ADMIN}', '{MSG_EXT}');
			$val = array($user_detail["firstName"],$user_detail["email"], "Entered by you ",$url,$admin,'');
			send_mail('User Register',$key,$val,$user_detail["email"]);
		}
		
		$update_array = array('password'=>($user_detail["password"]));
		$this->update($user_detail["id"],$update_array,true);
	}


	
	
	return $id;
}

public function forgot_password($array = array()){
	$response = array('status'=>'success','msg'=>'');
	if($array["skip_validation"] != true)
	{
		$this->form_validation->set_rules('email', 'lang:EMAIL_REQUIRED', 'required|valid_email',array('required' => 'lang:EMAIL_REQUIRED','valid_email'=>'lang:MSG_VALID_EMAIL'));
		if($this->form_validation->run() == true)
		{
			$email = $this->input->post('email');
			$forgotten_password_code = md5(time().mt_rand());
			$where = array('email'=>$email);
			$user_detail = $this->as_array()->get_by($where);
			if($user_detail)
			{	
				$update_array = array('forgotten_password_code'=>$forgotten_password_code);
				$temp = $this->update($user_detail["id"],$update_array,true);
				if($temp){
					$response["status"] = "success";
					$response["msg"] = lang("MSG_SUCC_FORGOTPASS");
					$response["activation_code"] = $forgotten_password_code;
					$admin = SITE_NM;
					$username=$user_detail['firstname'].' '.$user_detail['lastname'];
					$resetLink = site_url().'resetpassword/'.$forgotten_password_code;
					$key = array('{USERNAME}','{RESET_PASSWORD_LINK}','{ADMIN}','{MSG_EXT}');
					$val = array($username,$resetLink,$admin,'');
					send_mail('User Forgot Password',$key,$val,$user_detail["email"]);
				}
			}else{
				$response["status"] = "fail";
				$response["msg"] = lang("MSG_INVALID_USER");
			}
		}
		else{
			$response["status"] = "fail";
			$response["msg"] = validation_errors();
		}
	}
	return $response;
}

public function manage_session(){
	$user  =   $this->session->userdata(USER_SESS_NM);
	$isadminurl=false;
	if(isset($user) && !empty($user)){
		$this->CI->user_session = $user;
		$this->CI->current_session = $user;
		$this->CI->current_login_type = "user";
	}
	else{
		$this->CI->menutype = 'n';
		$this->CI->current_login_type = "n";   
	}   
	if(isset($user) && !empty($user)){
		$lastIp=$user['last_ip'];
		$currentIP = $this->input->ip_address();
		if($lastIp!=$currentIP || get_cookie('tm')===false)
		{
			$update_array = array('last_ip'=>$currentIP);
			$this->update($user["id"],$update_array,true);
			/*$params=array("apiKey"=>$this->CI->config->item("ipinfo_key"));
			$this->CI->load->library("ipinfo",$params);
			$data=$this->CI->ipinfo->getCity($currentIP);
			set_timezone($data,'tm');*/
		}
		$update_array = array('last_updated_date'=>date("Y-m-d H:i:s"));
		$this->update($user["id"],$update_array,true);
		$this->CI->timezone=get_cookie('tm');
	}
}
}