<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class season_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $before_delete = array('before_delete');
	public $_table = 'season';
	protected $CI;
	public $validate = array(
		'season_name'  => array(
			'field' => 'season_name',
			'label' => 'season_name Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SEASON_NAME_REQUIRED'				
				),
			),
		'from'  => array(
			'field' => 'from',
			'label' => 'from Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SEASON_FROM_REQUIRED'
				),
			),
		'to'  => array(
			'field' => 'to',
			'label' => 'to Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:SEASON_TO_REQUIRED',				
				),
			),

		);
	


	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function before_delete($data)
	{

		$this->load->model("pricing_model");

		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}

		if($data > 0)
		{
			$where[] = array("seasonId = '".$data."'",null,false);
			$this->pricing_model->delete_by($where);
		}	
		return $data;
	}

	

	public function check_date_exist($start_date_year,$end_date_year,$where = null)
	{
		/*	$date_year = DEFAULT_YEAR;*/

		if($where != null)
		{
			$where = " AND ".$where;
		}
		
		/*$query = $this->db->query("SELECT * from season where ((start_date >= '".$start_date_year."' and start_date <='".$end_date_year."') or (end_date >='".$start_date_year."' and end_date  <= '".$end_date_year."')) $where");*/

		$query = $this->db->query("SELECT * from season where (('".$start_date_year."' between start_date AND end_date) or ('".$end_date_year."' between start_date and end_date)) $where");

		if($query->num_rows() > 0)
		{
			$row = $query->row_array();	
			return $row;
		}
		else
		{
			return array();
		}
	}
	

	

}
