<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pricing_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'pricing';
	public $before_delete = array( 'before_delete' );
	public $after_create = array( 'after_create' );
	public $after_update = array( 'after_update' );
	public $after_get = array( 'after_get' );
	public $after_get_allow = false;
	protected $CI;

	/*Pricing vars*/
	public $is_special_offer = false;
	public $pickup_date;
	public $pickup_time;
	public $dropoff_date;
	public $dropoff_time;
	public $pickup_location = 0;
	public $dropoff_location = 0;
	public $car_id;
	public $car_category;
	public $car_group;
	public $insuranceGroupId;
	public $booking_selected_facilities;
	public $booking_total_days;
	public $booking_selected_insurance;
	public $booking_user_age;
	public $booking_user_driveragenumber;
	public $per_day_price;
	public $per_day_special_offer_price;
	public $special_offer_price = 0;
	public $special_offer_original_price = 0;
	public $special_offer_original_type = '';

	public $special_offer_opposite_price = 0;
	public $special_offer_display_label = '';
	public $special_offer_opposite_applied_flag = false;

	public $original_price = 0;
	public $coupon_applied_price = 0;	
	public $driver_age_price = 0;
	public $dropoff_price = 0;
	public $insurance_price = 0;
	public $insurance_text = '';
	/*Final price after all calculations*/
	public $total = 0;
	public $special_offer_id = 0;
	public $spacial_offer_percentage;
	public $additional_price;
	public $basic_price;
	public $advanced_price;
	/*Pricing vars*/
	public $validate = array(
		'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'Category',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
			),
		)
	);
	public function __construct()
	{
		parent::__construct();
		$this->CI=& get_instance();

	}
	public function get_car_price($car_data = array(),$discount_coupon = 0,$pricingDetails = array(),$price_change_flag = false,$booking_db_data = array())
	{
		$this->load->model("cars_model");
		$this->load->model("locations_fee_model");
		$this->load->model("season_model");
		$all_seasons = $this->season_model->get_many_by("status",'y');
		$response = array();

		$exploded_pickup_time = explode(":",$this->pickup_time); 
		$exploded_dropff_time = explode(":",$this->dropoff_time); 

		if(count($exploded_pickup_time) == 3)
		{
			array_pop($exploded_pickup_time);
			$this->pickup_time = implode(":",$exploded_pickup_time);

		}

		if(count($exploded_dropff_time) == 3)
		{
			array_pop($exploded_dropff_time);
			$this->dropoff_time = implode(":",$exploded_dropff_time);
		}
		
		$this->pickup_date = ($this->pickup_date != "") ? date('Y-m-d',strtotime($this->pickup_date)):"";
		$this->dropoff_date = ($this->dropoff_date != "") ? date('Y-m-d',strtotime($this->dropoff_date)):"";
		

		if($this->pickup_date != "" &&  $this->dropoff_date != "")
		{
			if(isset($this->pickup_time) && $this->pickup_time != '')
			{
				$date_diff_pickup_date = $this->pickup_date." ".$this->pickup_time.":00";	
			}
			else{
				$date_diff_pickup_date = $this->pickup_date;
			}
			
			if(isset($this->dropoff_time) && $this->dropoff_time != '')
			{
				$date_diff_dropoff_date = $this->dropoff_date." ".$this->dropoff_time.":00";	
			}
			else
			{
				$date_diff_dropoff_date = $this->dropoff_date;
			}
			
			

			$this->booking_total_days = date_difference($date_diff_pickup_date,$date_diff_dropoff_date);
		}
		else
		{
			$this->booking_total_days = 1;
		}



		/*Custom code changed*/	
		if(empty($car_data))
		{
			$this->cars_model->after_get_allow=false;
			$car_data = $this->cars_model->get($this->car_id);
			$this->cars_model->after_get_allow=true;
		}		
		/*Custom code changed*/	

		if(!empty($car_data))
		{
			
			$this->car_group = $car_data["groupId"];
			$this->car_category = $car_data["categoryId"];
			/*Check for advacned price*/
			if($this->pickup_date && $this->dropoff_date)
			{
				$loopDate = date('m-d',strtotime($this->pickup_date));
				$loopOriginalDate = date('Y-m-d',strtotime($this->pickup_date));

				/*echo " <br />".$this->booking_total_days;*/
				for($i=0;$i<$this->booking_total_days;$i++)
				{
					$advanced_price_check = $this->get_advanced_price($loopDate,$all_seasons);
					if($advanced_price_check == false && $this->advanced_price == 0)
					{
						$basic_price_check = $this->get_basic_price();
						if($basic_price_check == true)
						{
							$this->total += $this->basic_price;

							$response["basic_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["basic_price"] : $this->basic_price;
						}
					}
					else{
						/*echo $this->advanced_price." <br />";*/
						$this->total += $this->advanced_price;
						$response["advanced_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["advanced_price"] : $this->advanced_price;
					}

					$special_offer_pass_amount = ($this->advanced_price > 0) ? $this->advanced_price : $this->basic_price;

					/*check for special offer opposite*/
					$check_special_offer_opposite_flag = $this->check_special_offer_opposite($loopOriginalDate,$special_offer_pass_amount);
					if(!empty($check_special_offer_opposite_flag) && $check_special_offer_opposite_flag["status"] == "success")
					{
						$this->special_offer_opposite_applied_flag = true;
						$this->total += $check_special_offer_opposite_flag["price"];
					}
					/*check for special offer opposite ends*/
					$i_p = $i+1;
					$loopDate = date('m-d',strtotime($this->pickup_date.' +'.$i_p.' day'));
					$loopOriginalDate = date('Y-m-d',strtotime($this->pickup_date.' +'.$i_p.' day'));
					$this->basic_price = 0;
					$this->advanced_price = 0;
				}
			}
			else{
				$basic_price_check = $this->get_basic_price();
				if($basic_price_check == true)
				{
					$this->total += $this->basic_price;
				}
				$this->basic_price = 0; 
			}
			$this->original_price = $this->total;	
			$this->per_day_price = round($this->total/$this->booking_total_days,2);

			/*If price updated by admin*/
			if(!empty($pricingDetails) && $price_change_flag == true && $pricingDetails["booking_total_days"] == $this->booking_total_days && $this->original_price != $pricingDetails["original_price"])
			{
				$this->total = $this->original_price = $pricingDetails["original_price"];	
				$this->per_day_price = $pricingDetails["per_day_price"];				
			}

			/*Check for advacned price*/

			if($this->total>0)
			{
				/*Check for opposite special offer*/
				if($this->special_offer_opposite_applied_flag == false)
				{
					$check_special_offer_flag = $this->check_special_offer();
					if($check_special_offer_flag == true)
					{
						$this->total -= $this->special_offer_price;
						$this->per_day_special_offer_price=round($this->total/$this->booking_total_days,2);
						$this->is_special_offer = true;
					}
					else
					{
						$this->is_special_offer = false;
						$this->per_day_special_offer_price = 0;
					}
				}
				/*Check for additional location based price*/
				if($this->pickup_location > 0 && $this->dropoff_location > 0)
				{
					$additional_location_price_where = array('fromId'=>$this->pickup_location,'toId'=>$this->dropoff_location,"status"=>'y');
					$check_for_additional_location_price = $this->locations_fee_model->get_by($additional_location_price_where);

					if(!empty($check_for_additional_location_price) || $pricingDetails["dropoff_price"] > 0)
					{	
						if(!empty($pricingDetails) && $price_change_flag == true && $pricingDetails["booking_total_days"] == $this->booking_total_days && $check_for_additional_location_price["price"] != $pricingDetails["dropoff_price"])
						{
							$this->total += $pricingDetails["dropoff_price"];	
							$this->dropoff_price = $pricingDetails["dropoff_price"];				
						}
						else
						{
							$this->dropoff_price = $check_for_additional_location_price["price"]; 
							$this->total += $check_for_additional_location_price["price"];
						}						
					}
				}
				/*Check for additional location based price ends*/


				/*Driver extra age charge*/
				$age_surcharge_status = $this->get_age_surcharge_price($booking_db_data,$pricingDetails);
				if($age_surcharge_status == true)
				{
					$this->total += $this->driver_age_price;
				}
				/*Driver extra age charge*/

				/*working time surcharge needed to implement*/
				if($this->pickup_location>0)
				{
					$this->locations_model->after_get_allow = false;
					$pickup_location_details = $this->locations_model->get($this->pickup_location);
					$this->locations_model->after_get_allow = true;
				}
				if($this->dropoff_location>0)
				{
					$this->locations_model->after_get_allow = false;
					$dropoff_location_details = $this->locations_model->get($this->dropoff_location);
					$this->locations_model->after_get_allow = true;
				}

				if(!empty($pickup_location_details) && !empty($dropoff_location_details)) 
				{
					/*TIME_SURCHARGE_PRICE*/	
					/*if($this->pickup_time.":00" < $pickup_location_details["working_from"] && $pickup_location_details["working_from"] != "00:00:00")
					{	
						$this->total += (int)TIME_SURCHARGE_PRICE;
						$response["from_time_surcharge_price"] = TIME_SURCHARGE_PRICE;
					}

					if($this->dropoff_time.":00" > $dropoff_location_details["working_to"] && $dropoff_location_details["working_from"] != "00:00:00")
					{
						$this->total += (int)TIME_SURCHARGE_PRICE;
						$response["to_time_surcharge_price"] = TIME_SURCHARGE_PRICE;
					}*/

					$check_pickup_working_time = $this->locations_model->get_working_time($this->pickup_location,date("Y-m-d"));
					if($check_pickup_working_time["status"] == "success")
					{
						$pickup_lower_bound = strtotime($check_pickup_working_time["working_from"]);
						$pickup_upper_bound = strtotime($check_pickup_working_time["working_to"]);
					}
					else
					{
						$pickup_lower_bound = strtotime($pickup_location_details["working_from"]);
						$pickup_upper_bound = strtotime($pickup_location_details["working_to"]);
					}

					$check_dropoff_working_time = $this->locations_model->get_working_time($this->dropoff_location,date("Y-m-d"));

					if($check_dropoff_working_time["status"] == "success")
					{
						$dropoff_lower_bound = strtotime($check_dropoff_working_time["working_from"]);
						$dropoff_upper_bound = strtotime($check_dropoff_working_time["working_to"]);
					}
					else
					{
						$dropoff_lower_bound = strtotime($dropoff_location_details["working_from"]);
						$dropoff_upper_bound = strtotime($dropoff_location_details["working_to"]);
					}

					$user_selected_pickup_time = strtotime($this->pickup_time.":00");
					$user_selected_dropoff_time = strtotime($this->dropoff_time.":00");

					if(($user_selected_pickup_time < $pickup_lower_bound || $user_selected_pickup_time > $pickup_upper_bound) || ($pricingDetails["from_time_surcharge_price"] > 0))
					{
						$check_out_of_hours_fee = self::check_out_of_hours_fee($this->pickup_location,$this->dropoff_location,$this->pickup_date,$user_selected_pickup_time,"p",$this->pickup_time.":00",$booking_db_data,$pricingDetails);
						if($check_out_of_hours_fee["status"] == true)
						{
							$this->total += (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["from_time_surcharge_price"] : (float)$check_out_of_hours_fee["out_of_hour_fee"];
							
							$response["from_time_surcharge_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["from_time_surcharge_price"] : display_decimal_price($check_out_of_hours_fee["out_of_hour_fee"]);			
						}
						else
						{
							$this->total += (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["from_time_surcharge_price"] : (float)TIME_SURCHARGE_PRICE;

							$response["from_time_surcharge_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["from_time_surcharge_price"] : display_decimal_price(TIME_SURCHARGE_PRICE);
						}
					}

					if(($user_selected_dropoff_time < $dropoff_lower_bound || $user_selected_dropoff_time > $dropoff_upper_bound) || ($pricingDetails["to_time_surcharge_price"] > 0))
					{
						$check_out_of_hours_fee = self::check_out_of_hours_fee($this->dropoff_location,$this->pickup_location,$this->dropoff_date,$user_selected_dropoff_time,"d",$this->dropoff_time.":00",$booking_db_data,$pricingDetails);
						if($check_out_of_hours_fee["status"] == true)
						{
							$this->total += (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["to_time_surcharge_price"] : (float)$check_out_of_hours_fee["out_of_hour_fee"];

							$response["to_time_surcharge_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["to_time_surcharge_price"] : display_decimal_price($check_out_of_hours_fee["out_of_hour_fee"]);
						}
						else
						{
							$this->total += (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["to_time_surcharge_price"] : (float)TIME_SURCHARGE_PRICE;

							$response["to_time_surcharge_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["to_time_surcharge_price"] : display_decimal_price(TIME_SURCHARGE_PRICE);
						}
					}
				}

				/*working time surcharge needed to implement ends*/

				/*$this->per_day_total_price=round($this->total/$this->booking_total_days,2);
				$this->per_day_special_offer_total_price=round($this->total/$this->booking_total_days,2);*/

				/*Facilities pricing calculate*/
				$check_facilities_status = $this->get_facilities_price($booking_db_data,$pricingDetails);
				/*Facilities pricing calculate*/

				/*Insurance Pricing*/			
				$check_insurance_status = $this->get_insurance_price($booking_db_data,$pricingDetails);
				/*Insurance Pricing ends*/

				/*Apply coupon if applied*/
				$check_coupon_applied_flag = $this->apply_coupon_price($car_data,$discount_coupon,$pricingDetails);
				if($check_coupon_applied_flag == true)
				{
					$this->total -= $this->coupon_applied_price;
				}
				/*Apply coupon if applied*/

			}
			$response["per_day_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["per_day_price"] : display_decimal_price($this->per_day_price);
			$response["per_day_special_offer_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["per_day_special_offer_price"] : display_decimal_price($this->per_day_special_offer_price);			
			/*$response["basic_price"] = $this->basic_price;
			$response["advanced_price"] = $this->advanced_price;*/
			$response["dropoff_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["dropoff_price"] : display_decimal_price($this->dropoff_price);			
			/*$response["original_price"] = (!empty($pricingDetails) && $price_change_flag == true && $pricingDetails["booking_total_days"] == $this->booking_total_days) ? $pricingDetails["original_price"] : display_decimal_price($this->original_price);*/
			$response["original_price"] = display_decimal_price($this->original_price);
			
			/*$response["total"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["total"] : display_decimal_price($this->total);*/
			
			$response["total"] = display_decimal_price($this->total);

			$response["special_offer_price"] = (!empty($pricingDetails) && $price_change_flag == true && $pricingDetails["booking_total_days"] == $this->booking_total_days) ? $pricingDetails["special_offer_price"] : display_decimal_price($this->special_offer_price);

			$response["special_offer_original_price"] = $this->special_offer_original_price;	
			$response["special_offer_original_type"] = $this->special_offer_original_type;	

			$response["special_offer_opposite_price"] = (!empty($pricingDetails) && $price_change_flag == true) ? $pricingDetails["special_offer_opposite_price"] : display_decimal_price($this->special_offer_opposite_price);
			
			$response["special_offer_display_label"] = $this->special_offer_display_label;

			
			$response["is_special_offer"] = $this->is_special_offer;	
			$response["coupon_applied_price"] = display_decimal_price($this->coupon_applied_price);
			$response["booking_total_days"] = $this->booking_total_days;
			$response["driver_age_price"] = display_decimal_price($this->driver_age_price);
			$response["driver_age_price_default"] = display_decimal_price(SPECIAL_AGE_PRICE);
			

			/*$response["insurance_price"] = (!empty($pricingDetails) && $price_change_flag == true && !empty($booking_db_data) && $booking_db_data["insurance"] == $this->insuranceGroupId) ? $pricingDetails["insurance_price"] : display_decimal_price($this->insurance_price);*/
			$response["insurance_price"] = display_decimal_price($this->insurance_price);


			$response["time_surcharge_price"] = display_decimal_price(TIME_SURCHARGE_PRICE);
			$response["insurance_text"] =  $this->insurance_text;

			$this->per_day_price = 0;
			$this->basic_price = 0;
			$this->advanced_price = 0;
			$this->dropoff_price = 0;
			$this->original_price = 0;
			$this->total = 0;
			$this->special_offer_price = 0;
			$this->coupon_applied_price = 0;
			$this->special_offer_opposite_applied_flag = false;
			return $response;
		}
		else{
			return false;
		}
	}

	public function get_advanced_price($loopDate,$all_seasons)
	{
		if(!empty($all_seasons))
		{
			foreach ($all_seasons as $key => $value) 
			{
				/*$date1 = $value["start_month"]."-".$value["start_date"];*/
				$date1 = date('m-d',strtotime($value["start_date"]));
				/*$date2 = $value["end_month"]."-".$value["end_date"];*/
				$date2 = date('m-d',strtotime($value["end_date"]));
				$checkstatus = check_in_range($date1,$date2,$loopDate);
				if($checkstatus)
				{
					$season_id = $value["id"];
				}
			}
		}
		$loopDate = date(date('Y').'-m-d',strtotime($loopDate));
		/*$select_month = date("m",strtotime($loopDate));
		$select_date = date("d",strtotime($loopDate));*/
		
		if($season_id > 0)
		{
			$advanced_price_where[] = array('pricing.type="a" AND pricing.categoryId = "'.$this->car_category.'" AND rental_days.status="y" AND day_price.price > 0 AND rental_days.day <= "'.$this->booking_total_days.'" AND pricing.seasonId = "'.$season_id.'"',null,false);
			
			/*$advanced_price_where[] = array("('".$select_month."' BETWEEN season.start_month  and season.end_month) AND ('".$select_date."' BETWEEN season.start_date AND season.end_date)",null,false);*/

			$advanced_price_data = $this->set_fields('pricing.*,day_price.price')->join('day_price', 'pricing.id = day_price.pricingId',"left")->join('rental_days','day_price.dayId=rental_days.id','left')->order_by('ABS(cast(rental_days.day as signed)-"'.$this->booking_total_days.'")')->get_by($advanced_price_where); 
			if(!empty($advanced_price_data))
			{
				$this->advanced_price += $advanced_price_data["price"];
			}
			if($this->advanced_price > 0){
				return true;
			}
		}	
		return false;
	}

	public function get_basic_price()
	{	
		$basic_price_where = array();
		$basic_price_where[] = array('pricing.type="b" AND pricing.categoryId = "'.$this->car_category.'" AND rental_days.status="y" AND day_price.price > 0 AND rental_days.day <= "'.$this->booking_total_days.'"',null,false);
		$basic_price_data = $this->set_fields('pricing.*,day_price.price')->join('day_price', 'pricing.id = day_price.pricingId',"left")->join('rental_days','day_price.dayId=rental_days.id','left')->order_by('ABS(cast(rental_days.day as signed) - "'.$this->booking_total_days.'")')->limit(1,0)->get_by($basic_price_where); 
		if(!empty($basic_price_data))
		{
			$this->basic_price = $basic_price_data["price"];
			return true;
		}
		return false;
	}

	public function check_special_offer_opposite($tempDatec = '',$current_day_price = 0)
	{
		/*$special_offer_opposite_sql = "SELECT soo.*,date_format(soo.start_date, '%Y-%m-%d' )  AS start_dt,date_format( soo.end_date, '%Y-%m-%d' ) AS end_dt,'".date("Y-m-d",strtotime($tempDatec))."' as select_date FROM `tbl_special_offer_opposite` soo left join tbl_special_offer_opposite_car_details soo_cd on soo_cd.offerId=soo.id left join  tbl_special_offer_opposite_location_details soo_ld on soo_ld.offerId=soo.id WHERE soo_cd.carId = '".$car_id."' AND soo_ld.locationId = '".$pickup_location."' HAVING ((select_date >= start_dt and select_date <= end_dt) or (select_date >= start_dt and select_date <= end_dt)) LIMIT 1";*/
		$response = array();		
		if($tempDatec != '')
		{
			$this->load->model("special_offer_opposite_model");
			$special_offer_opposite_where[] = array("special_offer_opposite.status='y' AND soo_cd.carId = '".$this->car_id."' AND soo_ld.locationId = '".$this->pickup_location."'",null,false);

			$special_offer_opposite_exist_check = $this->special_offer_opposite_model->set_fields("special_offer_opposite.*,date_format(special_offer_opposite.start_date, '%Y-%m-%d' )  AS start_dt,date_format( special_offer_opposite.end_date, '%Y-%m-%d' ) AS end_dt,'".date("Y-m-d",strtotime($tempDatec))."' as select_date")
			->join("special_offer_opposite_car_details as soo_cd","soo_cd.offerId=special_offer_opposite.id","left")
			->join("special_offer_opposite_location_details as soo_ld","soo_ld.offerId=special_offer_opposite.id","left")
			->having("((select_date >= start_dt and select_date <= end_dt) or (select_date >= start_dt and select_date <= end_dt))")
			->limit(1,0)
			->get_by($special_offer_opposite_where);
			if(!empty($special_offer_opposite_exist_check) && $current_day_price > 0)
			{
				if($special_offer_opposite_exist_check["type"] == "a")
				{
					$response["status"] = "success";
					$response["price"] =  $special_offer_opposite_exist_check["price"];
				}
				else if($special_offer_opposite_exist_check["type"] == "p")
				{
					$response["status"] = "success";
					$response["price"] = ($current_day_price * $special_offer_opposite_exist_check["price"])/100;
				}			
			}
			else
			{
				$response["status"] = "error";
				$response["price"] = 0;
			}
		}
		return $response;
	}

	public function check_special_offer_opposite_old()
	{

		$this->load->model("special_offer_opposite_model");
		$special_offer_opposite_where[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date)) AND status='y' AND price > 0 AND categoryId = '".$this->car_category."'",null,false);

		$special_offer_opposite_exist_check = $this->special_offer_opposite_model->set_fields("soo.*,date_format(soo.start_date, '%Y-%m-%d' )  AS start_dt,date_format( soo.end_date, '%Y-%m-%d' ) AS end_dt,'".date("Y-m-d",strtotime($tempDatec))."' as select_date")
		->join("special_offer_opposite_car_details as soocd","","left")
		->join("special_offer_opposite_location_details as soold","","left")
		->get_by($special_offer_opposite_where);
		if(!empty($special_offer_opposite_exist_check))
		{

			if($special_offer_opposite_exist_check["type"] == "a")
			{
				$this->special_offer_opposite_price = $special_offer_opposite_exist_check["price"];
			}else if($special_offer_opposite_exist_check["type"] == "p"){

				$this->special_offer_opposite_price = ($this->total * $special_offer_opposite_exist_check["price"])/100;
			}
			return true;
		}
		else{
			return false;
		}
	}

	public function check_special_offer()
	{
		$this->load->model("offers_model");
		$special_offer_where[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date))  AND  status='y' AND price > 0 AND groupId = '".$this->car_group."'",null,false);

		$this->offers_model->allow_after_get = true;
		$this->offers_model->get_offers_location_data = false;
		/*$special_offer_exist_check = $this->offers_model->limit(1,0)->get_by($special_offer_where);*/
		$special_offer_exist_check = $this->offers_model->set_fields('offers.*')
		->join('offers_location_detail', 'offers_location_detail.offerId = offers.id AND offers_location_detail.locationId = "'.$this->pickup_location.'"')
		->join('offers_cars_detail as ocd', 'ocd.offerId = offers.id AND ocd.carId = "'.$this->car_id.'"')
		->limit(1,0)
		->get_by($special_offer_where); 

		$this->offers_model->allow_after_get = false;
		$this->offers_model->get_offers_location_data = true;

		if(!empty($special_offer_exist_check))
		{
			$car_ids = array();
			foreach ($special_offer_exist_check["db_sel_cars"] as $key => $value) 
			{
				$car_ids[] = $value["id"];
			}
			
			if(in_array($this->car_id, $car_ids))
			{
				if($special_offer_exist_check["type"] == "a")
				{
					$this->special_offer_price = $special_offer_exist_check["price"];
					$this->special_offer_display_label = '€'.$special_offer_exist_check["price"];
				}
				else if($special_offer_exist_check["type"] == "p")
				{
					$this->special_offer_price = ($this->total * $special_offer_exist_check["price"])/100;
					$this->special_offer_display_label = $special_offer_exist_check["price"].'%';
				}

				$this->special_offer_original_price = $special_offer_exist_check["price"];
				$this->special_offer_original_type = $special_offer_exist_check["type"];

			}			
			return true;
		}
		else{
			$this->special_offer_display_label = '';
			$this->special_offer_original_price = '';
			$this->special_offer_original_type = '';
			return false;
		}
	}

	public function get_facilities_price($booking_db_data = array(),$pricingDetails = array())
	{
		if(!empty($this->booking_selected_facilities))
		{
			$this->load->model("car_facilities_model");
			$facilities_where[] = array('car_facilities.id IN ('.implode(",",$this->booking_selected_facilities).')',null,false);

			$this->car_facilities_model->pickup_date = $this->pickup_date;
			$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
			/*printr($get_facilities_data);*/
			if(!empty($get_facilities_data))
			{
				foreach ($get_facilities_data as $key => $value) 
				{
					if($value["type"] == "m")
					{
						$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];
					}

					if((($value["type"] == "s" && $pricingDetails["booking_total_days"] == $this->booking_total_days) || ($value["type"] == "m" && $pricingDetails["booking_total_days"] == $this->booking_total_days && $post_value_check_quantity == $booking_db_data["booking_selected_facilities"][$value["id"]])) && array_key_exists($value["id"], $booking_db_data["booking_selected_facilities"]))
					{
						$this->total += $booking_db_data["booking_selected_facilities_price"][$value["id"]];
					}
					else
					{
						/*check if this exist in free faciliity timing*/
						if(isset($value["is_promo_code"]) && $value["is_promo_code"] == "yes")
						{
							/*check is any amount need to be paid*/
							if($value["promo_code_type"] == 'a')
							{
								$this->total +=  $this->booking_total_days*$value["promo_code_price"];
							}
							else
							{
								$this->total += 0;
							}
							/*check if this exist in free faciliity timing ends*/
						}
						else
						{

							if($value["type"] == "m")
							{
								$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];

								/*edit pricing quantity wise price change*/

								if($this->car_id == $booking_db_data["car_id"] && $post_value_check_quantity != $booking_db_data["booking_selected_facilities"][$value["id"]] && array_key_exists($value["id"], $booking_db_data["booking_selected_facilities"]))
								{
									if($value["daily_cost"] == 0)
									{
										$value["price"] = $booking_db_data["booking_selected_facilities_price"][$value["id"]] / $booking_db_data["booking_selected_facilities"][$value["id"]];
									}
									else
									{
										$value["price"] = ($booking_db_data["booking_selected_facilities_price"][$value["id"]] / $booking_db_data["booking_selected_facilities"][$value["id"]]) / $pricingDetails["booking_total_days"];	
									}
								}

								/*edit pricing quantity wise price change ends*/

								if($value["daily_cost"] == 0)
								{
									$this->total += ($post_value_check_quantity * $value["price"]);
								}	
								else{
									$all_days_facilities_price = $this->booking_total_days*($post_value_check_quantity * $value["price"]);
									if($all_days_facilities_price > $value['maximum_cost'])
									{
										$this->total += $value['maximum_cost'];
									}
									else{
										$this->total +=  $all_days_facilities_price;
									}
								}
							}
							else
							{
								if($value["daily_cost"] == 0)
								{
									$this->total += $value["price"];
								}	
								else{
									$all_days_facilities_price = $this->booking_total_days*$value["price"];
									if($all_days_facilities_price > $value['maximum_cost']){
										$this->total += $value['maximum_cost'];
									}
									else{
										$this->total +=  $all_days_facilities_price;
									}
								}	
							}
						}
					}					
				}
				return true;
			}
		}
		else{
			return false;
		}
	}


	public function get_insurance_price($booking_db_data = array(),$pricingDetails = array())
	{	
		if($this->insuranceGroupId > 0)
		{
			$this->load->model("category_insurance_price_model");
			$this->load->model("insurance_group_model");
			if(!empty($booking_db_data) && $booking_db_data["insurance"] == $this->insuranceGroupId && $booking_db_data["car_id"] == $this->car_id && $pricingDetails["booking_total_days"] == $this->booking_total_days)
			{
				$insurance_data_arr = $this->insurance_group_model->get($this->insuranceGroupId);
				if(!empty($insurance_data_arr))
				{
					$this->insurance_text = $insurance_data_arr["name"];	
				}
				$this->insurance_price = $pricingDetails['insurance_price'];
				$this->total += $pricingDetails['insurance_price'];
			}
			else
			{
				$inusrance_where[] = array('groupId = "'.$this->insuranceGroupId.'" AND categoryId = "'.$this->car_category.'"',null,false);
				$get_insurance_data = $this->category_insurance_price_model->set_fields("category_insurance_price.*")->get_by($inusrance_where);
				if(!empty($get_insurance_data))
				{

					$insurance_data_arr = $this->insurance_group_model->get($this->insuranceGroupId);
					if(!empty($insurance_data_arr))
					{
						$this->insurance_text = $insurance_data_arr["name"];	
					}				
					$all_days_insurance_price = $this->booking_total_days*$get_insurance_data["price"];
					if($all_days_insurance_price > $get_insurance_data['max_price'])
					{
						$this->insurance_price = $get_insurance_data['max_price'];
						$this->total += $get_insurance_data['max_price'];
					}
					else
					{
						$this->insurance_price = $all_days_insurance_price;
						$this->total +=  $all_days_insurance_price;
					}				
					return true;
				}
			}



			
		}
		else{
			return false;
		}
	}


	public function get_age_surcharge_price($booking_db_data = array(),$pricingDetails = array())
	{	
		/*$this->booking_user_age===0 && $*/
		if(!empty($booking_db_data) && !empty($pricingDetails) && $pricingDetails["driver_age_price"] != '' && $pricingDetails["booking_total_days"] == $this->booking_total_days)
		{	
			$this->driver_age_price = $pricingDetails["driver_age_price"];
			return true;
		}
		else
		{
			if(($this->booking_user_driveragenumber > DRIVER_MAXIMUM_AGE) || ($this->booking_user_driveragenumber < DRIVER_MINIMUM_AGE && $this->booking_user_driveragenumber >= USER_MINIMUM_AGE))
			{
				$special_age_price = $this->booking_total_days * (int)SPECIAL_AGE_PRICE;
				$this->driver_age_price = 0;
				/*$this->driver_age_price += $this->booking_total_days*$special_age_price;*/
				$this->driver_age_price += $special_age_price;
				return true;
			}		
			else
			{
				return false;
			}
		}
	}


	public function check_out_of_hours_fee($locationId,$dropoff_location_id = '',$pickup_date = '',$selected_time = '',$type = '',$selected_o_time = '',$booking_db_data = array(),$pricingDetails = array())
	{
		if($locationId != '' && $selected_time != '' && $type != '')
		{
			if(!empty($booking_db_data) && !empty($pricingDetails) && ($pricingDetails["from_time_surcharge_price"] != '' || $pricingDetails["to_time_surcharge_price"] != '') && $pricingDetails["booking_total_days"] == $this->booking_total_days)
			{	
				$response["status"] = true;
				$response["msg"] = '';
				$response["out_of_hour_fee"] = ($type == 'p') ? $pricingDetails['from_time_surcharge_price'] : $pricingDetails['to_time_surcharge_price'];
			}
			else
			{
				$response = array("status"=>false);
				$this->load->model("out_of_hours_fee_model");
				$where_ar[] = array("('".$pickup_date."' BETWEEN start_date AND end_date) AND out_of_hours_fee.locationId = '".$locationId."'  AND status = 'y' AND ('".$selected_o_time."' BETWEEN from_time AND to_time)",null,false);
				$exist_check = $this->out_of_hours_fee_model->get_many_by($where_ar);
				if(!empty($exist_check))
				{
					foreach ($exist_check as $key => $value) 
					{
						$startTime = strtotime($value["from_time"]);
						$endTime  = strtotime($value["to_time"]);
						$currentTime = $selected_time;
						/*	if (($startTime < $endTime && $currentTime >= $startTime && $currentTime <= $endTime) || ($startTime > $endTime && ($currentTime >= $startTime || $currentTime <= $endTime))) */

						/*  if (($startTime < $endTime && $currentTime >= $startTime && $currentTime < $endTime) || ($startTime > $endTime && ($currentTime >= $startTime || $currentTime < $endTime))) */

						if (($startTime < $endTime && $currentTime >= $startTime && $currentTime <= $endTime) || ($startTime > $endTime && ($currentTime >= $startTime || $currentTime < $endTime))) 
						{
							$response["status"] = true;
							$response["msg"] = '';
							$response["out_of_hour_fee"] = $value['out_of_hour_fee'];
							break; 
						} 
					}				
				}
				else
				{
					$response["status"] = false;
				}
			}			
		}
		else
		{
			$response["status"] = false;
			
		}		
		return $response;
	}

	public function apply_coupon_price($car_data = null,$discount_coupon = 0,$pricingDetails = array())
	{
		$coupon_id = $this->session->userdata("coupon_id");	
		if(!empty($car_data) && $coupon_id > 0)
		{	
			$this->load->model("coupons_model");
			$this->load->model("coupons_car_details_model");
			$coupon_data = $this->coupons_model->get($coupon_id);
			if(!empty($coupon_data["db_sel_cars"]))
			{
				$db_sel_cars_id = array();
				foreach ($coupon_data["db_sel_cars"] as $key => $value) 
				{
					$db_sel_cars_id[] = $value["carId"];		
				}
			}

			if(in_array($this->car_id, $db_sel_cars_id))
			{
				if($this->total >= $coupon_data["minimum_total"])
				{
					if($coupon_data["type"] == 1)
					{
						$this->coupon_applied_price = $coupon_data["value"];
					}
					else if($coupon_data["type"] == 0)
					{
						$coupon_deduct_price = ($this->total * $coupon_data["value"])/100;;
						$this->coupon_applied_price = $coupon_deduct_price;
					}	
				}
			}
			return true;
		}
		else if($discount_coupon > 0 && !empty($pricingDetails))
		{
			/*$pricingDetails = json_decode($pricingDetails,true);*/
			$this->coupon_applied_price = (float)$pricingDetails["coupon_applied_price"];
			return true;
		}
		else
		{
			return false;
		}
	}

	public function before_delete($data)
	{
		if(!$this->current_session)
		{	
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}

	public function after_get($data)
	{

		/*echo $this->db->last_query();

		echo "\n\n";
		printr($data);*/


		if(!empty($data) && $this->after_get_allow==true)
		{
			$this->load->model("categories_model");
			$this->load->model("season_model");
			$this->load->model("day_price_model");
			if($data["categoryId"] > 0)
			{
				$cat_ar = $this->categories_model->set_fields("category")->get($data["categoryId"]);
				$data["category"] = $cat_ar["category"];
			}
			if($data["seasonId"] > 0)
			{
				$cat_ar = $this->season_model->set_fields("season_name,start_date,end_date")->get($data["seasonId"]);
				$data["season"] = $cat_ar["season_name"];
				/*$data["season_date"] = $cat_ar["start_month"]."/".$cat_ar["start_date"]." - ".$cat_ar["end_month"]."/".$cat_ar["end_date"];*/
				$data["season_date"] = date('m/d',strtotime($cat_ar["start_date"]))." - ".date('m/d',strtotime($cat_ar["end_date"]));


			}
			else{
				$data["season"] = "Start From";	
			}
			$pricing_ar = $this->day_price_model->get_many_by('pricingId',$data["id"]);
			if(!empty($pricing_ar))
			{
				$final_pricing_ar = array();
				foreach ($pricing_ar as $key => $value) 
				{
					$final_pricing_ar[$value["dayId"]] = $value["price"];
				}
				$data["pricing_ar"] = $final_pricing_ar;
			}
		}

		/*echo "\n\n\n\n";
		printr($data);*/

		return $data;
	}

	public function after_create($priceiId,$data)
	{
		if($data["type"])
		{
			$days_val = $this->input->post("rental_days");
			$pricing_day_data = array();
			if(!empty($days_val))
			{
				$i = 0;
				foreach ($days_val as $key => $value) {
					if($value["price"] > 0)
					{
						$pricing_day_data[$i]["pricingId"] = $priceiId;
						$pricing_day_data[$i]["dayId"] = $key;
						$pricing_day_data[$i]["price"] = $value["price"];
						$i++;	
					}
				}
				if(!empty($pricing_day_data))
				{
					$this->load->model("day_price_model");
					$this->day_price_model->insert_many($pricing_day_data,true);
				}
			}
		}		
		return $priceiId;
	}

	public function after_update($data,$updateId){
		$data = $data[0];
		$upd_status = $data[1];
		if($data["type"])
		{
			$this->load->model("day_price_model");
			$days_val = $this->input->post("rental_days");
			$pricing_day_data = array();
			if(!empty($days_val))
			{
				foreach ($days_val as $key => $value) {
					if($value["price"] > 0)
					{
						$temp =   array(
							'pricingId' => $updateId,
							'dayId'        => $key,
							'price'          => $value['price']
						);
						$exist_check_ar = array("pricingId"=>$updateId,"dayId"=>$key);
						$rec_exist_check = $this->day_price_model->get_by($exist_check_ar);
						if(!empty($rec_exist_check))
						{
							$this->day_price_model->update($rec_exist_check["id"],$temp,true);
						}else{
							$this->day_price_model->insert($temp,true);
						}
					}
					else{
						$delete_ar = array("pricingId"=>$updateId,"dayId"=>$key);
						$this->day_price_model->delete_by($delete_ar);
					}
				}
			}
		}
		return $upd_status;
	}
}
