<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class messages_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'messages';
	protected $CI;
	public $is_image_uploaded;
	public $validate = array(
		'location_from'  => array(
			'field' => 'location_from',
			'label' => 'location From',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_FROM_REQUIRED',
				),
			),	

		'location_to'  => array(
			'field' => 'location_to',
			'label' => 'location To',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_TO_REQUIRED',
				),
			),	

		'minimum_days'  => array(
			'field' => 'minimum_days',
			'label' => 'minimum days',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_MINIMUM_DAYS_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),	
		'price'  => array(
			'field' => 'price',
			'label' => 'Price',
			'rules' => 'trim|required|xss_clean|numeric',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_FEE_PRICE_REQUIRED',
				'numeric' => 'lang:NUMERIC_REQUIRED'
				),
			),
		);

	public $before_delete = array('before_delete');
	public $before_create = array('before_create');
	public $after_create = array('after_create');
	public $after_get = array('after_get');
	/*public $after_create = array('after_create');*/

	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
		$this->is_image_uploaded = true;
		$this->load->model("user_model");
		$this->load->model("admin_model");
	}

	public function after_get($data){
		if(!empty($data))
		{
			if($this->admin_id == $data["fromId"])
			{
				$data["message_type"] = " in";
			}else{
				$data["message_type"] = " out";
			}
			if($data["senderType"] == "a")
			{
				$data["fromname"] = $this->admin_username;
				$data["image_path"] = base_url()."image/admin/46/46/admin.png";				
			}else{
				$user_ar = $this->user_model->set_fields("id,firstname,lastname,image")->get_by("id",$data["fromId"]);
				$data["fromname"] = $user_ar["firstname"]." ".$user_ar["lastname"];
				$path = base_url()."image/default/46/46/no_available_image.gif";
				if($user_ar["image"] != "" || $user_ar["image"] != null)
				{
					$path = base_url()."image/profile/".$user_ar["id"]."/46/46/".$user_ar["image"];
				}

				$data["image_path"] = $path;
			}
			$data["timeago"] = timeAgo($data["createdDate"]);
		}
		return $data;
	}

	public function before_create($data)
	{
		$this->load->model("conversation_model");
		if(isset($data["conversation_id"]) && $data["conversation_id"] > 0)
		{
			$conversationid = $data["conversation_id"];
			
		}else{
			$conversation_exist_check_where[] = array("(fromId = '".$data["fromId"]."' AND  toId = '".$data["toId"]."') OR (fromId='".$data["toId"]."' AND toId='".$data["fromId"]."')",null,false); 
			/*$conversation_exist_check_where = array('fromId'=>$data["fromId"],'toId'=>$data["toId"]);*/
			$conversation_data = $this->conversation_model->get_by($conversation_exist_check_where);
			if(empty($conversation_data))
			{
				$insert_data = array(
					'fromId'=>$data["fromId"],
					'toId'=>$data["toId"],
					'createdDate'=>date('Y-m-d H:i:s')
					);	

				$conversationid = $this->conversation_model->insert($insert_data,true);
			}
			else{
				$conversationid = $conversation_data["id"];
			}
		}		
		$data["conversationId"] = $conversationid;
		unset($data["conversation_id"]);
		return $data;
	}

	public function after_create($id,$data)
	{
		$this->load->model("conversation_model");
		$update_array = array("updatedDate"=>date('Y-m-d H:i:s'));
		$this->conversation_model->update($data["conversationId"],$update_array,true);
	}
	
	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}
		return $data;
	}


	

}
