<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class locations_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'locations';
	protected $CI;
	public $is_image_uploaded;
	public $location_faq_allow = false;
	public $after_get_allow = true;
	public $after_get_offer_allow = true;
	public $offers_model_after_allow_overrite = false;

	public $validate = array(
		'location_name'  => array(
			'field' => 'location_name',
			'label' => 'location  Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_NAME_REQUIRED'				
			),
		),	
		'location_type'  => array(
			'field' => 'location_type',
			'label' => ' location_type',
			'rules' => 'trim|required',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_TYPE_REQUIRED'				
			),
		),	

		'meta_keyword'  => array(
			'field' => 'meta_keyword',
			'label' => ' meta Keyword',
			'rules' => 'trim|required',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_META_KEYWORD_REQUIRED'				
			),
		),	
		'meta_desc'  => array(
			'field' => 'meta_desc',
			'label' => ' meta Description',
			'rules' => 'trim|required',
			'error_msg' => array(
				'required'  => 'lang:LOCATION_META_DESCRIPTION_REQUIRED'				
			),
		),	

		'email'  => array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|required|xss_clean|valid_email',
			'error_msg' => array(
				'required'  => 'lang:EMAIL_REQUIRED',
				'valid_email' => 'lang:MSG_VALID_EMAIL'
			),
		),

		'phone'  => array(
			'field' => 'phone',
			'label' => 'Phone',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PHONE_REQUIRED'							
			),
		),

		'fax'  => array(
			'field' => 'fax',
			'label' => 'fax',
			'rules' => 'trim|xss_clean',			
		),

		'opening_days'  => array(
			'field' => 'opening_days',
			'label' => 'Opening Days',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:OPENING_DAYS_REQUIRED'				
			),
		),
		'opening_from'  => array(
			'field' => 'opening_from',
			'label' => 'Opening From',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:OPENING_FROM_REQUIRED'				
			),
		),
		'opening_to'  => array(
			'field' => 'opening_to',
			'label' => 'Opening To',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:OPENING_TO_REQUIRED'				
			),
		),
		'working_from'  => array(
			'field' => 'working_from',
			'label' => 'Opening To',
			'rules' => 'trim|required|xss_clean|working_from_valid',
			'error_msg' => array(
				'required'  => 'lang:WORKING_FROM_REQUIRED',
				'working_from_valid'  => 'lang:WORKING_FROM_VALID',
			),
		),
		'working_to'  => array(
			'field' => 'working_to',
			'label' => 'Woking To',
			'rules' => 'trim|required|xss_clean|working_to_valid',
			'error_msg' => array(
				'required'  => 'lang:OPENING_TO_REQUIRED',
				'working_to_valid'  => 'lang:WORKING_TO_VALID',
			),
		),
		'description'  => array(
			'field' => 'description',
			'label' => 'Description To',
			'rules' => 'trim|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DESCRIPTION_REQUIRED'				
			),
		),
		'direction_desk'  => array(
			'field' => 'direction_desk',
			'label' => 'Direction Desk',
			'rules' => 'trim|xss_clean',
			'error_msg' => array(
				/*'required'  => 'lang:DIRECTION_DESK_REQUIRED'*/				
			),
		),
		'location_note'  => array(
			'field' => 'location_note',
			'label' => 'Location Note',
			'rules' => 'trim|xss_clean',
			'error_msg' => array(							
			),
		),

		'location_manager'  => array(
			'field' => 'location_manager',
			'label' => 'Location Manager',
			'rules' => 'trim|xss_clean',
			'error_msg' => array(

			),
		),	

		'country'  => array(
			'field' => 'country',
			'label' => 'Country',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUNTRY_REQUIRED'				
			),
		),

		'state'  => array(
			'field' => 'state',
			'label' => 'State',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:STATE_REQUIRED'				
			),
		),
		'city'  => array(
			'field' => 'city',
			'label' => 'City',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CITY_REQUIRED'				
			),
		),
		
		'address'  => array(
			'field' => 'address',
			'label' => 'Address',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:ADDRESS_REQUIRED'				
			),
		),
		
		'zip_code'  => array(
			'field' => 'zip_code',
			'label' => 'Zip Code',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:ZIP_CODE_REQUIRED'				
			),
		),

		'latitude'  => array(
			'field' => 'latitude',
			'label' => 'Latitude',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LATITUDE_REQUIRED'				
			),
		),
		'longitude'  => array(
			'field' => 'longitude',
			'label' => 'Longitude',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:LONGITUDE_REQUIRED'				
			),
		)
	);


public $before_delete = array('before_delete');
public $before_create = array('before_create');
public $after_create = array('after_create');
public $before_update = array('before_update');
public $after_get = array('after_get');



public function __construct()
{
	
	parent::__construct();
	$this->current_session=$this->current_session;
	$this->current_login_type=$this->current_login_type;
	$this->CI=& get_instance();
	$this->is_image_uploaded = true;
}

public function before_delete($data){
	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);	
	}
	return $data;
}

public function before_update($data){
	if($this->is_image_uploaded == true && $this->current_session)
	{
		$image_data = $this->get($data["id"]);
		if($_FILES['upload_location_file'] && $_FILES['upload_location_file']['error']==UPLOAD_ERR_OK)
		{
			$update_new_image_ar = $this->upload_image($data["id"]);
			if($update_new_image_ar["location_status"] == "success" || $update_new_image_ar["special_offer_status"] == "success")
			{
				if($update_new_image_ar["location_status"] == "success")
				{
					$exist_check_path = FCPATH."assets/upload/locations/".$data["id"]."/".$image_data["location_image"];	
					if(file_exists($exist_check_path) && $exist_check_path!="")
					{
						unlink($exist_check_path);
					}
				}

				if($update_new_image_ar["special_offer_status"] == "success")
				{
					$exist_check_path_offer = FCPATH."assets/upload/locations/".$data["id"]."/".$image_data["location_image"];	
					
					if(file_exists($exist_check_path_offer) && $exist_check_path_offer!=""){
						unlink($exist_check_path_offer);
					}
				}
				$data['location_image'] = $update_new_image_ar['location_file_name'];	

			}
			else{
				$data['before_return']['msg']=lang("INVALID_REQUEST");	
			}
		}
	}
	else{
		$data['before_return']['msg']=lang("INVALID_REQUEST");					
	}	
	unset($data["id"]);
	return $data;
}


public function before_create($data){
	$data["created"] = date('Y-m-d H:i:s');
	if($_FILES['upload_location_file'] && $_FILES['upload_location_file']['error']==UPLOAD_ERR_OK){		
		return $data;	
	}
	else{
		$data['before_return']['msg']=lang("Please upload photo");	
	}
	return $data;
}
public function after_create($id){
	if($_FILES['upload_location_file'] && $_FILES['upload_location_file']['error']==UPLOAD_ERR_OK){
		$status_ar = $this->upload_image($id);
		if($status_ar["location_status"] == "success")
		{
			$data = array();
			$data['location_image'] = $status_ar['location_file_name'];	
			$this->update($id,$data,true);
		}
		else{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}	
	}
	return $data;
}

public function after_get($data)
{	

	if(!empty($data))
	{
		if(isset($data["location_image"]) && $data["location_image"] != "")
		{
			$data["location_city_image"] = base_url()."image/location/".$data["id"]."/163/165/".$data["location_image"];
			$data["location_city_detail_image"] = base_url()."image/location/".$data["id"]."/560/409/".$data["location_image"];
		}
		else{
			$data["location_city_image"] = base_url()."image/default/163/165/";	
			$data["location_city_detail_image"] = base_url()."image/default/560/409/";	
		}
		$data["city_url"] = base_url()."car-hire-city/".$data["city"];	
		$data["location_url"] = base_url()."car-hire-location/".$data["id"];

		if($this->after_get_allow == true)
		{
			if(isset($this->location_faq_allow) && $this->location_faq_allow == true)
			{
				$this->load->model("faq_sections_model");
				$this->load->model("faq_model");
				$faq_section_ar = $this->faq_sections_model->get_by("name",'Location');
				$faq_where = array("faq.sectionId"=>$faq_section_ar["id"],"fc.status"=>'y');
				$data["faqs"] = $this->faq_model
				->set_fields("faq.*,fc.id as cat_id,fc.name as category_name")
				->join("faq_category as fc","fc.id = faq.categoryId","left")
				->order_by("category_name")
				->get_many_by($faq_where);
			}
			

			if($this->after_get_offer_allow == true)
			{
				$today_date = date('Y-m-d');
				$this->load->model("offers_model");
				$where[] = array("offers_location_detail.locationId = '".$data["id"]."' AND ('".$today_date."' BETWEEN offers.start_date AND offers.end_date OR start_date > '".$today_date."')",null,false); 
				if($this->offers_model_after_allow_overrite == true)
				{
					$this->offers_model->allow_after_get = true;
					$this->offers_model->recursive_set = true;
				}
				else
				{
					$this->offers_model->allow_after_get = false;
				}
				$data["special_offers"] = $this->offers_model
				->set_fields("offers.*,cg.group_name")
				->join('car_groups as cg','cg.id = offers.groupId')
				->join('offers_location_detail', 'offers_location_detail.offerId = offers.id')
				->get_many_by($where);	

				if($this->offers_model_after_allow_overrite == true)
				{
					$this->offers_model->allow_after_get = false;
					$this->offers_model->recursive_set = false;
				}
				else
				{	
					$this->offers_model->allow_after_get = true;
				}
			}
		}
	}
	return $data;
}

public function upload_image($id)
{
	$asset_upload_dir = FCPATH.'assets/upload/'; 
	$asset_locations_dir = FCPATH.'assets/upload/locations/'; 
	$upload_dir = FCPATH.'assets/upload/locations/'.$id.'/'; 

	if(!file_exists($asset_upload_dir)){
		mkdir($asset_upload_dir,777);
	}

	if(!file_exists($asset_locations_dir)){
		mkdir($asset_locations_dir,777);
	}

	if(!file_exists($upload_dir)){
		mkdir($upload_dir,0777);
	}	

	$data = array('location_status'=>'error','special_offer_status'=>'error');
	$maxSize = IMAGE_UPLOAD_MAX_SIZE;

	if($_FILES['upload_location_file']['error']==UPLOAD_ERR_OK){
		$this->load->library('image_lib');
		$name = $_FILES['upload_location_file']['name'];
		$size = $_FILES['upload_location_file']['size'];
		$ext = substr($name, strrpos($name, ".") + 1);

		if ($size < ($maxSize)) {

			$th_arr=array();	
			$config['upload_path'] = $upload_dir;
			$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
			$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$field_name = "upload_location_file";
			if ( ! $this->upload->do_upload($field_name))
			{
				$this->form_validation->set_message('insert',$this->upload->display_errors());
				$data["location_status"] = "error";
				$data["location_msg"] = $this->upload->display_errors();					
			}
			else
			{
				$fileUpd = array('upload_data' => $this->upload->data());
				$data["location_status"] = "success";
				$data['location_file_name'] = $fileUpd['upload_data']['file_name'] ;
			}
		}
		else{
			$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
			$data["location_status"] = 'error';
			$data["location_msg"] ='Image size is too large.maximum image size is '.$maxSize;				
		}	
	}	
	return $data;
}

public function get_working_time($location_id = '',$date = '')
{
	$response_ar = array();
	if($location_id != '' && $date != '')
	{
		$this->load->model("season_location_working_hours_model");
		$this->load->model("season_model");
		$compare_date = '2015-'.date("m-d",strtotime($date));
		$where_ar[] = array("'$compare_date' BETWEEN start_date AND end_date",null,false); 
		$season_data = $this->season_model->get_by($where_ar);
		if(!empty($season_data))
		{
			$get_time_where[]  = array("seasonId = '".$season_data["id"]."' AND locationId = '".$location_id."' AND status = 'y'",null,false);

			$data = $this->season_location_working_hours_model->get_by($get_time_where);

			if(!empty($data))
			{
				$response_ar["status"] = "success";
				$response_ar["working_from"] = $data["working_from"];
				$response_ar["working_to"] = $data["working_to"];
			}
			else
			{
				$response_ar["status"] = "empty";	
			}
		}
		else
		{
			$response_ar["status"] = "empty";
		}
	}
	return $response_ar;
}	
}
