<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class insurance_group_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'insurance_group';
	public $after_get_allow = true;


	protected $CI;
	public $after_get = array( 'after_insurance_group_get' );
	public $after_create = array( 'after_create' );
	public $before_update = array( 'before_update' );


	public $validate = array(
		'name'  => array(
			'field' => 'name',
			'label' => 'Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:NAME_REQUIRED'
				),
			),
		'insurance_items'  => array(
			'field' => 'insurance_items[]',
			'label' => 'Insurance Items',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:INSURANCE_ITEM_REQUIRED'
				),
			),
		);

	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	public function after_insurance_group_get($data)
	{
		if(!empty($data))
		{
			if($this->after_get_allow == true)
			{
				if($data["id"] > 0)
				{
					$this->load->model("insurance_detail_model");
					$where = array('insurance_detail.groupId'=>$data["id"]);
					$data["insurance_items"] = $this->insurance_detail_model->set_fields("insurance_detail.itemId,insurance_group_items.name,insurance_group_items.description,insurance_group_items.id")->join('insurance_group_items', 'insurance_group_items.id = insurance_detail.itemId')->as_array()->get_many_by($where);	
				}			
			}
		}
		return $data;
	}		

	public function after_create($groupid){
		$insurance_items = $this->input->post("insurance_items");
		$this->insert_items($groupid,$insurance_items);
		return $groupid;
	}

	public function insert_items($groupId,$insurance_items,$existing_items = array()){
		$this->load->model("insurance_detail_model");
		if(!empty($insurance_items))
		{	
			if(!empty($existing_items))
			{
				$item_string = null;
				foreach ($insurance_items as $key => $value) {
					$item_string .= '"'.$value.'"'.",";	
				}
				$item_string = rtrim($item_string,",");
				$where[] = array("groupId = '".$groupId."'",null,false);
				$where[] = array("itemId NOT IN (".$item_string.")",null,false);
				$this->insurance_detail_model->delete_by($where);
				$insurance_items = array_diff($insurance_items,$existing_items);
			}		
			if(!empty($insurance_items))
			{
				$i = 0;
				$insert_array = array();
				foreach ($insurance_items as $key => $value) {
					$insert_array[$i]["groupId"] = $groupId;
					$insert_array[$i]["itemId"] = $value;
					$i++;
				}
				if(!empty($insert_array))
				{
					$this->load->model("insurance_detail_model");
					$status = $this->insurance_detail_model->insert_many($insert_array);
				}
			}
		}
		return $status;

	}

	public function before_update($data)
	{
		if(!empty($data))
		{
			$this->load->model("insurance_detail_model");
			$insurance_items = $this->input->post("insurance_items");
			if($data["id"] > 0)
			{
				$this->insert_items($data["id"],$insurance_items,$data["db_sel_items"]);	
			}
		}
		
		if(isset($data["id"]))
		{
			unset($data["id"]);	
		}
		
		if(isset($data["db_sel_items"]))
		{
			unset($data["db_sel_items"]);		
		}
		return $data;
	}
}
