<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class insurance_group_items_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'insurance_group_items';
	protected $CI;
	public $validate = array(
		'name'  => array(
			'field' => 'name',
			'label' => 'lang:NAME_REQUIRED',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:NAME_REQUIRED'
				),
			),
		'description'  => array(
			'field' => 'description',
			'label' => 'Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DESCRIPTION_REQUIRED',
				),
			),
		);

	public function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	public function __construct()
	{
		
		parent::__construct();
		$this->CI=& get_instance();
	}
}
