<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coupons_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'coupons';
	public $after_create = array( 'after_create' );
	public $before_update = array('before_update');
	public $after_get = array( 'after_get' );
	protected $CI;
	public $validate = array(
		'code'  => array(
			'field' => 'code',
			'label' => 'code Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_CODE_REQUIRED'
				),
			),
		'type'  => array(
			'field' => 'type',
			'label' => 'type Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_TYPE_REQUIRED'
				),
			),
		'cars'  => array(
			'field' => 'cars[]',
			'label' => 'car Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_CARS_REQUIRED'
				),
			),
		'value'  => array(
			'field' => 'value',
			'label' => 'value Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_VALUE_REQUIRED'
				),
			),

		'start_date'  => array(
			'field' => 'start_date',
			'label' => 'start_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_START_DATE_REQUIRED'
				),
			),
		'end_date'  => array(
			'field' => 'end_date',
			'label' => 'end_date Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:COUPON_END_DATE_REQUIRED'
				),
			),	

		);

public function alpha_dash_space($str)
{
	return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
} 

public function __construct()
{
	
	parent::__construct();
	$this->CI=& get_instance();
}


public function after_get($data)
{
	if(!empty($data))
	{
		$this->load->model("coupons_car_details_model");
		$this->load->model("cars_model");
		$coupon_fields = "coupons_car_details.*,cars.name";
		
		if($data["all_cars"] == "0")
		{
			$where = array('coupons_car_details.couponId'=>$data["id"]);
			$data["db_sel_cars"] = $this->coupons_car_details_model->set_fields($coupon_fields)->join('cars', 'cars.id = coupons_car_details.carId')->get_many_by($where);
		}
		else
		{
			$where = array('status'=>'y');
			$data["db_sel_cars"] = $this->cars_model->set_fields("cars.name,cars.id as carId")->get_many_by($where);
		}
	}
	return $data;
} 

public function before_update($data)
{
	$couponid = $data["id"];
	if($this->input->post("all_cars") != "1")
	{
		$this->insert_enimeties_data($couponid,"cars","carId","coupons_car_details_model",$data["db_sel_cars"]);		
	}
	unset($data["id"]);
	unset($data["db_sel_cars"]);		
	return $data;
}

public function before_delete($data){

	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	return $data;
}

public function after_create($couponid){
	if($this->input->post("all_cars") != "1")
	{
		$this->insert_enimeties_data($couponid,"cars","carId","coupons_car_details_model");			
	}		
	return $couponid;
}	

public function insert_enimeties_data($couponid,$post_name,$field_name,$modal_name,$existing_items = array())
{	
	$insert_batch_array = array();
	$post_data = $this->input->post($post_name);
	$i = 0;
	$this->load->model($modal_name);

	if(!empty($existing_items))
	{
		$item_string = null;
		foreach ($post_data as $key => $value) {
			$item_string .= '"'.$value.'"'.",";	
		}
		$item_string = rtrim($item_string,",");
		$where[] = array("couponId = '".$couponid."'",null,false);
		$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
		$this->{$modal_name}->delete_by($where);
		$post_data = array_diff($post_data,$existing_items);
	}	


	if(!empty($post_data))
	{
		foreach ($post_data as $key => $value) {
			$insert_batch_array[$i]['couponId'] = $couponid;
			$insert_batch_array[$i][$field_name] = $value;				
			$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
			$i++;
		}
		if(!empty($insert_batch_array))
		{
			$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
		}
	}
	return $status;
}




}
