<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class constant_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'constant';
	protected $CI;
	public $validate = array(
		'constant_value'  => array(
			'field' => 'constant_value',
			'label' => 'constant_value',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CONSTANT_VALUE_REQUIRED'
				),
			),
		);
	public $after_update = array( 'after_update' );	
	public $after_delete  = array( 'after_delete' );	
	public $before_delete = array('before_delete');
	public function __construct()
	{
		
		parent::__construct();
		$this->current_session=$this->current_session;
		$this->current_login_type=$this->current_login_type;
		$this->CI=& get_instance();
	}

	public function before_delete($data){
		if(!$this->current_session)
		{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}
		return $data;
	}

	public function generate_language_file()
	{
		$this->load->helper('file');
		$constants = $this->as_object()->get_all();
		$lang=array();
		$my_lang = "english";
		$langstr="<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');\n";
		write_file(FCPATH.'application/language/'.$my_lang.'/site_message_lang.php', $langstr, 'w');
		foreach ($constants as $row)
		{
			$langstr = "\$lang['".$row->constantName."'] = \"".htmlentities($row->constantValue)."\";"."\n";
			write_file(FCPATH.'application/language/'.$my_lang.'/site_message_lang.php', $langstr, 'a');
		}
		
	}

	public function after_delete($data = null){
		$this->generate_language_file();
	}

	public function after_update($data){
		$this->generate_language_file();
		return $data;
	}



}
