<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Characteristics_groups_model extends My_Model
{
	public $primary_key = 'id';
	public $_table = 'characteristics_group';
	protected $CI;
	public $after_get = array( 'after_get' );
	public $after_get_allow = true;
	public $validate = array(
		'char_group_name'  => array(
			'field' => 'char_group_name',
			'label' => 'char Group Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CHARACTERISTICS_GROUP_NAME_REQUIRED',
				/*'alpha_dash_space'  => 'lang:ALPHA_DASH_SPACE_ALLOWED'*/
				),
			),
		);
	

	function alpha_dash_space($str)
	{
		return ( ! preg_match("/^([-a-z_ ])+$/i", $str)) ? FALSE : TRUE;
	} 

	public function __construct()
	{
		parent::__construct();
		$this->CI=& get_instance();
	}

	public function after_get($data)
	{
		if(!empty($data))
		{
			if($this->after_get_allow == true)
			{
				$this->load->model("characteristics_model");
				$where_ar = array('group_id'=>$data["id"],'status'=>'y');
				$data["characteristics"] = $this->characteristics_model->get_many_by($where_ar);	
			}
		}
		return $data;
	}

}
