<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cars_model extends My_Model
{
	public $primary_key = 'id';
	public $only_details_ids = false;
	public $_table = 'cars';
	public $after_create = array( 'after_create' );
	public $after_get = array( 'after_get' );
	public $after_get_allow = true;
	public $after_get_locations_allow = true;
	public $after_get_characteristics_allow = true;
	public $after_get_facilities_allow = true;	
	public $after_get_special_offers_allow = true;
	public $after_get_category_name_allow = true;
	public $after_get_group_name_allow = true;	
	public $before_update_allowed = true;	
	public $offers_model_after_allow_overrite = false;
	public $facility_pickup_date = '';
	public $facility_dropoff_date = '';

	public $before_delete = array('before_delete');
	public $before_create = array('before_create');
	public $before_update = array('before_update');
	protected $CI;
	public $validate = array(
		'name'  => array(
			'field' => 'name',
			'label' => 'Name',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_NAME_REQUIRED',
				/*'callback_alpha_dash_space'=>'lang:ALPHA_DASH_SPACE_ALLOWED'*/
				),
			),
		'groupId'  => array(
			'field' => 'groupId',
			'label' => 'Group Id',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_GROUP_REQUIRED'
				),
			),
		'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'Category Id',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED'
				),
			),
		'description'  => array(
			'field' => 'description',
			'label' => 'Description',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_DESCRIPTION_REQUIRED'
				),
			),
		'quantity'  => array(
			'field' => 'quantity',
			'label' => 'Quantity',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_QUANTITY_REQUIRED'
				),
			),

		'pickuplocation'  => array(
			'field' => 'pickuplocation[]',
			'label' => 'pickup location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_PICKUP_LOCATION_REQUIRED'
				),
			),
		

		);


public function __construct()
{
	
	parent::__construct();
	$this->CI=& get_instance();
}

public function after_get($data)
{
	if(!empty($data))
	{
		$this->load->model("categories_model");
		$this->load->model("car_groups_model");


		if($data["categoryId"] > 0 && $this->after_get_category_name_allow == true)
		{
			$category_ar =  $this->categories_model->set_fields("category")->get($data["categoryId"]);
			$data["category"] = $category_ar["category"];
		}

		if($data["groupId"] > 0 && $this->after_get_group_name_allow == true)
		{
			$car_group_ar =  $this->car_groups_model->set_fields("group_name")->get($data["groupId"]);
			$data["group"] = $car_group_ar["group_name"];
		}
		
		$data["detail_link"] = base_url()."car/".$data["id"];

		if($data["image"] != '' && $data["image"] != NULL)
		{
			$data["image_path"] = base_url()."image/car/".$data["id"]."/500/283/".$data["image"];
			$data["search_image_path"] = base_url()."image/car/".$data["id"]."/264/184/".$data["image"];
			$data["related_image_path"] = base_url()."image/car/".$data["id"]."/263/185/".$data["image"];
		}
		else
		{
			$data["image_path"] = base_url()."image/default/500/283/no_available_image.gif";
			$data["search_image_path"] = base_url()."image/default/264/184/no_available_image.gif";
			$data["related_image_path"] = base_url()."image/default/263/185/no_available_image.gif";
		}

		if($this->after_get_allow == true)
		{
			$this->load->model("car_facilities_model");
			$this->load->model("characteristics_model");
			$this->load->model("locations_model");
			if($data["biggerId"] > 0)
			{
				$this->after_get_allow = false;
				$data["bigger_car_data"] = $this->get($data["biggerId"]);
				$this->after_get_allow = true;
			}
			/*Special offers*/
			if($this->after_get_special_offers_allow == true && $data["id"] > 0)
			{
				$today_date = date('Y-m-d');
				$this->load->model("offers_model");
				$where[] = array("offers_cars_detail.carId = '".$data["id"]."' AND ('".$today_date."' BETWEEN offers.start_date AND offers.end_date OR start_date > '".$today_date."')",null,false); 
				
				if($this->offers_model_after_allow_overrite == true)
				{
					$this->offers_model->allow_after_get = true;
				}
				else
				{
					$this->offers_model->allow_after_get = false;
				}

				$data["special_offers"] = $this->offers_model->set_fields("offers.*")->join('offers_cars_detail', 'offers_cars_detail.offerId = offers.id')->get_many_by($where);

				if($this->offers_model_after_allow_overrite == true)
				{
					$this->offers_model->allow_after_get = false;
				}
				else
				{
					
					$this->offers_model->allow_after_get = true;
				}
			}
			/*Special offers ends*/
			
			if($this->only_details_ids == true)
			{
				$faclility_fields = "car_facilities.id";
				$characteristics_fields = "characteristics.id";
				$locations_fields = "locations.id";
			}
			else{
				$faclility_fields = "car_facilities_detail.carId,car_facilities.id,car_facilities.type,car_facilities.facility_name,car_facilities.price,car_facilities.daily_cost,car_facilities.maximum_cost,car_facilities.popup_title,car_facilities.popup_desc,car_facilities.image,car_facilities.multiple_maximum";
				$characteristics_fields = "characteristics.*";
				$locations_fields = "locations.*";	
			}

			if($this->after_get_facilities_allow == true)
			{
				if($data["id"] > 0)
				{
					$where = array('car_facilities_detail.carId'=>$data["id"]);

					if($this->facility_pickup_date != '' && $this->facility_dropoff_date)
					{
						$this->car_facilities_model->pickup_date = $this->facility_pickup_date;
						$this->car_facilities_model->dropoff_date = $this->facility_dropoff_date;
					}

					$this->car_facilities_model->car_id = $data["id"];
					$db_sel_facilities = $this->car_facilities_model->set_fields($faclility_fields)->join('car_facilities_detail', 'car_facilities_detail.facilityId = car_facilities.id')->as_array()->order_by("car_facilities.id")->get_many_by($where);

					if(!empty($db_sel_facilities))
					{
						foreach ($db_sel_facilities as $key => $value_facility) 
						{
							if($value_facility["is_promo_code"] == "yes" && $value_facility["promo_code_type"] == 'f')
							{
								$data["free_facility_avail"] = "yes";
							}
							$data["db_sel_facilities"][] = $value_facility;
						}
					}
				}				
			}

			if($this->after_get_characteristics_allow == true)
			{
				if($data["id"] > 0)
				{
					$where_char = array('car_characteristics_detail.carId'=>$data["id"]);
					$data["db_sel_characteristics"] = $this->characteristics_model->set_fields($characteristics_fields)->join('car_characteristics_detail', 'car_characteristics_detail.characteristicId = characteristics.id')->as_array()->get_many_by($where_char);
				}
				
			}

			if($this->after_get_locations_allow == true)
			{
				if($data["id"] > 0)
				{
					$where_char = array('car_pickup_location_detail.carId'=>$data["id"]);
					$data["db_sel_pickuplocation"] = $this->locations_model->set_fields($locations_fields)->join('car_pickup_location_detail', 'car_pickup_location_detail.locationId = locations.id')->as_array()->get_many_by($where_char);
				}
			}
		}
	}
	/*printr($data);*/
	return $data;
} 

public function before_create($data){
	$data["created"] = date('Y-m-d H:i:s');
	if($_FILES['image'])
	{		

	}
	else{
		$data['before_return']['msg']=lang("Please upload photo");	
	}
	return $data;
}

public function before_delete($data){
	if(!$this->current_session)
	{
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	$this->after_get_allow = false;
	$image_data = $this->get($data);
	$this->after_get_allow = true;
	$exist_check_path = FCPATH."assets/upload/cars/".$data."/".$image_data["image"];			
	if(file_exists($exist_check_path) && $exist_check_path!=""){
		unlink($exist_check_path);
	}
	return $data;
}

public function after_create($carid,$data){
	/*echo $carid;
	var_dump($carid);*/
	if($_FILES['image'] && $_FILES['image']['error']==UPLOAD_ERR_OK)
	{
		$status_ar = $this->upload_image($carid);
		if($status_ar["status"] == "success")
		{
			$data = array();
			$data['image'] = $status_ar['file_name'];	
			$this->before_update_allowed = false;
			$this->update($carid,$data,true);
			$this->before_update_allowed = true;
		}
		else{
			$data['before_return']['msg']=lang(INVALID_REQUEST);	
		}	
	}

	/*Insert Facilities*/
	if(!empty($this->input->post("facility")))
	{
		$this->insert_enimeties_data($carid,"facility","facilityId","car_facilities_detail_model");
	}
	/*Insert Facilities*/

	/*Characterisitcs insert*/
	if(!empty($this->input->post("characteristics")))
	{
		$this->insert_enimeties_data($carid,"characteristics","characteristicId","car_characteristics_detail_model");
	}
	/*Characterisitcs insert ends*/

	/*Characterisitcs insert*/
	if(!empty($this->input->post("pickuplocation")))
	{
		$this->insert_enimeties_data($carid,"pickuplocation","locationId","car_pickup_location_detail_model");
	}
	/*Characterisitcs insert ends*/
	return $data;
}

public function before_update($data)
{	

	if($this->before_update_allowed == true)
	{
		$carid = $data["id"];
		$image_data = $this->get($data["id"]);
		if($_FILES['image']["name"] != "")
		{	
			$update_new_image_ar = $this->upload_image($data["id"]);
			if($update_new_image_ar["status"] == "success")
			{
				if($update_new_image_ar["status"] == "success")
				{
					$exist_check_path = FCPATH."assets/upload/cars/".$data["id"]."/".$image_data["image"];	
					if(file_exists($exist_check_path) && $exist_check_path!=""){
						unlink($exist_check_path);
					}
				}
				$data['image'] = $update_new_image_ar['file_name'];
			}
			else{
				$data['before_return']['msg']=lang("INVALID_REQUEST");	
			}
		}

		/*Insert Facilities*/
		if(!empty($this->input->post("facility")))
		{
			$this->insert_enimeties_data($carid,"facility","facilityId","car_facilities_detail_model",$data["db_sel_facilities"]);	
		}

		/*Insert Facilities*/

		/*Characterisitcs insert*/
		if(!empty($this->input->post("characteristics")))
		{
			$this->insert_enimeties_data($carid,"characteristics","characteristicId","car_characteristics_detail_model",$data["db_sel_characteristics"]);
		}
		/*Characterisitcs insert ends*/

		/*Characterisitcs insert*/
		if(!empty($this->input->post("pickuplocation")))
		{
			$this->insert_enimeties_data($carid,"pickuplocation","locationId","car_pickup_location_detail_model",$data["db_sel_pickuplocation"]);
		}
		/*Characterisitcs insert ends*/

		unset($data["id"]);
		unset($data["db_sel_facilities"]);		
		unset($data["db_sel_characteristics"]);		
		unset($data["db_sel_pickuplocation"]);
	}
	return $data;
}


public function insert_enimeties_data($carid,$post_name,$field_name,$modal_name,$existing_items = array())
{	
	$insert_batch_array = array();
	$post_data = $this->input->post($post_name);
	$i = 0;
	$this->load->model($modal_name);

	if(!empty($existing_items))
	{
		$item_string = null;
		foreach ($post_data as $key => $value) {
			$item_string .= '"'.$value.'"'.",";	
		}
		$item_string = rtrim($item_string,",");
		$where[] = array("carId = '".$carid."'",null,false);
		$where[] = array("$field_name NOT IN (".$item_string.")",null,false);
		$this->{$modal_name}->delete_by($where);
		$post_data = array_diff($post_data,$existing_items);
	}	


	if(!empty($post_data))
	{
		foreach ($post_data as $key => $value) {
			$insert_batch_array[$i]['carId'] = $carid;
			$insert_batch_array[$i][$field_name] = $value;				
			$insert_batch_array[$i]['createdDate'] = date('Y-m-d H:i:s');
			$i++;
		}
		if(!empty($insert_batch_array))
		{

			$status = $this->{$modal_name}->insert_many($insert_batch_array,true);
		}
	}
	return $status;
}

public function upload_image($id)
{
	$asset_upload_dir = FCPATH.'assets/upload/'; 
	$asset_locations_dir = FCPATH.'assets/upload/cars/'; 
	$upload_dir = FCPATH.'assets/upload/cars/'.$id.'/'; 

	if(!file_exists($asset_upload_dir)){
		mkdir($asset_upload_dir,777);
	}

	if(!file_exists($asset_locations_dir)){
		mkdir($asset_locations_dir,777);
	}

	if(!file_exists($upload_dir)){
		mkdir($upload_dir,0777);
	}	

	$data = array('status'=>'error');
	$maxSize = IMAGE_UPLOAD_MAX_SIZE;

	if($_FILES['image']['error']==UPLOAD_ERR_OK){
		$this->load->library('image_lib');
		$name = $_FILES['image']['name'];
		$size = $_FILES['image']['size'];
		$ext = substr($name, strrpos($name, ".") + 1);

		if ($size < ($maxSize)) {

			$th_arr=array();	
			$config['upload_path'] = $upload_dir;
			$config['file_name'] =md5(date("Y-m-d H:i:s").rand());
			$config['allowed_types'] = 'gif|jpg|png|jpeg|JPG|jpe';
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$field_name = "image";
			if ( ! $this->upload->do_upload($field_name))
			{
				$this->form_validation->set_message('insert',$this->upload->display_errors());
				$data["status"] = "error";
				$data["msg"] = $this->upload->display_errors();					
			}
			else
			{
				$fileUpd = array('upload_data' => $this->upload->data());
				$data["status"] = "success";
				$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
			}
		}
		else{
			$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
			$data["status"] = 'error';
			$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
		}	
	}
	return $data;
}





}
