<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Bookings_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'bookings';
	public $after_get = array('after_get');
	public $after_get_allow = true;
	public $before_create = array('before_create');
	public $after_create = array('after_create');	
	public $before_update = array('before_update');
	public $after_update = array('after_update');
	public $after_get_user_info_allow = false;
	public $guest_second_mail_flag = false;
	public $after_update_allow = true;
	public $before_update_allow = true;
	public $usercancel_by_admin = false;
	public $send_user_register_mail = false;
	protected $CI;
	public $validate = array(
		'pickup_location'  => array(
			'field' => 'pickup_location',
			'label' => 'Pickup Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PICKUP_LOCATION_REQUIRED'
				),
			),
		'pickup_date'  => array(
			'field' => 'pickup_date',
			'label' => 'Pickup Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PICKUP_DATE_REQUIRED'
				),
			),
		'pickup_time'  => array(
			'field' => 'pickup_time',
			'label' => 'Pickup Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:PICKUP_TIME_REQUIRED'
				),
			),
		'dropoff_location'  => array(
			'field' => 'dropoff_location',
			'label' => 'Dropoff Location',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DROPOFF_LOCATION_REQUIRED'
				),
			),
		'dropoff_date'  => array(
			'field' => 'dropoff_date',
			'label' => 'Dropoff Date',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DROPOFF_DATE_REQUIRED'
				),
			),
		'dropoff_time'  => array(
			'field' => 'dropoff_time',
			'label' => 'Dropoff Date',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:DROPOFF_TIME_REQUIRED'
				),
			)
		);
public function __construct()
{

	parent::__construct();
	$this->CI=& get_instance();
}
public function before_delete($data)
{
	if(!$this->current_session)
	{	
		$data['before_return']['msg']=lang(INVALID_REQUEST);				
	}
	return $data;
}
public function before_create($data)
{	

	/*$data["email"] check for user exist or not then process*/
	$this->load->model("user_model");
	$this->load->model("car_facilities_model");
	$check_exist_ar = array(
		'email'=>$data["email"]
		);
	$record_exist_check = $this->user_model->get_by($check_exist_ar);
	if(!empty($record_exist_check))
	{
		$data["user_id"] = $record_exist_check["id"];
		$update_array = array(				
			'drivinglicence_no'=> $data["driving_licence"],					
			'country'=> $data["country"],
			'firstname'=> $data["firstname"],
			'lastname'=> $data["lastname"],
			'contactNo'=> $data["contactNo"],
			'address'=> $data["address"]
			);
		$this->user_model->update($record_exist_check["id"],$update_array,true);
		$this->guest_second_mail_flag = true;
	}
	else
	{
		$insert_array = array(
			'firstname'=> $data["firstname"],
			'lastname'=> $data["lastname"],
			'email'=> $data["email"],
			'password'=> mt_rand(),
			'drivinglicence_no'=> $data["driving_licence"],				
			'created' => date('Y-m-d H:i:s'),
			'activation_code'=>md5(time().mt_rand()),
			'country'=>$data["country"],
			'address'=> $data["address"],
			'contactNo'=> $data["contactNo"]
			);

		$this->user_model->validate = array(
			'first_name'  => array(
				'field' => 'first_name',
				'label' => 'First Name',
				'rules' => 'trim|required|xss_clean',
				'error_msg' => array(
					'required'  => 'lang:USER_FIRST_NAME_REQUIRED'
					),
				),
			'last_name'  => array(
				'field' => 'last_name',
				'label' => 'Last Name',
				'rules' => 'trim|required|xss_clean',
				'error_msg' => array(
					'required'  => 'lang:USER_LAST_NAME_REQUIRED'
					),
				),
			'email'  => array(
				'field' => 'email',
				'label' => 'Email',
				'rules' => 'trim|required|xss_clean|valid_email|is_unique[users.email]',
				'error_msg' => array(
					'required'  => 'lang:EMAIL_REQUIRED',
					'valid_email' => 'lang:MSG_VALID_EMAIL',
					'is_unique'=>'lang:USER_ALREADY_EXIST'
					),
				)				
			);
		$this->user_model->guest_regiter_email_template = true;
		$data["user_id"] = $this->user_model->insert($insert_array);
		$this->user_model->guest_regiter_email_template = false;
		$this->send_user_register_mail = true;
	}
	$refferal_code = $this->session->userdata("refferal_code");
	if(isset($refferal_code) && $refferal_code != "")
	{
		$this->load->model("refferal_list_model");
		$refferal_exist = $this->refferal_list_model->get_by("code",$refferal_code);
		if(!empty($refferal_exist))
		{
			$data["refferal_id"] = $refferal_exist["id"];	
		}
		else{
			$this->session->unset_userdata("refferal_code");
		}
	}
	$facility_post_insert = array();
	if(!empty($this->input->post('car_facilities')))
	{
		foreach ($this->input->post('car_facilities') as $key => $value) 
		{
			if($value > 0)
			{
				$facility_post_insert[] = $key;	
			}
		}
	}

	/*Insert free facility data*/
	/*prepare facility array*/
	if(!empty($facility_post_insert))
	{
		$facilities_where[] = array('car_facilities.id IN ('.implode(",",$facility_post_insert).')',null,false);
		$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
		$facilities_data_exist = array();
		if(!empty($get_facilities_data))
		{
			foreach ($get_facilities_data as $key => $value) {
				$facilities_data_exist[$value["id"]] = $value;
			}
		}
		/*prepare facility array ends*/
		$facilities = (!empty($this->input->post('car_facilities'))) ? $this->input->post('car_facilities') : '';
		$facilities  = array_filter($facilities);
		if(!empty($facilities))
		{
			$i = 0;
			foreach ($facilities as $key => $value) 
			{
				$check_free = $facilities_data_exist[$value["id"]];
				if($check_free["is_promo_code"] == "yes")
				{
					$temp_array = $check_free;
				}				
			}
			if(!empty($temp_array))
			{
				$data["freeFacility"] = json_encode($temp_array);
			}
		}	
	}
	/*Insert free facility data ends*/

	$receive_newsletter = $this->input->post('receive_newsletter');
	if($receive_newsletter != "")
	{
		$this->load->model("newsletter_model");
		$check_exist_where = array("email"=>$data["email"]);
		$check_exist = $this->newsletter_model->get_by($check_exist_where);
		if(empty($check_exist))
		{
			$insert_array = array("email"=>$data["email"],"createdDate"=>date("Y-m-d H:i:s"));
			$this->newsletter_model->insert($insert_array,true);
		}		
	}

	unset($data["firstname"]);		
	unset($data["lastname"]);		
	unset($data["email"]);		
	unset($data["driving_licence"]);		
	unset($data["country"]);
	/*unset($data["address"]);*/

	unset($data["receive_newsletter"]);
	unset($data["accept_terms"]);

	return $data;
}
public function after_create($booking_id,$data)
{	
	if($booking_id > 0 && !empty($data))
	{
		$this->load->model("user_model");		
		$this->load->model("countries_model");
		$this->load->model("refferal_list_model");
		$this->after_get_user_info_allow = true;
		$booking_info = $this->get($booking_id);	
		$this->after_get_user_info_allow = false;


		$new_booking_id 	= date("dmY").$booking_id;

		/*send user register mail*/
		if($this->send_user_register_mail == true)
		{
			$user_detail = $this->user_model->get($booking_info["user_id"]);
			$url =	base_url()."activate/".$user_detail["activation_code"];
			$admin = SITE_NM;
			$key = array('{BOOKING_ID}','{USERNAME}','{SITE_NM}','{ACTIVATION_LINK}','{USER_EMAIL}','{PASSWORD}','{SITE_NAME}');
			$val = array($new_booking_id,$user_detail["full_name"],site_name(),$url,$user_detail["email"],$user_detail["password"],site_name());
			send_mail('Guest Register',$key,$val,$user_detail["email"]);

			$update_array = array('password'=>($user_detail["password"]));
			$this->user_model->update($user_detail["id"],$update_array,true);

		}
		/*send user register mail ends*/



		$update_ar_booking = array('booking_no'=>$new_booking_id);
		$this->after_update_allow = false;
		$this->before_update_allow = false;
		$this->update($booking_id,$update_ar_booking,true);
		$this->after_update_allow = true;
		$this->before_update_allow = true;


		if($booking_info["refferal_id"] > 0)
		{
			$refferal_exist = $this->refferal_list_model->get($booking_info["refferal_id"]);
			$bookings = $refferal_exist["bookings"] + 1;
			$update_ar_ref = array('bookings'=>$bookings);
			$upd_status_ref = $this->refferal_list_model->update($booking_info["refferal_id"],$update_ar_ref,true);
		}
		$booking_price_ar = (array)json_decode($data["pricingDetails"]);
		$sitename =SITE_NM;

		$username = $booking_info["user_info"]["firstname"]." ".$booking_info["user_info"]["lastname"];
		$useremail = $booking_info["user_info"]["email"];
		$userphone = $booking_info["contactNo"];
		$userlicence = $booking_info["user_info"]["drivinglicence_no"];
		$user_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_info["user_info"]["country"]);;
		$user_country_name = $user_country_name_ar["country_name"];
		$flight_no = $data["flight_no"];		
		$user_note = $booking_info["note"];
		$booking_no = $new_booking_id;
		$car_name = $booking_info["car_info"]['name'];
		$car_category_name = $booking_info["car_info"]['category'];
		$car_group_name = $booking_info["car_info"]['group'];
		$sub_total = $data["sub_total"];
		$dropoff_fee = $booking_price_ar["dropoff_price"];
		/*$extras = $booking_price_ar[""];*/
		$extras = "";

		$total =  $booking_price_ar["total"];
		$pickup_location_name = $booking_info["pickup_location_ar"]["location_name"];
		$dropoff_location_name = $booking_info["dropoff_location_ar"]["location_name"];
		$pickup_date = $data["pickup_date"];
		$pickup_time = $data["pickup_time"];
		
		$pick_loc_address = $booking_info["pickup_location_ar"]["address"];
		$pick_loc_city = $booking_info["pickup_location_ar"]["city_name"];
		$pick_loc_zip =$booking_info["pickup_location_ar"]["zip_code"];
		$pick_loc_phone = $booking_info["pickup_location_ar"]["phone"];
		
		/*$pick_loc_opening_days =  $booking_info["pickup_location_ar"]["opening_days"];*/
		$pick_loc_opening_days =  date('H:i', strtotime($booking_info["pickup_location_ar"]["opening_from"]))." - ".date('H:i', strtotime($booking_info["pickup_location_ar"]["opening_to"]));


		$pick_loc_opening_time = $booking_info["pickup_location_ar"]["opening_from"];
		$pickup_location_manager = strip_tags($booking_info["pickup_location_ar"]["location_manager"]);
		$pickup_direction_desk = strip_tags($booking_info["pickup_location_ar"]["direction_desk"]);
		$pickup_location_note = strip_tags($booking_info["pickup_location_ar"]["location_note"]);

		$pickup_working_time = date('H:i', strtotime($booking_info["pickup_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["pickup_location_ar"]["working_to"]));

		$dropoff_date = $data["dropoff_date"];
		$dropoff_time = $data["dropoff_time"];
		$drop_loc_address = $booking_info["dropoff_location_ar"]["address"];;
		$drop_loc_city = $booking_info["dropoff_location_ar"]["city_name"];
		$drop_loc_zip = $booking_info["dropoff_location_ar"]["zip_code"];
		$drop_loc_phone = $booking_info["dropoff_location_ar"]["phone"];
		
		/*$drop_loc_opening_days = $booking_info["dropoff_location_ar"]["opening_days"];*/
		$drop_loc_opening_days =  date('H:i', strtotime($booking_info["dropoff_location_ar"]["opening_from"]))." - ".date('H:i', strtotime($booking_info["dropoff_location_ar"]["opening_to"]));

		$drop_loc_opening_time = $booking_info["dropoff_location_ar"]["opening_from"];

		$dropoff_location_manager = strip_tags($booking_info["dropoff_location_ar"]["location_manager"]);
		$dropoff_direction_desk = strip_tags($booking_info["dropoff_location_ar"]["direction_desk"]);
		$dropoff_location_note = strip_tags($booking_info["dropoff_location_ar"]["location_note"]);

		$dropoff_working_time = date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_to"]));

		$insurance_price = $booking_price_ar["insurance_price"];
		$insuraince_type_name =  $booking_info["insurance_name"];
		$deposit = $booking_info["insurance_deposit"];
		$facilities = (!empty($this->input->post('car_facilities'))) ? $this->input->post('car_facilities') : '';
		$facilities  = array_filter($facilities);
		$this->load->model("car_facilities_model");

		$user_age = (date('Y') - date('Y',strtotime($booking_info["date_of_birth"])));
		$user_age = ($user_age > 0) ? $user_age : 	$booking_info["driverage"];
		$car_image_path = base_url()."image/car/".$booking_info["car_info"]["id"]."/264/184/".$booking_info["car_info"]["image"];

		$car_image = "<img style='margin: 0 auto;' src='".$car_image_path."' />";

		if(!empty($facilities))
		{
			$i = 0;
			foreach ($facilities as $key => $value) 
			{

				$get_facilities_data = $this->car_facilities_model->get_by("id",$key);
				$booking_total_days = date_difference($pickup_date,$dropoff_date);
				if($booking_total_days > 0)
				{
					if(isset($get_facilities_data["is_promo_code"]) && $get_facilities_data["is_promo_code"] == "yes")
					{
						/*check is any amount need to be paid*/
						if($get_facilities_data["promo_code_type"] == 'a')
						{
							$facility_total =  $booking_total_days*$get_facilities_data["promo_code_price"];
						}
						else
						{
							$facility_total = 0;
						}
						/*check if this exist in free faciliity timing ends*/
					}
					else
					{
						if($get_facilities_data["type"] == "m")
						{
							$post_value_check_quantity =  ($facilities[$key] > 0 && $key != $facilities[$key]) ? $facilities[$key] : 1;
							if($get_facilities_data["daily_cost"] == 0)
							{
								$facility_total = ($post_value_check_quantity * $get_facilities_data["price"]);
							}	
							else{
								$all_days_facilities_price = $booking_total_days*($post_value_check_quantity * $get_facilities_data["price"]);
								if($all_days_facilities_price > $get_facilities_data['maximum_cost'])
								{
									$facility_total =  $get_facilities_data['maximum_cost'];
								}
								else{
									$facility_total = $all_days_facilities_price;
								}
							}
						}
						else
						{
							if($get_facilities_data["daily_cost"] == 0)
							{
								$facility_total = $get_facilities_data["price"];
							}	
							else{
								$all_days_facilities_price = $booking_total_days*$get_facilities_data["price"];
								if($all_days_facilities_price > $get_facilities_data['maximum_cost']){
									$facility_total =  $get_facilities_data['maximum_cost'];
								}
								else
								{
									$facility_total =  $all_days_facilities_price;
								}
							}	
						}
					}
				}

				$insert_data[$i]["facility_id"] = $key;
				$insert_data[$i]["booking_id"] = $booking_id;
				$insert_data[$i]["multipleValue"] = ($facilities[$key] > 0 && $key != $facilities[$key]) ? $facilities[$key] : 1;
				$insert_data[$i]["price"] = ($facility_total > 0) ? $facility_total : 0;
				$i++;
			}
			if(!empty($insert_data))
			{
				$this->load->model("booking_extras_model");
				$this->booking_extras_model->insert_many($insert_data,true);
			}
		}



		if(isset($facilities) and !empty($facilities))
		{
			$date_diff_pickup_date = $pickup_date." ".$pickup_time.":00";
			$date_diff_dropoff_date = $dropoff_date." ".$dropoff_time.":00";
			$booking_total_days = date_difference($date_diff_pickup_date,$date_diff_dropoff_date);

			$extras = $this->facility_price_render($facilities,$booking_total_days,$pickup_date,$dropoff_date,$booking_info["car_info"]['id']);
		}

		$car_characteristics = '';

		/*printr($booking_info);
		printr($booking_info["car_info"]["db_sel_characteristics"]);*/
		if(!empty($booking_info["car_info"]["db_sel_characteristics"]))
		{
			$characteristics = array_column($booking_info["car_info"]["db_sel_characteristics"], 'name');
			$characteristics = implode(",",$characteristics);
		}
		/*printr($characteristics);*/
		if($data["booking_status"] == "a")
		{
			/*$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","{FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE_TYPE}","{INSURANCE}","{DEPOSIT}","{SPECIAL_OFFER_DISCOUNT}");*/

			$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","(FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE_NM}","{INSURANCE}","{DEPOSIT}","{CAR_IMAGE}","{PICKUP_LOCATIONMANAGER}","{PICKUP_DIRECTIONDESK}","{DROPOFF_DIRECTIONDESK}","{DROPOFF_LOCATIONMANAGER}","{PICKUP_LOCATIONNOTE}","{DROPOFF_LOCATIONNOTE}","{FROM_TIME_SURCHRGE}","{TO_TIME_SURCHRGE}","{COUPON_DISCOUNT}","{CAR_CHARACTERISTICS}","{USER_AGE}","{PICKUP_WORKING_TIME}","{DROPOFF_WORKING_TIME}");

				$coupon_discount = ($booking_price_ar["coupon_applied_price"] > 0) ? $booking_price_ar["coupon_applied_price"] : 0;

				$val = array(
					$sitename,
					$username,
					$useremail,
					$booking_info["contactNo"],
					$userlicence,
					$user_country_name,
					$booking_info["flight_no"],
					$booking_info["note"],
					$booking_no,
					$car_name,
					$car_group_name,
					$car_category_name,
					$sub_total,
					$dropoff_fee,
					$extras,
					$total,
					$pickup_location_name,
					$pickup_date,
					$pickup_time,
					$pick_loc_address,
					$pick_loc_city,
					$pick_loc_zip,
					$pick_loc_phone,
					$pick_loc_opening_days,
					$pick_loc_opening_time,
					$dropoff_location_name,
					$dropoff_date,
					$dropoff_time,
					$drop_loc_address,
					$drop_loc_city,
					$drop_loc_zip,
					$drop_loc_phone,
					$drop_loc_opening_days,
					$drop_loc_opening_time,
					$insuraince_type_name,
					$insurance_price,
					$deposit,
					$car_image,
					$pickup_location_manager,
					$pickup_direction_desk,
					$dropoff_direction_desk,
					$dropoff_location_manager,
					$pickup_location_note,
					$dropoff_location_note,
					$booking_price_ar["from_time_surcharge_price"],
					$booking_price_ar["to_time_surcharge_price"],
					$coupon_discount,
					$car_characteristics,
					$user_age,
					$pickup_working_time,
					$dropoff_working_time
					);
send_mail('Booking InFo-User',$key,$val,$useremail);
}
}	



if($data["booking_status"] == "p")
{	


	if(!isset($this->guest_second_mail_flag) || $this->guest_second_mail_flag == true)
	{
		$key=array("{USERNAME}","{BOOKING_STATUS}","{LOGIN_LINK}","{SITE_NM}","{CAR_NAME}","{PICKUP_LOCATION}","{DROPOFF_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{DROPOFF_DATE}","{DROPOFF_TIME}");
		$login_link = site_url().'signin/';

		$val=array($username,'Booking Confirmed',$login_link,site_name(),$car_name,$pickup_location,$dropoff_location,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time);

		send_mail('PendingBooking InFo-User',$key,$val,$useremail);

	}


/*$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","(FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE}","{INSURANCE_TYPE}","{DEPOSIT}","{SPECIAL_OFFER_DISCOUNT}");

$val = array($sitename,$username,$useremail,$userphone,$userlicence,$user_country_name,$flight_no,$user_note,$booking_no,$car_name,$car_group_name,$car_category_name,$sub_total,$dropoff_fee,$extras,$total,$pickup_location_name,$pickup_date,$pickup_time,$pick_loc_address,$pick_loc_city,$pick_loc_zip,$pick_loc_phone,$pick_loc_opening_days,$pick_loc_opening_time,$dropoff_location_name,$dropoff_date,$dropoff_time,$drop_loc_address,$drop_loc_city,$drop_loc_zip,$drop_loc_phone,$drop_loc_opening_days,$drop_loc_opening_time,$insurance_price,$insuraince_type_name,$deposit,$booking_price_ar["special_offer_price"]);

send_mail('Booking InFo-User',$key,$val,$useremail);*/

$coupon_discount = ($booking_price_ar["coupon_applied_price"] > 0) ? $booking_price_ar["coupon_applied_price"] : 0;
$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","(FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE}","{INSURANCE_TYPE}","{DEPOSIT}","{SPECIAL_OFFER_DISCOUNT}","{COUPON_DISCOUNT}","{USER_AGE}");
	$val = array($sitename,$username,$useremail,$userphone,$userlicence,$user_country_name,$flight_no,$user_note,$booking_no,$car_name,$car_group_name,$car_category_name,$sub_total,$dropoff_fee,$extras,$total,$pickup_location_name,$pickup_date,$pickup_time,$pick_loc_address,$pick_loc_city,$pick_loc_zip,$pick_loc_phone,$pick_loc_opening_days,$pick_loc_opening_time,$dropoff_location_name,$dropoff_date,$dropoff_time,$drop_loc_address,$drop_loc_city,$drop_loc_zip,$drop_loc_phone,$drop_loc_opening_days,$drop_loc_opening_time,$insurance_price,$insuraince_type_name,$deposit,$booking_price_ar["special_offer_price"],$coupon_discount,$user_age);
	send_mail('PendingBooking InFo-admin',$key,$val,ADMIN_EMAIL);
}


return $booking_id;
}
public function after_get($data)
{
	if(!empty($data) )
	{

		$data["siteName"] = SITE_NM;

		if($this->after_get_allow == true)
		{
			$this->load->model("locations_model");
			$this->load->model("user_model");
			$this->load->model("booking_extras_model");
			$this->load->model("cars_model");
			$this->load->model("insurance_group_model");
			$this->load->model("category_insurance_price_model");
			$this->load->model("refferal_list_model");	

			if($data["refferal_id"] > 0)
			{
				$refferal_ar = $this->refferal_list_model->set_fields("name")->get($data["refferal_id"]);
				if(!empty($refferal_ar))
				{
					$data["refferal_email"] = $refferal_ar["email"];
					$data["refferal_name"] = $refferal_ar["name"];
				}
			}


			if($data["insurance"] > 0)
			{
				$this->insurance_group_model->after_get_allow = false;
				$insurance_detail = $this->insurance_group_model->set_fields('name')->get($data["insurance"]);
				$this->insurance_group_model->after_get_allow = true;
				$data["insurance_name"] = $insurance_detail["name"];
			}


			if($data["insurance"] > 0 && $data["car_category"] > 0)
			{
				$where_deposit_ar = array("groupId"=>$data["insurance"],"categoryId"=>$data["car_category"]);
				$insurance_price_detail = $this->category_insurance_price_model->get_by($where_deposit_ar);
				$data["insurance_deposit"] = $insurance_price_detail["deposit"];
			}

			if($this->after_get_user_info_allow == true && $data["user_id"] > 0)
			{
				$this->user_model->after_get_country_allow = false;
				$data["user_info"] = $this->user_model->get($data["user_id"]);
				$this->user_model->after_get_country_allow = false;
			}


			/*Location Details*/
			$this->locations_model->after_get_allow = false;
			$data["pickup_location_ar"] = $this->locations_model->set_fields("locations.*,c.city_name")->join("cities as c","c.id = locations.city")->get_by("locations.id",$data["pickup_location"]);
			if($data["pickup_location"] == $data["dropoff_location"])
			{
				$data["dropoff_location_ar"] = $data["pickup_location_ar"];
			}
			else
			{
				$data["dropoff_location_ar"] = $this->locations_model->set_fields("locations.*,c.city_name")->join("cities as c","c.id = locations.city")->get_by("locations.id",$data["dropoff_location"]);				
			}
			$this->locations_model->after_get_allow = true;
			/*Location Details ends*/

			$this->cars_model->after_get_locations_allow = false;
			/*$this->cars_model->after_get_facilities_allow = false;*/
			$this->cars_model->after_get_special_offers_allow = false;
			$data["car_info"] = $this->cars_model->get($data["car_id"]);
			$this->cars_model->after_get_locations_allow = true;
			/*$this->cars_model->after_get_facilities_allow = true;*/
			$this->cars_model->after_get_special_offers_allow = true;

			$facilities_data = $this->booking_extras_model->get_many_by("booking_id",$data["id"]);
			if(!empty($facilities_data))
			{
				$temp = array();
				$temp2 = array();
				foreach ($facilities_data as $key => $value) 
				{
					$temp[$value["facility_id"]] = ($value["multipleValue"] > 0) ? $value["multipleValue"] : $value["id"]; 	
					$temp2[$value["facility_id"]] = ($value["price"] > 0) ? $value["price"] : 0;
				}
				$data["booking_selected_facilities"] = $temp;
				$data["booking_selected_facilities_price"] = $temp2;	
			}

			$data["booking_facilities_data"] =  $facilities_data;

		}
	}
	return $data;
}
public function before_update($data)
{
	if(!empty($data) && $this->before_update_allow == true)
	{
		$this->load->model("booking_extras_model");
		$this->load->model("user_model");

		$update_ar = array(				
			'drivinglicence_no'=> $data["driving_licence"],					
			'country'=> $data["country"],
			'firstname'=> $data["firstname"],
			'lastname'=> $data["lastname"],
			'contactNo'=> $data["contactNo"],
			'address'=> $data["address"]
			);

		$this->user_model->update($data["user_id"],$update_ar,true);	
		unset($data["driving_licence"]);
		unset($data["country"]);
		unset($data["firstname"]);
		unset($data["lastname"]);
		/*unset($data["address"]);*/

		$facilities = (!empty($this->input->post('car_facilities'))) ? $this->input->post('car_facilities') : '';
		if(!empty($facilities))
		{
			$i = 0;
			$existing_items = $this->booking_extras_model->set_fields("facility_id")->get_many_by("booking_id",$data["booking_id"]);
			$existing_items = array_column($existing_items, 'facility_id');
			
			if(!empty($existing_items))
			{
				$item_string = null;
				foreach ($facilities as $key => $value) 
				{
					if($value > 0)
					{
						$item_string .= '"'.$key.'"'.",";		
					}
				}

				$item_string = rtrim($item_string,",");
				$where[] = array("booking_id = '".$data["booking_id"]."'",null,false);
				$where[] = array("facility_id NOT IN (".$item_string.")",null,false);
				$this->booking_extras_model->delete_by($where);
				$facilities = array_diff($facilities,$existing_items);
			}	

			if(!empty($facilities))
			{
				foreach ($facilities as $key => $value) 
				{

					$get_facilities_data = $this->car_facilities_model->get_by("id",$key);
					$booking_total_days = date_difference($data["pickup_date"],$data["dropoff_date"]);


					if($booking_total_days > 0)
					{
						if(isset($get_facilities_data["is_promo_code"]) && $get_facilities_data["is_promo_code"] == "yes")
						{
							if($get_facilities_data["promo_code_type"] == 'a')
							{
								$facility_total =  $booking_total_days*$get_facilities_data["promo_code_price"];
							}
							else
							{
								$facility_total = 0;
							}							
						}
						else
						{
							if($get_facilities_data["type"] == "m")
							{
								$post_value_check_quantity =  ($facilities[$key] > 0 && $key != $facilities[$key]) ? $facilities[$key] : 1;
								if($get_facilities_data["daily_cost"] == 0)
								{
									$facility_total = ($post_value_check_quantity * $get_facilities_data["price"]);
								}	
								else{
									$all_days_facilities_price = $booking_total_days*($post_value_check_quantity * $get_facilities_data["price"]);
									if($all_days_facilities_price > $get_facilities_data['maximum_cost'])
									{
										$facility_total =  $get_facilities_data['maximum_cost'];
									}
									else{
										$facility_total = $all_days_facilities_price;
									}
								}
							}
							else
							{
								if($get_facilities_data["daily_cost"] == 0)
								{
									$facility_total = $get_facilities_data["price"];
								}	
								else{
									$all_days_facilities_price = $booking_total_days*$get_facilities_data["price"];
									if($all_days_facilities_price > $get_facilities_data['maximum_cost']){
										$facility_total =  $get_facilities_data['maximum_cost'];
									}
									else
									{
										$facility_total =  $all_days_facilities_price;
									}
								}	
							}
						}
					}



					if($value > 1)
					{
						$check_exist_ar = array("booking_id"=>$data["booking_id"],'facility_id'=>$key);
						$check_exist_status = $this->booking_extras_model->get_by($check_exist_ar);
						if(!empty($check_exist_status))
						{
							if($key != $value)
							{
								$update_ar_new = array(
									"multipleValue"=>$facilities[$key],
									"price"=>$facility_total
									);
								$this->booking_extras_model->update($check_exist_status["id"],$update_ar_new,true);	
							}
							else{
								/*echo "LMN";*/
							}
						}
						else
						{
							$insert_data = array();	
							if($data["booking_id"] > 0)
							{
								$insert_data["facility_id"] = $key;
								$insert_data["booking_id"] = $data["booking_id"];
								if($key != $value)
								{
									$insert_data["multipleValue"] = $facilities[$key];	
								}
								else{
									$insert_data["multipleValue"] = 1;		
								}							
								$insert_data["price"] = $facility_total;
								$this->booking_extras_model->insert($insert_data,true);
							}
							
						}
					}				
				}
			}			
		}
	}
	unset($data["booking_id"]);
	unset($data["email"]);
	unset($data["country"]);
	/*unset($data["address"]);*/
	return $data;
}
public function after_update($data,$updateId)
{
	$upd_status = ($data[1] != '') ? $data[1] : "";
	if($this->after_update_allow == true)
	{
		$data = $data[0];
		$this->after_get_user_info_allow = true;
		$booking_info = $this->get($updateId);	
		$this->after_get_user_info_allow = false;

		$this->load->model("countries_model");
		$booking_price_ar = (array)json_decode($data["pricingDetails"]);
		$sitename =SITE_NM;
		$username = $booking_info["user_info"]["firstname"]." ".$booking_info["user_info"]["lastname"];
		$useremail = $booking_info["user_info"]["email"];

		$userphone = $booking_info["contactNo"];
		$userlicence = $booking_info["user_info"]["drivinglicence_no"];
		$user_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_info["user_info"]["country"]);;
		$user_country_name = $user_country_name_ar["country_name"];
		$flight_no = $booking_info["flight_no"];		
		$user_note = $booking_info["note"];
		$booking_no = $booking_info["booking_no"];
		$car_name = $booking_info["car_info"]['name'];

		if(!empty($booking_info["booking_selected_facilities_price"]))
		{
			$facility_comma_sep = '';
			foreach ($booking_info["booking_selected_facilities_price"] as $key => $value) 
			{
				$facility_comma_sep .= $key.",";
			}
			$facility_comma_sep = rtrim($facility_comma_sep,",");
		}

		$this->load->model("car_facilities_model");
		if($facility_comma_sep != '')
		{
			$facilities_where[] = array('id IN ('.$facility_comma_sep.')',null,false);
			$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
			foreach ($get_facilities_data as $key => $value) 
			{
				$extras .= $value["facility_name"]." - ".$booking_info["booking_selected_facilities_price"][$value["id"]]." EUR <br />";
			}	
		}
		

		$car_category_name = $booking_info["car_info"]['category'];
		$car_group_name = $booking_info["car_info"]['group'];
		$sub_total = $booking_info["sub_total"];
		$dropoff_fee = $booking_price_ar["dropoff_price"];
		/*$extras = $booking_price_ar[""];*/

		/*booking_selected_facilities_price*/

		/*$extras = "";*/

		$total =  $booking_price_ar["total"];
		$pickup_location_name = $booking_info["pickup_location_ar"]["location_name"];
		$dropoff_location_name = $booking_info["dropoff_location_ar"]["location_name"];

		$car_image_path = base_url()."image/car/".$booking_info["car_info"]["id"]."/264/184/".$booking_info["car_info"]["image"];

		$car_image = "<img style='margin: 0 auto;' src='".$car_image_path."' />";

		$pickup_date = $booking_info["pickup_date"];
		$pickup_time = date("H:i",strtotime($booking_info["pickup_time"]));

		$dropoff_date = $booking_info["dropoff_date"];
		$dropoff_time = date("H:i",strtotime($booking_info["dropoff_time"]));

		$pick_loc_address = $booking_info["pickup_location_ar"]["address"];
		$pick_loc_city = $booking_info["pickup_location_ar"]["city_name"];
		$pick_loc_zip =$booking_info["pickup_location_ar"]["zip_code"];
		$pick_loc_phone = $booking_info["pickup_location_ar"]["phone"];
		/*$pick_loc_opening_days =  $booking_info["pickup_location_ar"]["opening_days"];*/

		$pick_loc_opening_days =  date('H:i', strtotime($booking_info["pickup_location_ar"]["opening_from"]))." - ".date('H:i', strtotime($booking_info["pickup_location_ar"]["opening_to"]));

		$pick_loc_opening_time = $booking_info["pickup_location_ar"]["opening_from"];

		$pickup_location_manager = strip_tags($booking_info["pickup_location_ar"]["location_manager"]);
		$pickup_direction_desk = strip_tags($booking_info["pickup_location_ar"]["direction_desk"]);
		$pickup_location_note = strip_tags($booking_info["pickup_location_ar"]["location_note"]);

		$pickup_working_time = date('H:i', strtotime($booking_info["pickup_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["pickup_location_ar"]["working_to"]));


		$drop_loc_address = $booking_info["dropoff_location_ar"]["address"];;
		$drop_loc_city = $booking_info["dropoff_location_ar"]["city_name"];;
		$drop_loc_zip = $booking_info["dropoff_location_ar"]["zip_code"];
		$drop_loc_phone = $booking_info["dropoff_location_ar"]["phone"];
		/*$drop_loc_opening_days = $booking_info["dropoff_location_ar"]["opening_days"];*/
		$drop_loc_opening_days =  date('H:i', strtotime($booking_info["dropoff_location_ar"]["opening_from"]))." - ".date('H:i', strtotime($booking_info["dropoff_location_ar"]["opening_to"]));
		$drop_loc_opening_time = $booking_info["dropoff_location_ar"]["opening_from"];

		$dropoff_location_manager = strip_tags($booking_info["dropoff_location_ar"]["location_manager"]);
		$dropoff_direction_desk = strip_tags($booking_info["dropoff_location_ar"]["direction_desk"]);
		$dropoff_location_note = strip_tags($booking_info["dropoff_location_ar"]["location_note"]);

		$dropoff_working_time = date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_from"]))." - ".date('H:i', strtotime($booking_info["dropoff_location_ar"]["working_to"]));


		$insurance_price = $booking_price_ar["insurance_price"];
		$insuraince_type_name = $booking_info["insurance_name"];
		$deposit = $booking_info["insurance_deposit"];
		$sitename =SITE_NM;
		
		$car_characteristics = '';
		if(!empty($booking_info["car_info"]["db_sel_characteristics"]))
		{
			$characteristics = array_column($booking_info["car_info"]["db_sel_characteristics"], 'name');
			$characteristics = implode(",",$characteristics);
		}

		$user_age = (date('Y') - date('Y',strtotime($booking_info["date_of_birth"])));
		$user_age = ($user_age > 0) ? $user_age : 	$booking_info["driverage"];


		if($booking_info["booking_status"] == "a")
		{
			$coupon_discount = ($booking_price_ar["coupon_applied_price"] > 0) ? $booking_price_ar["coupon_applied_price"] : 0;

			$key = array("{SITE_NAME}","{USERNAME}","{USER_EMAIL}","{USER_PHONE}","{USER_LICENSE}","{USER_COUNTRY}","(FLIGHT_NUMBER}","{USER_NOTE}","{BOOKING_ID}","{CAR_NAME}","{CAR_GROUP}","{CAR_CATEGORY}","{SUB_TOTAL}","{DROPOFF_PRICE}","{EXTRAS_PRICE}","{TOTAL_PRICE}","{PICKUP_LOCATION}","{PICKUP_DATE}","{PICKUP_TIME}","{PICKUP_LOCA_ADDRESS}","{PICKUP_CITY}","{PICKUP_ZIP}","{PICKUP_LOCA_PHONE}","{PICK_DAYS}","{PICK_TIME}","{DROPOFF_LOCATION}","{DROPOFF_DATE}","{DROPOFF_TIME}","{DROPOFF_LOCA_ADDRESS}","{DROPOFF_CITY}","{DROPOFF_ZIP}","{DROPOFF_LOCA_PHONE}","{DROP_DAYS}","{DROP_TIME}","{INSURANCE_NM}","{INSURANCE}","{DEPOSIT}","{CAR_IMAGE}","{PICKUP_LOCATIONMANAGER}","{PICKUP_DIRECTIONDESK}","{DROPOFF_DIRECTIONDESK}","{DROPOFF_LOCATIONMANAGER}","{PICKUP_LOCATIONNOTE}","{DROPOFF_LOCATIONNOTE}","{FROM_TIME_SURCHRGE}","{TO_TIME_SURCHRGE}","{COUPON_DISCOUNT}","{CAR_CHARACTERISTICS}","{USER_AGE}","{PICKUP_WORKING_TIME}","{DROPOFF_WORKING_TIME}");
				$val = array(
					$sitename,
					$username,
					$useremail,
					$booking_info["contactNo"],
					$userlicence,
					$user_country_name,
					$booking_info["flight_no"],
					$booking_info["note"],
					$booking_info["booking_no"],
					$car_name,
					$car_group_name,
					$car_category_name,
					$sub_total,
					$dropoff_fee,
					$extras,
					$total,
					$pickup_location_name,
					$pickup_date,
					$pickup_time,
					$pick_loc_address,
					$pick_loc_city,
					$pick_loc_zip,
					$pick_loc_phone,
					$pick_loc_opening_days,
					$pick_loc_opening_time,
					$dropoff_location_name,
					$dropoff_date,
					$dropoff_time,
					$drop_loc_address,
					$drop_loc_city,
					$drop_loc_zip,
					$drop_loc_phone,
					$drop_loc_opening_days,
					$drop_loc_opening_time,
					$insuraince_type_name,
					$insurance_price,
					$deposit,
					$car_image,
					$pickup_location_manager,
					$pickup_direction_desk,
					$dropoff_direction_desk,
					$dropoff_location_manager,
					$pickup_location_note,
					$dropoff_location_note,
					$booking_price_ar["from_time_surcharge_price"],
					$booking_price_ar["to_time_surcharge_price"],
					$coupon_discount,
					$characteristics,
					$user_age,  
					$pickup_working_time,
					$dropoff_working_time
					);

send_mail('Booking InFo-User',$key,$val,$useremail);

/*Send reservation details to third party*/
$booking_api_response = $this->send($updateId);
/*Send reservation details to third party ends*/

}


if($data["booking_status"] == 'c')
{
	$this->load->model("user_model");
	$sitename = $booking_info["sitename"];
	$username = $booking_info["user_info"]["firstname"]." ".$booking_info["user_info"]["lastname"];
	$booking_no = $booking_info["booking_no"];
	$car_name = $booking_info["car_info"]['name'];
	$car_category_name = $booking_info["car_info"]['category'];
	$car_group_name = $booking_info["car_info"]['group'];
	$pickup_location_name = $booking_info["pickup_location_ar"]["pickup_location_name"];
	/*$dropoff_location_name = $booking_info["pickup_location_ar"]["dropoff_location_name"];*/
	$dropoff_location_name = $booking_info["dropoff_location_ar"]["location_name"];
	$pickup_date = $booking_info["pickup_date"];
	$pickup_time = $booking_info["pickup_time"];
	$dropoff_date = $booking_info["dropoff_date"];
	$dropoff_time = $booking_info["dropoff_time"];
	if($this->usercancel_by_admin == false)
	{
		$key1 = array('{USERNAME}','{SITE_NAME}','{BOOKING_ID}','{SITE_NM}');
		$val1 = array($username,$siteName,$booking_no,$siteName);	
		$email_template = 'CancelBookingByAdmin-user';
	}
	else
	{
		$key = array('{USERNAME}','{SITE_NAME}','{BOOKING_ID}','{CAR_NAME}','{PICKUP_LOCATION}','{DROPOFF_LOCATION}','{PICKUP_DATE}','{PICKUP_TIME}','{DROPOFF_DATE}','{DROPOFF_TIME}','{MSG_EXT}');
		$val = array($username,$siteName,$booking_no,$car_name,$pickup_location_name,$dropoff_location_name,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,'');

		send_mail('CancelBookingByUser-Admin',$key,$val,ADMIN_EMAIL);	

		$key1 = array('{USERNAME}','{SITE_NAME}','{BOOKING_ID}','{CAR_NAME}','{PICKUP_LOCATION}','{DROPOFF_LOCATION}','{PICKUP_DATE}','{PICKUP_TIME}','{DROPOFF_DATE}','{DROPOFF_TIME}','{MSG_EXT}');
		$val1 = array($username,$siteName,$booking_no,$car_name,$pickup_location_name,$dropoff_location_name,$pickup_date,$pickup_time,$dropoff_date,$dropoff_time,'');			
		$email_template = 'CancelBookingByUser-User';
	}
	send_mail($email_template,$key1,$val1,$useremail);

}
}

return $upd_status;

}	

public function send($id)
{
	$this->load->model("countries_model");
	$this->load->model("states_model");
	$this->load->model("cities_model");

	$this->after_get_user_info_allow = true;
	$booking_data = $this->get($id);
	$this->after_get_user_info_allow = false;

	if(!empty($booking_data))
	{
		$user_address=NULL;	
		if(!empty($booking_data["user_info"]['address']))
		{
			$user_address = $booking_data["user_info"]['address'];
			$user_address .= !empty($booking_data["user_info"]['city'])?', '.$booking_data["user_info"]['city']:'';
			$user_address .= !empty($booking_data["user_info"]['zipcode'])?', '.$booking_data["user_info"]['zipcode']:'';

			$user_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["user_info"]['country']);
			$user_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["user_info"]['state']);;


			$user_address .= !empty($user_state_name_ar["state_name"])?', '.$user_state_name_ar["state_name"]:'';
			$user_address .= !empty($user_country_name_ar["country_name"])?', '.$user_country_name_ar["country_name"]:'';
		}

		$api_key=RESERVATION_KEY;

		$data=array();
		$data['kategorija'] = $booking_data["car_info"]['category'];
		$data['broj_broker']='';
		$data['date1']=date('Y-m-d H:i:s',strtotime($booking_data['pickup_date'].' '.$booking_data['pickup_time']));
		$data['date2']=date('Y-m-d H:i:s',strtotime($booking_data['dropoff_date'].' '.$booking_data['dropoff_time']));
		$data['poslovnica1']="";

		$pickup_location_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["pickup_location_ar"]['country']);

		$pickup_location_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["pickup_location_ar"]['state']);;

		$pickup_location_city_name_ar = $this->cities_model->set_fields("city_name")->get($booking_data["pickup_location_ar"]['city']);;


		$pickup_country = $pickup_location_country_name_ar["country_name"];
		$pickup_state = $pickup_location_state_name_ar["state_name"];
		$pickup_city = $pickup_location_city_name_ar["city_name"];


		/*Dropoff */
		$dropoff_location_country_name_ar = $this->countries_model->set_fields("country_name")->get($booking_data["dropoff_location_ar"]['country']);

		$dropoff_location_state_name_ar = $this->states_model->set_fields("state_name")->get($booking_data["dropoff_location_ar"]['state']);;

		$dropoff_location_city_name_ar = $this->cities_model->set_fields("city_name")->get($booking_data["dropoff_location_ar"]['city']);;


		$dropoff_country = $dropoff_location_country_name_ar["country_name"];
		$dropoff_state = $dropoff_location_state_name_ar["state_name"];
		$dropoff_city = $dropoff_location_city_name_ar["city_name"];
		/*Dropoff */


		$data['mjesto_1'] = $booking_data["pickup_location_ar"]["address"].' '.$pickup_city.', '.$booking_data["pickup_location_ar"]["zip_code"].', '.$pickup_state.', '.$pickup_country;

		$data['poslovnica2']="";

		$data['mjesto_2'] = $booking_data["dropoff_location_ar"]["address"].' '.$dropoff_city.', '.$booking_data["dropoff_location_ar"]["zip_code"].', '.$dropoff_state.', '.$dropoff_country;

		$data['ime'] = $booking_data["user_info"]["firstname"].' '.$booking_data["user_info"]['lastname'];

		$data['adresa'] = $booking_data["user_info"]['address'];

		$data['email'] = $booking_data["user_info"]['email'];

		$data['dob']="";
		$booking_price_ar = (array)json_decode($booking_data["pricingDetails"]);
		$data['vozacka'] = $booking_data["user_info"]['drivinglicence_no'];
		$data['vozacka_datum'] = '';
		$data['vozacka_mjesto'] = "";
		$data['putovnica'] = "";
		$data['telefon'] = $booking_data['contactNo'];
		$data['voucher'] = NULL;
		$data['agencija_id'] = NULL; 
		$data['cjena'] = $booking_price_ar["per_day_price"];
		$data['cjena_total'] = $booking_price_ar["total"];
		$data['placanje'] = 'Paypal';
		$data['napomena'] = 'Payment for car booking number #'.$id;
		$data['trziste'] = 'Internet prodaja';
		$data['chkkey'] = md5($api_key.$data['date1'].$data['date2']);


		$query_string=http_build_query($data);
		$end_point="www.vinis.hr/rcm-demo/api/web-reservations.php?".$query_string;

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$end_point); 
		curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);   
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch);
		$reservation_id=NULL;
		if(!empty($result))
		{
			$xmlObj=simplexml_load_string($result);
			if(!empty($xmlObj->reservationNumber))
			{
				$reservation_id = $xmlObj->reservationNumber;
				$update_ar = array("api_reservation_id"=>$reservation_id); 
				$this->after_update_allow = false;
				$this->update($id,$update_ar,true);
				$this->after_update_allow = true;

				$response["status"] = "success";
				$response["msg"] = lang("MSG_RESERVATION_SENT_SUCCESSFULLY").' Reservation Number: '.$reservation_id;
			}
			else
			{
				$response["status"] = "error";
				$response["msg"] = lang("MSG_API_ERROR");							
			}
		}
	}
	else
	{
		$response["status"] = "error";
		$response["msg"] = lang("INVALID_BOOKING_ID");
	}
	return $response;
}


public function facility_price_render($facility_post,$booking_days,$pickup_date,$dropoff_date = '',$car_id = '')
{
	if(!empty($facility_post))
	{
		$this->load->model("car_facilities_model");
		$this->car_facilities_model->pickup_date = $pickup_date;
		$this->car_facilities_model->dropoff_date = $dropoff_date;
		$this->car_facilities_model->car_id = $car_id;

		$facilities_where[] = array('car_facilities.id IN ('.implode(",",$facility_post).')',null,false);
		$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);
		foreach ($get_facilities_data as $key => $value) 
		{
			if(isset($value["is_promo_code"]) && $value["is_promo_code"] == "yes")
			{
				if($value["promo_code_type"] == 'a')
				{
					$price_dis =  $value["promo_code_price"];
				}
				else
				{
					$price_dis = 0;
				}
			}
			else
			{
				if($value["type"] == "m")
				{
					$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];
					if($value["daily_cost"] == 0)
					{
						$price_dis  = ($post_value_check_quantity * $value["price"]);
					}	
					else{
						$all_days_facilities_price = $booking_days*($post_value_check_quantity * $value["price"]);
						if($all_days_facilities_price > $value['maximum_cost']){
							$price_dis = $value['maximum_cost'];
						}
						else{
							$price_dis = $all_days_facilities_price;
						}
					}
					$temp_text = $post_value_check_quantity;
				}
				else
				{
					if($value["daily_cost"] == 0)
					{
						$price_dis = $value["price"];
					}	
					else{
						$all_days_facilities_price = $booking_days*$value["price"];
						if($all_days_facilities_price > $value['maximum_cost']){
							$price_dis = $value['maximum_cost'];
						}
						else{
							$price_dis =  $all_days_facilities_price;
						}
					}	
				}
			}
			$fac_name = $value["facility_name"];
			if(isset($temp_text))
			{
				$temp = ($temp_text > 0) ? ' x '.$temp_text : ''; 
			}

			$extras .= '<label>'.$value['facility_name'].$temp." </label> <label class='faci_price'> = ".currencyConvert($price_dis,$sessionData['currency_code'],$sessionData['default_currency'],0).' EUR</label> <br />';
		}
	}
	return $extras;
}

}
