<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Extended Form Validation to add custom error messages for any fields.
 *
 * For Codeigniter 3.0-dev. (Might work on lower versions, not tested)
 *
 * Usage Example
 * ------
 * $this->form_validation->set_rules('name','Name','required|alpha',array('required' => 'Please enter the field %s .'));
 *
 * @category   MY_Form_validation
 * @package    Codeigniter
 * @version    1.0
 * @author     A. H. Abid <a_h_abid@hotmail.com>
 * @link       https://gist.github.com/abdmaster/7287962#file-my_form_validation_custom_rules-php
 */
class MY_Form_validation extends CI_Form_validation 
{ 

 public function __construct($rules = array())
 { 
  parent::__construct($rules);
  /*$this->CI = & get_instance();*/
}

  /**
   * Override Set Rules
   *
   * Added option to set custom message per fields
   *
   * @param  mixed  $field
   * @param  string  $label
   * @param  mixed  $rules
   * @param  array  $error_msg
   * @return  CI_Form_validation
   * @author A. H. Abid <a_h_abid@hotmail.com>
   */
  public function set_rules($field, $label = '', $rules = '', $error_msg = array())
  {
    // No reason to set rules if we have no POST data
    // or a validation array has not been specified
    /*printr($this->CI);*/
    if ($this->CI->input->method() !== 'post' && empty($this->validation_data))
    {
      return $this;
    }
    // If an array was passed via the first parameter instead of individual string
    // values we cycle through it and recursively call this function.
    if (is_array($field))
    {
      foreach ($field as $row)
      {
        // Houston, we have a problem...
        if ( ! isset($row['field'], $row['rules']))
        {
          continue;
        }
        // If the field label wasn't passed we use the field name
        $label = isset($row['label']) ? $row['label'] : $row['field'];
        // Add the custom error message array
        $error_msg = (isset($row['error_msg']) && is_array($row['error_msg']) ) ? $row['error_msg'] : array(); 
        // Here we go!
        $this->set_rules($row['field'], $label, $row['rules'], $error_msg);
      }
      return $this;
    }
    // Convert an array of rules to a string
    if (is_array($rules))
    {
      $rules = implode('|', $rules);
    }
    // No fields? Nothing to do...
    if ( ! is_string($field) OR ! is_string($rules) OR $field === '')
    {
      return $this;
    }
    // If the field label wasn't passed we use the field name
    $label = ($label === '') ? $field : $label;
    // Is the field name an array? If it is an array, we break it apart
    // into its components so that we can fetch the corresponding POST data later
    $indexes = array();
    if (preg_match_all('/\[(.*?)\]/', $field, $matches))
    {
      sscanf($field, '%[^[][', $indexes[0]);
      for ($i = 0, $c = count($matches[0]); $i < $c; $i++)
      {
        if ($matches[1][$i] !== '')
        {
          $indexes[] = $matches[1][$i];
        }
      }
      $is_array = TRUE;
    }
    else
    {
      $is_array  = FALSE;
    }
    // Build our master array
    $this->_field_data[$field] = array(
      'field'    => $field,
      'label'    => $label,
      'rules'    => $rules,
      'error_msg' => $error_msg,
      'is_array'  => $is_array,
      'keys'    => $indexes,
      'postdata'  => NULL,
      'error'    => ''
      );
    return $this;
  }
  /**
   * Override Executes the Validation routines
   *
   * Added Option to check for custom error messages by fields
   *
   * @param  array
   * @param  array
   * @param  mixed
   * @param  int
   * @return  mixed
   * @author A. H. Abid <a_h_abid@hotmail.com>
   */
  protected function _execute($row, $rules, $postdata = NULL, $cycles = 0)
  {
    // If the $_POST data is an array we will run a recursive call
    if (is_array($postdata))
    {
      foreach ($postdata as $key => $val)
      {
        $this->_execute($row, $rules, $val, $key);
      }
      return;
    }
    // If the field is blank, but NOT required, no further tests are necessary
    $callback = FALSE;
    if ( ! in_array('required', $rules) && ($postdata === NULL OR $postdata === ''))
    {

      // Before we bail out, does the rule contain a callback?
      if (preg_match('/(callback_\w+(\[.*?\])?)/', implode(' ', $rules), $match))
      {
        $callback = TRUE;
        $rules = array(1 => $match[1]);
      }
      else
      {
        return;
      }
    }
    // Isset Test. Typically this rule will only apply to checkboxes.
    if (($postdata === NULL OR $postdata === '') && $callback === FALSE)
    {

      if (in_array('isset', $rules, TRUE) OR in_array('required', $rules))
      {

        // Set the message type
        $type = in_array('required', $rules) ? 'required' : 'isset';
        // Check if a custom message defined, else use default one
        if (isset($this->_field_data[$row['field']]['error_msg'][$type]))
        {
          $line = $this->_field_data[$row['field']]['error_msg'][$type];
        }
        elseif (isset($this->_error_messages[$type]))
        {
          $line = $this->_error_messages[$type];
        }
        elseif (FALSE === ($line = $this->CI->lang->line('form_validation_'.$type))
          // DEPRECATED support for non-prefixed keys
          && FALSE === ($line = $this->CI->lang->line($type, FALSE)))
        {
          $line = 'The field was not set';
        }
        /*  print $line;*/
        // Build the error message
        $message = $this->_build_error_msg($line, $this->_translate_fieldname($row['label']));
        // Save the error message
        $this->_field_data[$row['field']]['error'] = $message;
        if ( ! isset($this->_error_array[$row['field']]))
        {
          $this->_error_array[$row['field']] = $message;
        }
      }

      return;
    }
    // --------------------------------------------------------------------
    // Cycle through each rule and run it
    foreach ($rules as $rule)
    {
      $_in_array = FALSE;
      // We set the $postdata variable with the current data in our master array so that
      // each cycle of the loop is dealing with the processed data from the last cycle
      if ($row['is_array'] === TRUE && is_array($this->_field_data[$row['field']]['postdata']))
      {
        // We shouldn't need this safety, but just in case there isn't an array index
        // associated with this cycle we'll bail out
        if ( ! isset($this->_field_data[$row['field']]['postdata'][$cycles]))
        {
          continue;
        }
        $postdata = $this->_field_data[$row['field']]['postdata'][$cycles];
        $_in_array = TRUE;
      }
      else
      {
        // If we get an array field, but it's not expected - then it is most likely
        // somebody messing with the form on the client side, so we'll just consider
        // it an empty field
        $postdata = is_array($this->_field_data[$row['field']]['postdata'])
        ? NULL
        : $this->_field_data[$row['field']]['postdata'];
      }
      // Is the rule a callback?
      $callback = FALSE;
      if (strpos($rule, 'callback_') === 0)
      {
        $rule = substr($rule, 9);
        $callback = TRUE;
      }
      // Strip the parameter (if exists) from the rule
      // Rules can contain a parameter: max_length[5]
      $param = FALSE;
      if (preg_match('/(.*?)\[(.*)\]/', $rule, $match))
      {
        $rule = $match[1];
        $param = $match[2];
      }
      // Call the function that corresponds to the rule
      if ($callback === TRUE)
      {

       /* echo $rule;
        printr($this->CI);
        var_dump(method_exists($this->CI, $rule));
        exit();*/

        if ( ! method_exists($this->CI, $rule))
        {
          log_message('debug', 'Unable to find callback validation rule: '.$rule);
          $result = FALSE;
        }
        else
        {
          // Run the function and grab the result
          $result = $this->CI->$rule($postdata, $param);
        }
        // Re-assign the result to the master data array
        if ($_in_array === TRUE)
        {
          $this->_field_data[$row['field']]['postdata'][$cycles] = is_bool($result) ? $postdata : $result;
        }
        else
        {
          $this->_field_data[$row['field']]['postdata'] = is_bool($result) ? $postdata : $result;
        }
        // If the field isn't required and we just processed a callback we'll move on...
        if ( ! in_array('required', $rules, TRUE) && $result !== FALSE)
        {
          continue;
        }
      }
      elseif ( ! method_exists($this, $rule))
      {
        // If our own wrapper function doesn't exist we see if a native PHP function does.
        // Users can use any native PHP function call that has one param.
        if (function_exists($rule))
        {
          $result = ($param !== FALSE) ? $rule($postdata, $param) : $rule($postdata);
          if ($_in_array === TRUE)
          {
            $this->_field_data[$row['field']]['postdata'][$cycles] = is_bool($result) ? $postdata : $result;
          }
          else
          {
            $this->_field_data[$row['field']]['postdata'] = is_bool($result) ? $postdata : $result;
          }
        }
        else
        {
          log_message('debug', 'Unable to find validation rule: '.$rule);
          $result = FALSE;
        }
      }
      else
      {
        $result = $this->$rule($postdata, $param);
        if ($_in_array === TRUE)
        {
          $this->_field_data[$row['field']]['postdata'][$cycles] = is_bool($result) ? $postdata : $result;
        }
        else
        {
          $this->_field_data[$row['field']]['postdata'] = is_bool($result) ? $postdata : $result;
        }
      }

      // Did the rule test negatively? If so, grab the error.
      if ($result === FALSE)
      {


        // Check if a custom message defined, else use default one
        if(isset($this->_field_data[$row['field']]['error_msg'][$rule]))
        {
          $line = $this->_field_data[$row['field']]['error_msg'][$rule];
        }
        elseif ( ! isset($this->_error_messages[$rule]))
        {
          if (FALSE === ($line = $this->CI->lang->line('form_validation_'.$rule))
            // DEPRECATED support for non-prefixed keys
            && FALSE === ($line = $this->CI->lang->line($rule, FALSE)))
          {
            $line = 'Unable to access an error message corresponding to your field name.';
          }
        }
        else
        {
          $line = $this->_error_messages[$rule];
        }
        // Is the parameter we are inserting into the error message the name
        // of another field? If so we need to grab its "field label"
        if (isset($this->_field_data[$param], $this->_field_data[$param]['label']))
        {
          $param = $this->_translate_fieldname($this->_field_data[$param]['label']);
        }

        // Build the error message
        $message = $this->_build_error_msg($line, $this->_translate_fieldname($row['label']), $param);
        // Save the error message
        $this->_field_data[$row['field']]['error'] = $message;
        if ( ! isset($this->_error_array[$row['field']]))
        {
          $this->_error_array[$row['field']] = $message;
        }
        
        return;
      }
    }
  }
  /**
   * Build an error message using the field and param.
   *
   * @param string  The error message line
   * @param string  A field's human name
   * @param mixed A rule's optional parameter
   * @return  string
   */
  protected function _build_error_msg($line, $field = '', $param = '')
  {
    // Check for %s in the string for legacy support.
    $line=$this->_translate_fieldname($line);
    if (strpos($line, '%s') !== FALSE)
    {
      return sprintf($line, $field, $param);
    }
    return str_replace(array('{field}', '{param}'), array($field, $param), $line);
  }
}
/* End of file MY_Form_validation.php */
/* Location: ./application/library/MY_Form_validation.php */   