<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once("common_methods.php");
class Search extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
		$this->load->library("currency_convertor");
		$this->load->model("currencies_model");
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("search_model");
		$this->load->model("cars_model");
		$this->load->model("car_groups_model");
		$this->load->model("car_facilities_detail_model");
		$this->load->model("car_pickup_location_detail_model");
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("characteristics_groups_model");
		$this->load->model("characteristics_model");
		$this->load->model("high_period_notification_model");
		$this->load->helper('text');
	}

	public function sendbookingdetailsview($carId = 0)
	{
		if(!$this->input->post())
		{
			$this->load->model("locations_model");
			if($this->isAjax)
			{
				$this->layout=false;
			}
			$this->page_title = lang(BOOKING_INFORMATION_TITLE);
			
			$this->search_model->pickup_location = $this->data["pickup_location"] = $this->session->userdata("pickup_location");
			$this->search_model->dropoff_location = $this->data["dropoff_location"] = $this->session->userdata("dropoff_location");
			$this->search_model->pickup_date = $this->data["pickup_date"] =  $this->session->userdata("pickup_date");
			$this->search_model->dropoff_date =  $this->data["dropoff_date"] = $this->session->userdata("dropoff_date");
			$this->search_model->pickup_time =  $this->data["pickup_time"] = $this->session->userdata("pickup_time");
			$this->search_model->dropoff_time =  $this->data["dropoff_time"] = $this->session->userdata("dropoff_time");
			$this->search_model->specific_car = $carId;
			$this->search_model->orderbycolumn = "cars.id";
			$this->search_model->orderbytype = "DESC";
			$this->data["search_results"] = $this->search_model->search_results();
			$this->data["row"] = $this->data["search_results"][0];


			$this->locations_model->after_get_allow = false;
			$selected_pickup_location_array = $this->locations_model->set_fields("id,location_name")->get($this->data["pickup_location"]);
			$selected_dropoff_location_array = $this->locations_model->set_fields("id,location_name")->get($this->data["dropoff_location"]);
			$this->locations_model->after_get_allow = true;				

			if(!empty($selected_pickup_location_array))
			{
				$this->data["selected_pickup_location"] = $selected_pickup_location_array["location_name"];
			}

			if(!empty($selected_dropoff_location_array))
			{
				$this->data["selected_dropoff_location"] = $selected_dropoff_location_array["location_name"];
			}

			
			$this->pricing_model->car_category = $this->data["row"]["categoryId"];
			$this->pricing_model->pickup_location = $this->data["pickup_location"];
			$this->pricing_model->dropoff_location = $this->data["dropoff_location"]; 
			$this->pricing_model->pickup_date = $this->data["pickup_date"];
			$this->pricing_model->pickup_time = $this->data["pickup_time"];
			$this->pricing_model->dropoff_date =  $this->data["dropoff_date"];
			$this->pricing_model->dropoff_time = $this->data["dropoff_time"];
			$this->pricing_model->car_id = $carId;
			$price_ar = $this->pricing_model->get_car_price();
			if(!empty($price_ar))
			{
				$this->data["per_day_price"] = $price_ar["per_day_price"];
				$this->data["total"] = $price_ar["total"];
				$this->data["original_price"] = $price_ar["original_price"];
				$this->data["special_offer_price"] = $price_ar["special_offer_price"];
			}

			$pickup_time_ar = explode(":",$this->data["pickup_time"]);
			$start_date = (count($pickup_time_ar) == 3) ? $this->data["pickup_date"]." ".$this->data["pickup_time"] : $this->data["pickup_date"]." ".$this->data["pickup_time"].":00";

			$dropoff_time_ar = explode(":",$this->data["dropoff_time"]);	
			$end_date = (count($dropoff_time_ar) == 3) ? $this->data["dropoff_date"]." ".$this->data["dropoff_time"] : $this->data["dropoff_date"]." ".$this->data["dropoff_time"].":00";

			$this->data["total_booking_days"] =  date_difference($start_date,$end_date);


			/*$this->data["detail_html"] = $this->load->view("search/search_row",$this->data);*/
			$this->modal_large_class = "modal-lg";			
			$this->sections['section_form'] = "search/sendmaildetails";
			$this->sections['section_popup'] = 'sections/popup/modal';
			$this->view="general/popup_page";
		}
	}


	public function sendbookinginfo()
	{
		$email_id = $this->input->post("email_id");
		if($this->input->post() && $this->isAjax && $email_id != "")
		{
			$this->load->model("pricing_model");
			$this->load->model("cars_model");
			$this->load->model("locations_model");
			$this->load->model("quotes_model");
			$this->load->model("site_settings_model");


			$logo_data = $this->site_settings_model->set_fields("value")->get_by('constant','SITE_LOGO');
			if(!empty($logo_data))
			{
				/*$logo_img = base_url()."image/logo/140/57/".$logo_data["value"];*/
				$logo_img = base_url()."assets/nova/img/site_setting/".$logo_data["value"];
			}
			
			$this->layout=false;
			$this->view=false;
			$this->json=true;
			$this->data["status"] = "error";
			$this->data["msg"] = lang("CAR_DETAIL_FROM_SEARCH_ERROR");
			$car_id = $this->input->post("car_id");
			$pickup_location = $this->input->post("pickup_location");
			$pickup_date = $this->input->post("pickup_date");
			$pickup_time = $this->input->post("pickup_time");
			$dropoff_location = $this->input->post("dropoff_location");
			$dropoff_date = $this->input->post("dropoff_date");
			$dropoff_time = $this->input->post("dropoff_time");
			$pickup_location_name_ar = $this->locations_model->set_fields("location_name")->get($pickup_location);
			$pickup_location_name = $pickup_location_name_ar["location_name"];
			$dropoff_location_name_ar = $this->locations_model->set_fields("location_name")->get($dropoff_location);
			$dropoff_location_name = $dropoff_location_name_ar["location_name"];
			
			$this->cars_model->after_get_locations_allow = false;
			
			$this->cars_model->facility_pickup_date = $pickup_date;
			$this->cars_model->facility_dropoff_date = $dropoff_date;

			$car_detail = $this->cars_model->set_fields("*")->get($car_id);
			$this->pricing_model->car_category = $car_detail["categoryId"];
			$this->pricing_model->pickup_location = $pickup_location;
			$this->pricing_model->dropoff_location = $dropoff_location;
			$this->pricing_model->pickup_date = $pickup_date;
			$this->pricing_model->pickup_time = $pickup_time;
			$this->pricing_model->dropoff_date = $dropoff_date;
			$this->pricing_model->dropoff_time = $dropoff_time;
			$this->pricing_model->car_id = $car_id;
			$price_ar = $this->pricing_model->get_car_price();
			if(!empty($price_ar))
			{
				$per_day_price = $price_ar["per_day_price"];
				$total = $price_ar["total"];
				$original_price = $price_ar["original_price"];
				$special_offer_price = $price_ar["special_offer_price"];
			}
			$today = date('Y-m-d');
			$insData = array(
				'user_email'=>$email_id,
				'pick_up_location_id'=>$pickup_location,
				'dropoff_location_id'=>$dropoff_location,
				'car_id'=>$car_id,
				'total_price'=>$total,
				'per_day_price'=>$per_day_price,
				'pickup_date'=>date('Y-m-d',strtotime($pickup_date)),
				'dropoff_date'=>date('Y-m-d',strtotime($dropoff_date)),
				'date'=>$today
				);
			$this->quotes_model->insert($insData,true);
			$book_link = base_url().'car/'.$car_id.'?pickup_location='.$pickup_location.'&pickup_time='.$pickup_time.'&pickup_date='.$pickup_date.'&dropoff_location='.$dropoff_location.'&dropoff_time='.$dropoff_time.'&dropoff_date='.$dropoff_date;			
			$admin = 'ADMIN';
			/*$key = array('{CAR_NAME}','{CAR_GROUP}','{EXTRA_KM}','{TOTAL_PRICE}','{PER_DAY_PRICE}','{PICKUP_LOCATION}','{PICKUP_DATE}','{PICKUP_TIME}','{DROPOFF_LOCATION}','{DROPOFF_DATE}','{DROPOFF_TIME}','{QUOTE_DATE}','{EMAIL_GUEST}','{BOOK_THIS_QUOTE}','{ADMIN}','{MSG_EXT}');
			$val = array($car_detail['name'],$car_detail['group'],$extra_km,$total,$per_day_price,$pickup_location_name,$pickup_date,$pickup_time,$dropoff_location_name,$dropoff_date,$dropoff_time,$today,$email_id,$book_link,$admin,'');*/
			
			$car_image = base_url()."image/car/".$car_detail["id"]."/264/184/".$car_detail["image"];

			if(!empty($car_detail["db_sel_characteristics"]))
			{
				$car_characteristics = '<ul class="list" style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 0;padding: 0;list-style: none;font-weight: normal;">';
				foreach ($car_detail["db_sel_characteristics"] as $key => $value)
				{
					$car_characteristics .= '<li style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 5px 0;padding: 0;list-style: none;font-weight: normal;float: left;width: 47%;"><img src="'.$value["search_characteristic_image"].'" style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;border: none;vertical-align: middle;margin-right: 10px;"> '.$value["name"].'</li>';
				}
				$car_characteristics .= '</ul>';
			}

			if(!empty($car_detail["db_sel_facilities"]) && $car_detail["free_facility_avail"] == "yes")
			{
				$included_in_price = '<div class="commonbox included" style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 0;padding: 15px;list-style: none;font-weight: normal;float: left;width: 100%;background-color: #ffffff;margin-top: 10px;"><h3 style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 0;padding: 0;list-style: none;font-weight: 700;font-size: 18px;color: #78b600;margin-bottom: 10px;">Included in price</h3><ul style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 0;padding: 0;list-style: none;font-weight: normal;">';
				foreach ($car_detail["db_sel_facilities"] as $key => $facility) 
				{
					if($facility["is_promo_code"] == "yes" && $facility["promo_code_type"] == 'f')
					{
						$included_in_price .= '<li style="box-sizing: border-box;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;margin: 0;padding: 2px 0 2px 20px;list-style: none;font-weight: normal;background: url('.asset_url().'images/pointicon.png) no-repeat 0 6px;float: left;width: 100%;">'.$facility["facility_name"].'</li>';
					}
				}
				$included_in_price .= '</ul></div>';
			}

			$key = array('{SITE_LOGO}','{SITE_NAME}','{PICKUP_DATE}','{PICKUP_MONTH}','{PICKUP_LOCATION}','{PICKUP_TIME}','{DROPOFF_DATE}','{DROPOFF_MONTH}','{DROPOFF_LOCATION}','{DROPOFF_TIME}','{CAR_NAME}','{CAR_GROUP}','{CAR_IMAGE}','{CAR_CHARACTERISTICS}','{INCLUDED_IN_PRICE}','{TOTAL_PRICE}','{BOOK_THIS_QUOTE}');
			
			$val = array($logo_img,site_name(),date("d",strtotime($pickup_date)),date("M",strtotime($pickup_date)),$pickup_location_name,$pickup_time,date("d",strtotime($dropoff_date)),date("M",strtotime($dropoff_date)),$dropoff_location_name,$dropoff_time,$car_detail['name'],$car_detail['group'],$car_image,$car_characteristics,$included_in_price,$total,$book_link);

			if(send_mail('Car Detail From Search',$key,$val,$email_id))
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang("CAR_DETAIL_FROM_SEARCH_SUCCESS");
			}			
		}
		else{
			
		}
	}

	public function index()
	{
		/*$this->load->css('plugins/jquery-ui/jquery-ui-slider.css');*/
		$this->load->js('js/owl.carousel.js');
		$this->load->start_inline_scripting();
		echo "Appfd.initSearchCommon();";
		echo "Appfd.initCarSearchFormCommon();";
		$this->load->end_inline_scripting(false,false);
		$this->output->set_title(lang("Search results "));
		$this->search_model->page = ($this->input->get("page") > 0) ? $this->input->get("page") : 0;
		$this->body_class = 'search_page';
		if($this->search_model->page  > 0)
		{
			$this->search_model->start_limit = (($this->search_model->page - 1)*$this->search_model->rec_to_dis) ;
			$this->search_model->limit = $this->search_model->start_limit.",".$this->search_model->rec_to_dis;			
		}	
		else{
			$this->search_model->limit = $this->search_model->rec_to_dis;
		}			
		
		$pickup_new_date = $this->input->get("pickup_date");
		$dropoff_new_date = $this->input->get("dropoff_date");

		if($this->input->get("pickup_date") != '' && $this->input->get("pickup_date") == date("Y-m-d")) 
		{
			$date_redirect = true;
			$pickup_new_date = date('Y-m-d',strtotime("+1 day"));			
		}

		if($this->input->get("dropoff_date") != '' && $this->input->get("dropoff_date") == date("Y-m-d")) 
		{
			$date_redirect = true;
			$dropoff_new_date = date('Y-m-d',strtotime("+1 day"));			
		}	

		if($date_redirect == true)
		{
			$redirect_url = base_url()."search?pickup_location=".$this->input->get("pickup_location")."&dropoff_location=".$this->input->get("pickup_location")."&pickup_date=".$pickup_new_date."&pickup_time=".$this->input->get("pickup_time")."&dropoff_date=".$dropoff_new_date."&dropoff_time=".$this->input->get("dropoff_time");
			$this->session->set_flashdata("error",lang("CAN_NOT_BOOK_ON_TODAY"));
			redirect($redirect_url);
			exit();
		}

		if($this->session->userdata("pickup_location") != $this->input->get("pickup_location"))
		{
			$this->session->set_userdata("pickup_location",$this->input->get("pickup_location"));
		}

		if($this->session->userdata("dropoff_location") != $this->input->get("dropoff_location"))
		{
			$this->session->set_userdata("dropoff_location",$this->input->get("dropoff_location"));
		}

		if($this->session->userdata("pickup_date") != $this->input->get("pickup_date"))
		{
			$this->session->set_userdata("pickup_date",$this->input->get("pickup_date"));
		}

		if($this->session->userdata("dropoff_date") != $this->input->get("dropoff_date"))
		{
			$this->session->set_userdata("dropoff_date",$this->input->get("dropoff_date"));
		}


		if($this->session->userdata("pickup_time") != $this->input->get("pickup_time"))
		{
			$this->session->set_userdata("pickup_time",$this->input->get("pickup_time"));
		}


		if($this->session->userdata("dropoff_time") != $this->input->get("dropoff_time"))
		{
			$this->session->set_userdata("dropoff_time",$this->input->get("dropoff_time"));
		}


		$this->check_coupon_exist();

		$this->search_model->pickup_location = $this->data["pickup_location"]  = ($this->session->userdata("pickup_location") > 0) ? $this->session->userdata("pickup_location") : (($this->input->get("pickup_location") > 0) ?  $this->input->get("pickup_location") : 0);

		$this->search_model->dropoff_location = $this->data["dropoff_location"] = ($this->session->userdata("dropoff_location") > 0) ? $this->session->userdata("dropoff_location") : (($this->input->get("dropoff_location")) ?  $this->input->get("dropoff_location") : 0);



		$this->search_model->pickup_date = $this->data["pickup_date"] = ($this->session->userdata("pickup_date") != '') ? $this->session->userdata("pickup_date") : (($this->input->get("pickup_date")) ?  $this->input->get("pickup_date") :'');


		$this->search_model->dropoff_date = $this->data["dropoff_date"] = ($this->session->userdata("dropoff_date") != "") ? $this->session->userdata("dropoff_date") : (($this->input->get("dropoff_date")) ?  $this->input->get("dropoff_date") :'');



		$this->search_model->pickup_time =  $this->data["pickup_time"] = ($this->session->userdata("pickup_time") != '') ? $this->session->userdata("pickup_time") : (($this->input->get("pickup_time")) ?  $this->input->get("pickup_time") :'');

		$this->search_model->dropoff_time =  $this->data["dropoff_time"] = ($this->session->userdata("dropoff_time") != '') ? $this->session->userdata("dropoff_time") : (($this->input->get("dropoff_time")) ?  $this->input->get("dropoff_time") :'');


		
		
		$this->search_model->group = $this->data["group"] = ($this->input->get("group") != "") ? $this->input->get("group") : "";
		$this->search_model->category = $this->data["category"] = ($this->input->get("category") > 0) ? $this->input->get("category") : 0;

		$this->search_model->min_price = $this->data["min_price"] = ($this->input->get("min_price") > 0) ? $this->input->get("min_price") : 0;
		
		$this->search_model->max_price = $this->data["max_price"] = ($this->input->get("max_price") > 0) ? $this->input->get("max_price") : 0;
		$this->search_model->facilities = ($this->input->get("facilities") != "") ? $this->input->get("facilities") : "";
		$this->search_model->characteristics = ($this->input->get("characteristics") != "") ? $this->input->get("characteristics") : "";
		


		$where_ar = array(
			"status"=>"y",
			"search_default"=>"y"
			);
		$this->data["search_header_criteria"] = $this->characteristics_groups_model->get_by($where_ar);

		if(!empty($this->data["search_header_criteria"]))
		{
			foreach ($this->data["search_header_criteria"]["characteristics"] as $key => $value) 
			{
				$characteristics_ids[] = $value["id"];
			}
		}


		/*$sorting = ($this->input->get("sorting") != "") ? $this->input->get("sorting") : 0;*/
		$sorting = ($this->input->get("sorting") != "") ? $this->input->get("sorting") : 1;

		$sorting_ar = explode("_",$sorting);
		if(count($sorting_ar) > 1 && !empty($sorting_ar))
		{
			$is_characteristics_sorting = true;
			$sorting_key = $sorting_ar[1];		
		}	

		$code = ($this->input->get("code") != "") ? $this->input->get("code") : '';
		
		$driverage = ($this->input->get("driverage") != "" && $this->input->get("driverage") == "1") ? $this->input->get("driverage") : 0;
		$driveragenumber = ($this->input->get("driveragenumber") != "" && $this->input->get("driveragenumber")) ? $this->input->get("driveragenumber") : DRIVER_MINIMUM_AGE." - ".DRIVER_MAXIMUM_AGE;

		$this->session->set_userdata("pickup_location",$this->data["pickup_location"]);
		$this->session->set_userdata("dropoff_location",$this->data["dropoff_location"]);
		$this->session->set_userdata("pickup_date",$this->data["pickup_date"]);
		$this->session->set_userdata("dropoff_date",$this->data["dropoff_date"]);
		$this->session->set_userdata("pickup_time",$this->data["pickup_time"]);
		$this->session->set_userdata("dropoff_time",$this->data["dropoff_time"]);
		$this->session->set_userdata("driveragenumber",$driveragenumber);

		if($code != '')
		{
			$this->session->set_userdata("refferal_code",$code);
		}
		/*else{
			$this->session->unset_userdata("refferal_code");
		}*/

		$this->search_model->booking_user_age = $this->data["booking_user_age"] = (int)$driverage;
		$this->search_model->booking_user_driveragenumber = $this->data["booking_user_driveragenumber"] = (int)$driveragenumber;

		if(isset($is_characteristics_sorting) && $is_characteristics_sorting === true)
		{
			if(($key = array_search($sorting_key, $characteristics_ids)) !== false) {
				unset($characteristics_ids[$key]);
			}
			$this->search_model->transmission_sort_id = $sorting_key;
			$this->search_model->orderbycolumn="characteristics_order_id";
			$characteristics_ids = array_values($characteristics_ids);
			if($sorting_key < $characteristics_ids[0])
			{
				$this->search_model->orderbytype = 'asc';
			}
			else
			{
				$this->search_model->orderbytype = 'desc';	
			}
		}
		else
		{
			if((int)$sorting == 0)
			{
				$this->search_model->orderbycolumn = "cars.id";
				$this->search_model->orderbytype = "DESC";
			}
			else if((int)$sorting == 1)
			{
				$order=SORT_ASC;
				$column = "total";			
			}
			else if((int)$sorting == 2)
			{
				$order=SORT_DESC;
				$column = "total";			
			}		
			else if((int)$sorting == 3)
			{
				$this->search_model->orderbycolumn = "upper(cars.name)";
				$this->search_model->orderbytype = "ASC";
			}
			else if((int)$sorting == 4)
			{
				$this->search_model->orderbycolumn = "upper(cars.name)";
				$this->search_model->orderbytype = "DESC";
			}
		}

		$this->search_model->counter = true;
		$this->search_model->limit_allow = false;
		$this->data["search_results_total_counter"] = $this->search_model->search_results();
		$this->search_model->counter = false;
		$this->search_model->limit_allow = true;
		
		if($this->data["search_results_total_counter"] > $this->search_model->rec_to_dis)
		{
			$this->data["loadenabled"] = true;
		}
		if(isset($this->data["search_results_total_counter"]) && $this->data["search_results_total_counter"] > 0){		
			$this->search_model->last_page = ceil($this->data["search_results_total_counter"]/$this->search_model->rec_to_dis);
		}

		if((int)$sorting == 1 || (int)$sorting == 2)
		{
			$this->search_model->limit_allow = false;
		}
		$this->data["search_results"] = $this->search_model->search_results();

		/*echo count($this->data["search_results"]);
		printr($this->data["search_results"]);
		exit();*/

		if((int)$sorting == 1 || (int)$sorting == 2)
		{
			$this->data["search_results"] = array_sort_by_column($this->data["search_results"],$column,$order);
			$this->data["search_results"] = array_slice($this->data["search_results"],$this->search_model->start_limit,$this->search_model->rec_to_dis);
		}
		/*$temp = $this->search_model->start_limit + $this->search_model->rec_to_dis;*/
		if(!empty($this->data["search_results"]))
		{
			$this->data["available_vehicles_slider"] = array();
			$this->data["car_group_results"] = $this->car_groups_model->get_many_by('status','y');
			foreach ($this->data["car_group_results"] as $key => $value) {
				$temp = array('image_path'=>$value["search_avail_image_path"],'id'=>$value["id"],'name'=>character_limiter($value["group_name"], 10));
				$this->data["available_vehicles_slider"][] = $temp;
			}			
		}


		/*printr($this->data["search_results"]);*/
		$this->data["slider_results_render"] = $this->load->view("search/slider_row",$this->data,true);;

		/*Check for high period notification*/
		
		$search_where_new[] = array("(('".$this->data["pickup_date"]."' BETWEEN start_date AND end_date)) AND hpn_ld.locationId = '".$this->data["pickup_location"]."' AND high_period_notification.status='y'",null,false);

		/*$notification_ar = $this->search_model->set_fields("hpn.message as high_notification_msg,hpn.type as high_notification_type")
		->join('car_pickup_location_detail as cpld','cars.id = cpld.carId','left')
		->join('high_period_notification as hpn','hpn.locationId = cpld.locationId','left')
		->join('high_period_notification_location_details as hpn_ld','hpn_ld.HighPeriodId = hpn.id','left')
		->get_by($search_where_new);*/

		$notification_ar = $this->high_period_notification_model->set_fields("high_period_notification.message as high_notification_msg,high_period_notification.type as high_notification_type")
		->join('high_period_notification_location_details as hpn_ld','hpn_ld.HighPeriodId = high_period_notification.id','left')
		->get_by($search_where_new);


		/*echo $this->db->last_query();
		echo "<pre />";
		printr($notification_ar);*/

		$this->locations_model->after_get_allow = false;
		$selected_pickup_location_array = $this->locations_model->set_fields("id,location_name")->get($this->data["pickup_location"]);
		$selected_dropoff_location_array = $this->locations_model->set_fields("id,location_name")->get($this->data["dropoff_location"]);
		$this->locations_model->after_get_allow = true;			

		if(!empty($selected_pickup_location_array))
		{
			$this->data["selected_pickup_location"] = $selected_pickup_location_array["location_name"];
		}

		if(!empty($selected_dropoff_location_array))
		{
			$this->data["selected_dropoff_location"] = $selected_dropoff_location_array["location_name"];
		}


		if(!empty($notification_ar))
		{
			$this->data["high_notification_type"] = $notification_ar["high_notification_type"];
			$this->data["high_notification_classnm"] = ($notification_ar["high_notification_type"]=="s") ? "success" :"danger";
			$this->data["high_notification_msg"] = $notification_ar["high_notification_msg"];
		}
		else{
			$this->data["high_notification_type"] = "";
			$this->data["high_notification_msg"] = "";
		}
		/*Check for high period notification*/
		

		$this->data["currencies"] = $this->currencies_model->get_many_by("status",'y');
		
		$def_currency_code_where = array('isDefault'=>'y',"status"=>'y');
		$def_currency_code_ar = $this->currencies_model->get_by($def_currency_code_where);
		$this->data["def_currency_code"] = $def_currency_code_ar["code"];

		/*printr($this->data["search_results"]);*/
		$this->data["output"] = $this->load->view("search/search_row",$this->data,true);;


		if($this->isAjax)
		{
			$this->layout=false;	
			$this->view=false;	
			$this->json=true;
			$this->data["status"] = "success";
			$this->data["page"] = $this->search_model->page + 1;
			$this->data["last_page"] = $this->search_model->last_page;
			unset($this->data["available_vehicles_slider"]);
			unset($this->data["search_results"]);
		}
		else
		{
			$this->locations_model->after_get_allow = false;
			$this->data["locations"] = $this->locations_model->get_many_by("status",'y');
			$this->locations_model->after_get_allow = true;

			$this->data["pickup_location_time"] = $this->get_opening_time_from_location($this->data["pickup_location"]);
			
			if($this->data["dropoff_location"] == "" || $this->data["dropoff_location"] == null)
			{
				$this->data["dropoff_location"] = $this->data["pickup_location"];

			}
			
			$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($this->data["dropoff_location"]);

			/*$this->characteristics_groups_model->after_get_allow = false;*/
			$this->data["search_criteria"] = $this->characteristics_groups_model->get_many_by('status','y');
			

			

			/*printr($this->data["search_header_criteria"]);*/



			/*$this->characteristics_groups_model->after_get_allow = true;*/
		}
	}
}
