<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class location extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("locations_model");
	}

	public function index($id)
	{	
		$this->locations_model->location_faq_allow = true;
		$this->locations_model->offers_model_after_allow_overrite = true;		
		$location_data = $this->locations_model->get($id);
		$this->locations_model->location_faq_allow = false;
		$this->locations_model->offers_model_after_allow_overrite = false;

		if(!empty($location_data))
		{
			$this->meta_keyword = $location_data["meta_keyword"];
			$this->meta_description = $location_data["meta_desc"];
			$this->load->start_inline_scripting();
			echo "Appfd.initLocation();";
			$this->load->end_inline_scripting(false,false);
			$this->output->set_title(lang("Location Detail - ".$location_data["location_name"]));
			$this->data["location_data"] = $location_data;

			if(!empty($this->data["location_data"]["faqs"]))
			{
				$faqs = array();
				foreach ($this->data["location_data"]["faqs"] as $key => $value) 
				{
					$faqs[$value["category_name"]][] = $value;
				}	
				$this->data["location_data"]["faqs"] = $faqs;
			}

			$check_working_time = $this->locations_model->get_working_time($location_data["id"],date("Y-m-d"));
			if($check_working_time["status"] == "success")
			{	
				$working_from_ar = explode(":",$check_working_time["working_from"]);
				array_pop($working_from_ar);
				$this->data["working_from"] = implode(":",$working_from_ar);

				$working_to_ar = explode(":",$check_working_time["working_to"]);
				array_pop($working_to_ar);
				$this->data["working_to"] = implode(":",$working_to_ar);
			}
			else
			{
				$working_from_ar = explode(":",$location_data["working_from"]);
				if(count($working_from_ar) == 3)
				{
					array_pop($working_from_ar);
					$this->data["working_from"] = implode(":",$working_from_ar);
				}

				$working_to_ar = explode(":",$location_data["working_to"]);
				if(count($working_to_ar) == 3)
				{
					array_pop($working_to_ar);
					$this->data["working_to"] = implode(":",$working_to_ar);
				}
			}
		}	
		else
		{
			$this->session->set_flashdata("error",lang("INVALID_LOCATION"));
			redirect(base_url(),"refresh");
		}		
	}
}
