<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Forgotpassword extends MY_Controller {

	function __construct()
	{	
		$this->login_type	='both';
		$this->layout		='default';
		$this->access      ='nologin';
		parent::__construct();
		$this->_init();		
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->sections['section_form']="forgotpassword/index";
		if($this->isAjax){
			$this->sections['section_popup'] = 'sections/popup/modal';
		}
		else{
			$this->sections['section_popup'] = 'sections/popup/page';
		}
	}

	public function index()
	{
		if($this->input->post())
		{
			$this->load->model("user_model");
			$result = $this->user_model->forgot_password();
			if($result["status"] == "success")
			{
				$this->session->set_flashdata('success',$result["msg"]);				
			}
			else{
				$this->session->set_flashdata('error',$result["msg"]);				
			}
			redirect(base_url()."signin");
		}
		if(!$this->input->post())
		{
			if($this->isAjax){
				$this->layout=false;				
			}
			$this->output->set_title(lang("Forgot Password"));	
			$this->body_class = "modal-inline";
			$this->view="general/popup_page";
			$this->page_title=lang("Forgot Password");
		}
	}
}
