<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once("common_methods.php");
class Fleetlist extends Common_methods 
{
	function __construct()
	{	
		$this->login_type	='';
		$this->layout		='default';
		$this->access      ='';
		parent::__construct();
		$this->_init();
	}

	private function _init()
	{
		$this->sections['section_header'] = 'sections/header';
		$this->sections['section_footer'] = 'sections/footer';
		$this->load->model("search_model");
		$this->load->model("cars_model");
		$this->load->model("car_groups_model");
		$this->load->model("car_facilities_detail_model");
		$this->load->model("car_pickup_location_detail_model");
		$this->load->model("bookings_model");
		$this->load->model("locations_model");
		$this->load->model("characteristics_groups_model");
		$this->load->model("characteristics_model");
		$this->load->model("high_period_notification_model");
		$this->load->helper('text');
	}

	public function index()
	{
		$this->load->js('js/owl.carousel.js');
		$this->load->start_inline_scripting();
		echo "Appfd.initSearchCommon();";
		echo "Appfd.initCarSearchFormCommon();";
		$this->load->end_inline_scripting(false,false);
		$this->output->set_title(lang("Fleet Guide"));
		/*$search_where[] = array('cars.status = "y" AND hpn.status="y"',null,false);*/
		$this->search_model->page = ($this->input->get("page") > 0) ? $this->input->get("page") : 0;
		if($this->search_model->page  > 0)
		{
			$this->search_model->start_limit = (($this->search_model->page - 1)*$this->search_model->rec_to_dis) ;
			$this->search_model->limit = $this->search_model->start_limit.",".$this->search_model->rec_to_dis;
		}	
		else{
			$this->search_model->limit = $this->search_model->rec_to_dis;
		}			
		$group = ($this->input->get("group") > 0) ? $this->input->get("group") : 0;
		$this->search_model->orderbycolumn = "cars.created";
		$this->search_model->orderbytype = "DESC";
		if($group > 0)
		{
			$this->search_model->group = $group;			
		}
		$this->search_model->group = $this->data["group"] = $group;
		$this->search_model->counter = true;
		$this->search_model->limit_allow = false;
		$this->search_model->is_fleet_guide = true;
		$this->data["search_results_total_counter"] = $this->search_model->search_results();
		$this->search_model->counter = false;
		$this->search_model->limit_allow = true;
		if($this->data["search_results_total_counter"] > $this->search_model->rec_to_dis)
		{
			$this->data["loadenabled"] = true;
		}
		if(isset($this->data["search_results_total_counter"]) && $this->data["search_results_total_counter"] > 0)
		{			
			$this->search_model->last_page = ceil($this->data["search_results_total_counter"]/$this->search_model->rec_to_dis);
		}
		$this->data["search_results"] = $this->search_model->search_results();
		$this->search_model->is_fleet_guide = false;
		if(!empty($this->data["search_results"]))
		{
			$this->data["available_vehicles_slider"] = array();
			
			$this->data["car_group_results"] = $this->car_groups_model->get_many_by('status','y');
			
			foreach ($this->data["car_group_results"] as $key => $value) {
				$temp = array('image_path'=>$value["search_avail_image_path"],'id'=>$value["id"],'name'=>character_limiter($value["group_name"], 10));
				$this->data["available_vehicles_slider"][] = $temp;
			}			
		}
		$this->data["slider_results_render"] = $this->load->view("fleetlist/slider_row",$this->data,true);;
		$this->data["output"] = $this->load->view("fleetlist/search_row",$this->data,true);;
		if($this->isAjax)
		{
			$this->layout=false;	
			$this->view=false;	
			$this->json=true;
			$this->data["status"] = "success";
			$this->data["page"] = $this->search_model->page + 1;
			$this->data["last_page"] = $this->search_model->last_page;
			unset($this->data["available_vehicles_slider"]);
			unset($this->data["search_results"]);
		}
		else
		{
			$response = array();
			$this->load->model("content_model");
			$where_ar[] = array("display_position='fleet_guide'",null,false);
			$this->data["fleetlist_content"] = $this->content_model->set_fields("page_title,page_description,meta_keyword,meta_description")->get_by($where_ar);


			if($this->data["fleetlist_content"]["meta_keyword"] != '' && $this->data["fleetlist_content"]["meta_keyword"] != null)
			{
				$this->meta_keyword = $this->data["fleetlist_content"]["meta_keyword"];		
			}
			if($this->data["fleetlist_content"]["meta_description"] != '' && $this->data["fleetlist_content"]["meta_description"] != null)
			{
				$this->meta_description = $this->data["fleetlist_content"]["meta_description"];
			}

			/*printr($this->data["fleetlist_content"]);*/

			/*$this->data["locations"] = $this->locations_model->get_many_by("status",'y');
			$this->data["pickup_location_time"]=array();
			$this->data["dropoff_location_time"]=array();
			if($pickup_location>0){
				$this->data["pickup_location_time"] = $this->get_opening_time_from_location($pickup_location);
			}
			if($dropoff_location>0){
				$this->data["dropoff_location_time"] = $this->get_opening_time_from_location($dropoff_location);
			}
			$this->data["search_criteria"] = $this->characteristics_groups_model->get_many_by('status','y');;*/
		}
	}
}
