<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class site_setting extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->page ='admin/manage_constants/';
		$this->current_url = base_url()."admin/site_setting/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->load->helper(array('url','language'));
		$this->load->js("plugins/ckeditor/ckeditor.js");
		$this->load->model("site_settings_model");
		if($this->input->post())
		{
			if($_FILES && $_FILES['upload_file']['error']==UPLOAD_ERR_OK)
			{
				$site_logo = $this->input->post('SITE_LOGO');
				$where_ar_rec = array('constant'=>'SITE_LOGO');
				$physical_path = FCPATH."/assets/nova/img/site_setting";
				$logo_details = $this->site_settings_model->get_by($where_ar_rec);
				if($logo_details)
				{
					unlink($physical_path."/".$logo_details['value']);	
				}

				$dirname = $physical_path;
				if(!file_exists($dirname)){
					mkdir($dirname,0777);
				}
				$extention = 'png|gif|jpg|jpeg|bmp|jpe';
				$config['upload_path'] =  $dirname;
				$config['allowed_types'] = $extention;
				$config['max_size'] = '16777215';
				$config['overwrite'] = FALSE;
				$config['remove_spaces'] = TRUE;
				$config['file_name'] = md5(date("Y-m-d H:i:s").rand());
				$this->load->library('upload', $config);
				$SITE_LOGO_FILE = '';
				if(!empty($_FILES["upload_file"]) && $_FILES['upload_file']['error'] == 0)
				{
					if($this->upload->do_upload('upload_file'))
					{
						$data_file = array('upload_data' => $this->upload->data());
						$SITE_LOGO_FILE  = $data_file['upload_data']['file_name'];
						generate_thumb_from_img($data_file,61,220,'th1_',$dirname);
						/*$SITE_LOGO_FILE  = $config['file_name'];*/
						$site_logo = $SITE_LOGO_FILE;
					}else{
						$error = $this->upload->display_errors();						
					}
					unset($data_file['upload_data'], $_FILES['upload_file'], $this->file_name);					
				}
			}

			$constant = array(
				'SITE_NM' => $this->input->post('SITE_NM'),
				'ADMIN_EMAIL' => $this->input->post('ADMIN_EMAIL'),
				'PAYPAL_EMAIL' => $this->input->post('PAYPAL_EMAIL'),
				'CONTACT_EMAIL' => $this->input->post('CONTACT_EMAIL'),
				'GOOGLE_ANA_CODE' => $this->input->post('GOOGLE_ANA_CODE'),
				'SMTP_USERNAME' => $this->input->post('SMTP_USERNAME'),
				'SMTP_PASSWORD' => $this->input->post('SMTP_PASSWORD'),
				'SMTP_PORT' => $this->input->post('SMTP_PORT'),
				'SMTP_HOST' => $this->input->post('SMTP_HOST'),
				'PAYMENT_PAYPAL' => $this->input->post('PAYMENT_PAYPAL'),
				'RESERVATION_KEY' => $this->input->post('RESERVATION_KEY'),
				'FACEBOOK' => $this->input->post('FACEBOOK'),
				'TWITTER' => $this->input->post('TWITTER'),
				'YOUTUBE' => $this->input->post('YOUTUBE'),
				'GMAIL' => $this->input->post('GMAIL'),
				'LINKED' => $this->input->post('LINKED'),
				'INSTAGRAM' => $this->input->post('INSTAGRAM'),				
				'LOCATION' => $this->input->post('LOCATION'),
				'HOME_META_DESC' => $this->input->post('HOME_META_DESC'),
				'HOME_META_KEY' => $this->input->post('HOME_META_KEY'),
				'HOME_HEAD_TITLE' => $this->input->post('HOME_HEAD_TITLE'),
				'FB_APP_SECRET'=>$this->input->post('FB_APP_SECRET'),
				'FB_APP_ID'=>$this->input->post('FB_APP_ID'),
				'GOOGLE_APP_SECRET'=>$this->input->post('GOOGLE_APP_SECRET'),
				'GOOGLE_APP_ID'=>$this->input->post('GOOGLE_APP_ID'),
				'DRIVER_MINIMUM_AGE' => $this->input->post('DRIVER_MINIMUM_AGE'),
				'DRIVER_MAXIMUM_AGE' => $this->input->post('DRIVER_MAXIMUM_AGE'),
				'USER_MINIMUM_AGE' => $this->input->post('USER_MINIMUM_AGE'),
				'SPECIAL_AGE_PRICE' => $this->input->post('SPECIAL_AGE_PRICE'),
				'TIME_SURCHARGE_PRICE' => $this->input->post('TIME_SURCHARGE_PRICE'),
				'ADVANCED_BOOKING_PERIOD' => $this->input->post('ADVANCED_BOOKING_PERIOD'),
				'STEP_2_HELP' => $this->input->post('STEP_2_HELP'),
				'STEP_3_HELP' => $this->input->post('STEP_3_HELP'),
				'DEFAULT_INSURANCE' => $this->input->post('DEFAULT_INSURANCE')				
				);

if($site_logo != '')
{
	$constant["SITE_LOGO"] = $site_logo;
}

if(!empty($constant))
{
	$update_status_ar = array();
	foreach ($constant as $key => $value) {
		$update_array = array('value'=>$constant[$key]);	
		$update_where_ar = array('constant'=>$key);
		$update_status_ar[] = $this->site_settings_model->update_by($update_where_ar,$update_array);
	}
}

if(!in_array(false,$update_status_ar))
{
	$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
	redirect($this->current_url,"refresh");
}
else{
	$msg_t = (validation_errors()) ? validation_errors() : lang(MSG_FILL_ALL_FIELDS);
	$this->session->set_flashdata('error',$msg_t);
	redirect($this->current_url,"refresh");
}
}
else if(!$this->input->post()){
	$this->page_name = lang("Site Settings");
	$this->output->set_title(lang("Site Settings"));
	$this->load->model("locations_model");
	$this->load->model("insurance_group_model");
	$this->data['site_settings'] = $this->site_settings_model->get_all();

	$this->locations_model->after_get_allow = false;
	$this->data['locations'] = $this->locations_model->get_all();
	$this->locations_model->after_get_allow = true;	

	$this->data['insurance'] = $this->insurance_group_model->get_all();

	$this->data['form_url'] = $this->current_url;
}
}



}
