<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class resetpassword extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'nologin';
		parent::__construct();
		$this->_init();
	}
	private function _init()
	{
		$this->layout 		= 'admin/login_default';
	}
	public function index($token)
	{
		if(!$this->input->post()){
			$this->load->model("admin_model");
			$where = array('forgotten_password_code'=>$token);
			$admin_detail = $this->admin_model->as_array()->get_by($where);
			if($admin_detail){
				$this->body_class = 'login';
				$this->load->css('nova/css/login-3.css');
				$this->sections['section_header']='sections/admin/login_section/header';
				$this->sections['section_footer']='sections/admin/login_section/footer';
				$this->sections['register_section'] = 'admin/resetpassword/index';
				$action_url = base_url()."admin/resetpassword/".$token;
				$login_url=base_url()."admin/login";
				$this->data['action_url']=$action_url;
				$this->data['login_url']=$login_url;
				$this->output->set_title(lang("Reset Password"));
			}
			else{
				$this->session->set_flashdata("error",lang(LINK_EXPIRED));
				redirect(base_url()."admin/login");
			}
		}

		if($this->input->post()){
			$this->load->model("admin_model");
			$response = array('status'=>'success','msg'=>'');
			$this->admin_model->validate = array(
				'new'  => array(
					'field' => 'new',
					'label' => 'Password',
					'rules' => 'required|min_length[4]|matches[new_confirm]',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED",
						'min_length'  => "lang:PASSWORD_MINIMUM_LENGTH",
						'matches'  => "lang:MSG_PASSWORD_NOTMATCH"
						),
					),
				'new_confirm'  => array(
					'field' => 'new_confirm',
					'label' => 'Confirm Password',
					'rules' => 'required',
					'error_msg' => array(
						'required'  => "lang:PASSWORD_REQUIRED"						
						),
					)
				);
			$where = array('forgotten_password_code'=>$token);
			$user_detail = $this->admin_model->as_array()->get_by($where);
			if($user_detail){
				$new_pwd = $this->input->post('new');
				$update_array = array('password'=>md5($new_pwd),'forgotten_password_code'=>'');
				$temp = $this->admin_model->update($user_detail["id"],$update_array);
				if($temp){
					$this->session->set_flashdata('success',lang(MSG_PASSWORD_CHANGE_SUCCESSFULL));
					redirect(base_url()."admin/login");
				}else{
					$this->session->set_flashdata('error',validation_errors());
					redirect(base_url()."admin/resetpassword/".$token);
				}
			}else{
				$this->session->set_flashdata('error',lang(LINK_EXPIRED));
				redirect(base_url()."admin/login");
			}
		}		
	}	
}
