<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_stop_sale_period extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "stop_sale_period_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_stop_sale_period/';
		$this->current_url = base_url()."admin/manage_stop_sale_period/";
		$this->table_id = "tblmng_stop_sale_period";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Stop Sale Period";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_stop_sale_period();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('ssp.id,ssp.start_date,ssp.end_date,ssp.id as carid,ssp.id as locationsid,ssp.status',false)
		
		->edit_column('carid', '$1', 'get_stop_sale_cars(id)')
		->edit_column('locationsid', '$1', 'get_stop_sale_locations(id)')

		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('stop_sale_period as ssp');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			/*$name_post = $this->input->post('name');*/
			
			/*$locationId = $this->input->post('locationId');
			$categoryId = $this->input->post('categoryId');*/
			
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');

			$cars = $this->input->post('cars');
			$car_ids = implode(",",$cars);

			$locations = $this->input->post('locations');
			$locations_ids = implode(",",$locations);

			/*AND locationId = '".$locationId."' AND categoryId = '".$categoryId."'*/
			$where_ar[] = array("(('".$start_date."' BETWEEN start_date AND end_date) OR ('".$end_date."' BETWEEN start_date AND end_date)) AND carId IN(".$car_ids.") AND locationId IN(".$locations_ids.")",null,false);
			$exist_check = $this->{$this->modal_name}->join("stop_sale_period_cars_detail as ss_cd","ss_cd.stopsaleId = stop_sale_period.id")->join("stop_sale_period_location_detail as ss_ld","ss_ld.stopsaleId = stop_sale_period.id")->get_by($where_ar);

			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					/*'locationId' => $locationId,
					'categoryId' => $categoryId,*/
					'start_date' => $start_date,
					'end_date' => $end_date,
					'createdDate' => date('Y-m-d H:i:s')					
					);
				$status = $this->{$this->modal_name}->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}				
			}
		}


		if(!$this->input->post())
		{
			$this->load->model("locations_model");
			$this->load->model("cars_model");


			$this->load->js('js/components-date-time-pickers.js');
			$this->page_type = 'add';
			$text = "Add Stop Sale Period";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";


			$this->locations_model->after_get_allow = false;
			$this->data["locations"] = $this->locations_model->get_many_by('status','y');
			$this->locations_model->after_get_allow = true;


			$this->cars_model->after_get_allow = false;
			$this->cars_model->after_get_category_name_allow = false;
			$this->cars_model->after_get_group_name_allow = false;

			$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');

			$this->cars_model->after_get_allow = true;
			$this->cars_model->after_get_category_name_allow = true;
			$this->cars_model->after_get_group_name_allow = true;

			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL)
	{
		if($id != NULL && $id > 0)
		{
			$data = array();
			$animeties_array = array("db_sel_cars","db_sel_location");

			$this->{$this->modal_name}->allow_after_get = true;
			$this->{$this->modal_name}->get_offers_location_data = true;
			$this->data["stop_sale_data"] = $this->{$this->modal_name}->get($id);
			$this->{$this->modal_name}->allow_after_get = false;
			$this->{$this->modal_name}->get_offers_location_data = false;
			
			if(!empty($animeties_array))
			{
				foreach ($animeties_array as $key => $value) 
				{
					if(!empty($this->data["stop_sale_data"][$value]))
					{
						$this->data["stop_sale_data"][$value."_ids"] = array();
						foreach ($this->data["stop_sale_data"][$value] as $key => $value1)
						{
							$this->data["stop_sale_data"][$value."_ids"][] = $value1["id"];
						}
						unset($this->data["stop_sale_data"][$value]);
					}	
				}
			}


			if($this->input->post())
			{
				/*$locationId = $this->input->post('locationId');
				$categoryId = $this->input->post('categoryId');*/
				$start_date = $this->input->post('start_date');
				$end_date = $this->input->post('end_date');
				$message = $this->input->post('message');
				$type = $this->input->post('type');		

				/*AND locationId = '".$locationId."' AND categoryId = '".$categoryId."'*/

				/*$where_ar[] = array("(('".$start_date."' BETWEEN start_date AND end_date) OR ('".$end_date."' BETWEEN start_date AND end_date)) ",null,false);
				$where_ar[] = array("id != '".$id."'",null,false);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);*/

				$cars = $this->input->post('cars');
				$car_ids = implode(",",$cars);

				$locations = $this->input->post('locations');
				$locations_ids = implode(",",$locations);

				$where_ar[] = array("(('".$start_date."' BETWEEN start_date AND end_date) OR ('".$end_date."' BETWEEN start_date AND end_date)) AND carId IN(".$car_ids.") AND locationId IN(".$locations_ids.")",null,false);
				$where_ar[] = array("stop_sale_period.id != '".$id."'",null,false);
				$exist_check = $this->{$this->modal_name}->join("stop_sale_period_cars_detail as ss_cd","ss_cd.stopsaleId = stop_sale_period.id")->join("stop_sale_period_location_detail as ss_ld","ss_ld.stopsaleId = stop_sale_period.id")->get_by($where_ar);

				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{				

					$data = array(
						'start_date' => $start_date,
						'end_date' => $end_date,
						"id"=>$id,
						"db_sel_cars"=>	$this->data["stop_sale_data"]["db_sel_cars_ids"],
						"db_sel_location"=>	$this->data["stop_sale_data"]["db_sel_location_ids"]
						);
					if(!empty($data))
					{
						$this->{$this->modal_name}->allow_before_update = true;
						$update_status = $this->{$this->modal_name}->update($id,$data);
						$this->{$this->modal_name}->allow_before_update = false;
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}					
				}
			}
			else if(!$this->input->post())
			{
				$this->load->js('js/components-date-time-pickers.js');
				if($this->data["stop_sale_data"])
				{
					$text = "Edit Stop Sale Period";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->load->model("locations_model");
					$this->load->model("cars_model");

					$this->locations_model->after_get_allow = false;
					$this->data["locations"] = $this->locations_model->get_many_by('status','y');
					$this->locations_model->after_get_allow = true;
					

					$this->cars_model->after_get_allow = false;
					$this->cars_model->after_get_category_name_allow = false;
					$this->cars_model->after_get_group_name_allow = false;

					$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');

					$this->cars_model->after_get_allow = true;
					$this->cars_model->after_get_category_name_allow = true;
					$this->cars_model->after_get_group_name_allow = true;


					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$stop_sale_id = $this->input->post('stop_sale_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($stop_sale_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($stop_sale_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($stop_sale_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
