<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_states extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("states_model");
		$this->page ='admin/manage_states/';
		$this->current_url = base_url()."admin/manage_states/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$this->output->set_title(lang("Manage States"));
		$this->page_name = lang("Manage States");
		$this->data['page_url']	=	'manage_states';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_states';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_states();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('s.id,s.state_name,c.country_name,s.status',false)
		->join('countries as c','c.id = s.country')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		
		->from('states as s');
		if($this->isAjax){
			$this->layout = false;
			$this->view = false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{

		$data = array();
		if($this->input->post())
		{
			$state_name_post = $this->input->post('state_name');
			$exist_check = $this->states_model->get_by("state_name",$state_name_post);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'state_name' => $this->input->post('state_name'),
					'country' => $this->input->post('country')				
					);
				$status = $this->states_model->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
			
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add State";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("countries_model");
			$this->data["countries"] = $this->countries_model->get_all();
			$this->data["country_id"] = 0;
			$this->view = $this->page."add_edit";
		}
	}


	public function edit($id=NULL){

		if($id != NULL && $id > 0){
			
			$data = array();
			if($this->input->post())
			{
				$data = array(
					'state_name' => $this->input->post('state_name'),
					'country' => $this->input->post('country')				
					);

				if(!empty($data))
				{
					$update_status = $this->states_model->update($id,$data);
					if(!empty($update_status)) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url,"refresh");
					}else{
						$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["state_data"] = $this->states_model->as_array()->get($id);
				if($this->data["state_data"])
				{
					$text = "Edit - ".$this->data["state_data"]["state_name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->load->model("countries_model");
					$this->data["countries"] = $this->countries_model->get_all();
					$this->data["country_id"] = $this->data["state_data"]["country"];	
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}


	

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$state_id = $this->input->post('state_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($state_id > 0){
				$this->state_data = $this->states_model->set_fields("id,status")->as_array()->get($state_id);
				if(!empty($this->state_data))
				{
					if($this->state_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->states_model->update($state_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->states_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_states";
			}
		}
	}
}
