<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_season extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "season_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_season/';
		$this->current_url = base_url()."admin/manage_season/";
		$this->table_id = "tblmng_season";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{

		$this->grid_resorces();
		$text = "Manage Season";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_season();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('id,season_name,start_date,end_date,status',false)		
		->edit_column('start_date', '$1', 'get_season_date(start_date)')
		->edit_column('end_date', '$1', 'get_season_date(end_date)')		
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->unset_column('start_date')
		->unset_column('end_date')
		->from('season');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$season_name_post = $this->input->post('season_name');
			$from_post = $this->input->post('from');
			$to_post = $this->input->post('to');

			$from_explode_ar = explode("/",$from_post);
			$to_explode_ar = explode("/",$to_post);

			$start_month = $from_explode_ar[0];
			$start_date = $from_explode_ar[1];
			$end_month = $to_explode_ar[0];			
			$end_date = $to_explode_ar[1];
			$date_year = DEFAULT_YEAR;
			$start_date_year=$date_year."-".$start_month."-".$start_date;
			$end_date_year=$date_year."-".$end_month."-".$end_date;

			$start_date_year=date("Y-m-d",strtotime($start_date_year));
			$end_date_year=date("Y-m-d",strtotime($end_date_year));

			$exist_check = $this->{$this->modal_name}->check_date_exist($start_date_year,$end_date_year);
			

			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$where_ar = array("season_name"=>$season_name_post);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."add");	
				}
				else{
					$data = array(
						'season_name' => $season_name_post,
						'start_date' => $start_date_year,
						'end_date' => $end_date_year,
						'created' => date('Y-m-d H:i:s')
						);
					$status = $this->{$this->modal_name}->insert($data);
					if($status)
					{
						$this->session->set_flashdata('success',lang(MSG_REC_ADD));
						redirect($this->current_url);				
					}else{
						$this->session->set_flashdata('error',lang(validation_errors()));
						redirect($this->current_url."add");	
					}
				}
			}
		}
		if(!$this->input->post())
		{
			$this->load->js('js/components-date-time-pickers.js');
			$this->page_type = 'add';
			$text = "Add Season";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			/*$this->load->start_inline_scripting();
			echo "current_date_val = '".date('Y-m-d')."';";
			echo "Appad.init_mng_season_operations();";
			$this->load->end_inline_scripting(false,false);*/
			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			if($this->input->post())
			{
				$season_name_post = $this->input->post('season_name');
				$from_post = $this->input->post('from');
				$to_post = $this->input->post('to');
				$from_explode_ar = explode("/",$from_post);
				$to_explode_ar = explode("/",$to_post);
				$start_month = $from_explode_ar[0];
				$start_date = $from_explode_ar[1];
				$end_month = $to_explode_ar[0];			
				$end_date = $to_explode_ar[1];
				$date_year = DEFAULT_YEAR;
				$start_date_year=$date_year."-".$start_month."-".$start_date;
				$end_date_year=$date_year."-".$end_month."-".$end_date;
				$where_pass = "id != '".$id."'";

				/*$exist_check = $this->{$this->modal_name}->check_date_exist($start_date_year,$end_date_year,$where_pass);*/

				$exist_check = $this->{$this->modal_name}->check_date_exist($start_date_year,$end_date_year,$where_pass);

				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else
				{	
					$where_ar[] = array("season_name = '".$season_name_post."' AND id != '".$id."'",null,null);
					$exist_check = $this->{$this->modal_name}->get_by($where_ar);
					if(!empty($exist_check))
					{
						$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
						redirect($this->current_url."edit/".$id);	
					}
					else
					{
						$data = array(
							'season_name' => $season_name_post,
							'start_date' => $start_date_year,							
							'end_date' => $end_date_year
							);
						if(!empty($data))
						{
							$update_status = $this->{$this->modal_name}->update($id,$data);
							if(!empty($update_status)) 
							{
								$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
								redirect($this->current_url,"refresh");
							}else{
								$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
								redirect($this->current_url.'edit/'.$id,"refresh");
							}
						}
					}
				}
			}
			else if(!$this->input->post()){

				$this->load->js('js/components-date-time-pickers.js');
				$this->data["season_data"] = $this->{$this->modal_name}->as_array()->get($id);
				if($this->data["season_data"])
				{
					$text = "Edit Season - ".$this->data["season_data"]["season_name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					/*$this->data["from"] = $this->data["season_data"]["start_month"]."/".$this->data["season_data"]["start_date"];*/
					
					$this->data["from"] = date('m/d',strtotime($this->data["season_data"]["start_date"]));

					/*$this->data["to"] = $this->data["season_data"]["end_month"]."/".$this->data["season_data"]["end_date"];*/
					
					$this->data["to"] = date('m/d',strtotime($this->data["season_data"]["end_date"]));	

					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$season_id = $this->input->post('season_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($season_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($season_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($season_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
