<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_quotes extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "quotes_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_quotes/';
		$this->current_url = base_url()."admin/manage_quotes/";
		$this->table_id = "tblmng_quotes";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Quotes";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_quotes();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('q.id,q.user_email,loc.location_name as pickup,loc2.location_name as dropoff,car.name,q.total_price,q.per_day_price,q.pickup_date,q.dropoff_date,q.date',false)
		->join('locations as loc','loc.id = q.pick_up_location_id')
		->join('locations as loc2','loc2.id = q.dropoff_location_id')
		->join('cars as car','car.id = q.car_id')
		->add_column('operation',get_operation_btn('$1',$array),'id')			
		->from('quotes as q');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
