<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_pickup_locations_fee extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("locations_fee_model");
		$this->page ='admin/manage_pickup_locations_fee/';
		$this->current_url = base_url()."admin/manage_pickup_locations_fee/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	public function index()
	{

		$this->grid_resorces();
		$this->output->set_title(lang("Manage Pickup Location Fee"));
		$this->page_name = lang("Manage Pickup Location Fee");
		$this->data['page_url']	=	'manage_pickup_location_fee';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_pickup_location_fee';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_pickup_locations_fee();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('l.id,loc.location_name as fromname,loc2.location_name as toname,l.minimum_days,l.price,l.status',false)
		->join('locations as loc','loc.id = l.fromId')
		->join('locations as loc2','loc2.id = l.toId')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')
		->from('locations_fee as l');
		if($this->isAjax){
			$this->layout = false;
			$this->view = false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	public function add()
	{

		$data = array();
		if($this->input->post())
		{
			$location_from    = $this->input->post('location_from');
			$location_to    = $this->input->post('location_to');
			$minimum_days     = $this->input->post('minimum_days');
			$price        = $this->input->post('price');
			
			$where_ar = array('fromId'=>$location_from,'toId'=>$location_to);
			$exist_check = $this->locations_fee_model->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{				
				$data = array(
					'fromId' =>  $location_from,
					'toId' =>  $location_to,
					'minimum_days'=>  $minimum_days,
					'price'   =>  $price
					);
				$status = $this->locations_fee_model->insert($data);
				$status2 = true;
				if($this->input->post('is_reversible'))
				{
					$status2 = $this->locations_fee_model->reversible_manage();
				}

				if($status && $status2)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
		}
		if(!$this->input->post())
		{
			$this->page_type = 'add';
			$text = "Add Pickup Location Fee";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("locations_model");
			$this->data["locations_from"] = $this->locations_model->get_many_by('status','y');
			$this->load->start_inline_scripting();
			echo "Appad.init_pickup_location_fee_operation();";
			$this->load->end_inline_scripting(false,false);
			$this->view = $this->page."add_edit";
		}
	}
	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			$this->data["location_data"] = $this->locations_fee_model->as_array()->get($id);
			$where_ar = array('fromId'=>$this->data["location_data"]["toId"],'toId'=>$this->data["location_data"]["fromId"]);
			$exist_check = $this->locations_fee_model->get_by($where_ar);
			$update_status2 = true;
			if($this->input->post())
			{
				$minimum_days = $this->input->post('minimum_days');
				$price        = $this->input->post('price');
				$reversible_price        = $this->input->post('reversible_price');
				$data = array(
					'minimum_days'=>  $minimum_days,
					'price'   =>  $price
				);
				if(!empty($data))
				{
					$update_status = $this->locations_fee_model->update($id,$data);
					if($this->input->post('is_reversible'))
					{
						$update_status2 = $this->locations_fee_model->reversible_manage(true);
					}
					if($update_status && $update_status2) 
					{
						$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
						redirect($this->current_url,"refresh");
					}else{
						$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
						redirect($this->current_url.'edit/'.$id,"refresh");
					}
				}
			}
			else if(!$this->input->post())
			{
				if($this->data["location_data"])
				{
					$text = "Edit location fee";
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->load->model("locations_model");
					$this->data["locations_from"] = $this->locations_model->get_many_by('status','y');
					$this->data["locations_to"] = $this->locations_model->get_many_by('status','y');
					$this->data["fromId"] = $this->data["location_data"]["fromId"];	
					$this->data["toId"] = $this->data["location_data"]["toId"];	
					if(!empty($exist_check))
					{
						$this->data["checked"] = true;
						$this->data["checked_class"] = "show";
						$this->data["location_data"]["reversible_price"] = $exist_check["price"];
					}
					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";
					$this->load->start_inline_scripting();
					echo "Appad.init_pickup_location_fee_operation();";
					$this->load->end_inline_scripting(false,false);
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}
	
	
	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$location_id = $this->input->post('location_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($location_id > 0){
				$this->location_data = $this->locations_fee_model->set_fields("id,status")->as_array()->get($location_id);
				if(!empty($this->location_data))
				{
					if($this->location_data['status'] == 'n')
					{
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->locations_fee_model->update($location_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0)
		{
			$del_status = $this->locations_fee_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_pickup_location_fee";
			}
		}
	}
}
