<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_email_templates extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("templates_model");
		$this->page ='admin/manage_email_templates/';
		$this->current_url = base_url()."admin/manage_email_templates/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	
	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Email Templates";
		$this->page_name = lang($text);
		$this->output->set_title(lang($text));
		$this->data['page_url']	=	'manage_constants';
		$this->data['tbl_id']		=	'tblmng_email_templates';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_email_templates();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$array = array('edit'=>$editurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');

		$this->datatables->select('id,types,description',false)
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		
		->from('templates');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];		
	}

	public function edit($id){
		$this->data["template_data"] = $this->templates_model->as_array()->get($id);
		if($id != NULL && $id > 0){
			if($this->input->post()){

				$data = array(
					'subject' 	=> 	$this->input->post('subject'),
					'description'	=>	$this->input->post('description'),
					'templates'	=>	$this->input->post('templates')
					);		
				$update_status = $this->templates_model->update($id,$data);
				if($update_status) 
				{
					$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
					redirect($this->current_url,"refresh");
				}else{
					$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
					redirect($this->current_url.'edit/'.$id,"refresh");
				}
			}else if(!$this->input->post()){
				$this->load->helper(array('url','language'));
				$this->load->js("plugins/ckeditor/ckeditor.js");

				if($this->data["template_data"])
				{
					$this->page_type = 'edit';
					$this->page_name = lang("Edit Template - ".$this->data["template_data"]["types"]);
					$this->output->set_title(lang("Edit Template - ".$this->data["template_data"]["types"]));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->view = $this->page."email_template_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect($this->current_url."manage_email_template","refresh");
				}
			}
		}

	}

}
