<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_cities extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->load->model("cities_model");
		$this->page ='admin/manage_cities/';
		$this->current_url = base_url()."admin/manage_cities/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}
	public function index()
	{
		$this->grid_resorces();
		$this->output->set_title(lang("Manage Cities"));
		$this->page_name = lang("Manage Cities");
		$this->data['page_url']	=	'manage_cities';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	'tblmng_cities';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_cities();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('c.id,c.city_name,s.state_name,co.country_name,c.latitude,c.longitude,c.status',false)
		->join('countries as co','co.id = c.country')
		->join('states as s','s.id = c.state')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->add_column('operation',get_operation_btn('$1',$array),'id')
		->from('cities as c');
		if($this->isAjax){
			$this->layout = false;
			$this->view = false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	public function add()
	{
		$data = array();
		if($this->input->post())
		{
			$google_place_id = $this->input->post('google_place_id');
			$country      = $this->input->post('country');
			$state        = $this->input->post('state');
			$city_name    = $this->input->post('city_name');
			$meta_keyword     = $this->input->post('meta_keyword');
			$meta_desc        = $this->input->post('meta_desc');
			$description  = $this->input->post('description');
			$latitude     = $this->input->post('latitude');
			$longitude   = $this->input->post('longitude');
			
			$where_ar = array('country'=>$country,'state'=>$state,'city_name'=>$city_name);
			$this->cities_model->after_get_location_allow = false;
			$exist_check = $this->cities_model->get_by($where_ar);
			$this->cities_model->after_get_location_allow = true;
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{				
				$data = array(
					'country'        => $country,
					'state'          => $state,
					'city_name'      => $city_name,
					'meta_keyword'  =>  $meta_keyword,
					'meta_desc'     =>  $meta_desc,
					'description'    => $description,
					'latitude'       => $latitude,
					'longitude'      => $longitude,
					'google_place_id'=> $google_place_id
					);

				$status = $this->cities_model->insert($data);
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}
			}
		}
		if(!$this->input->post())
		{
			$this->load->helper(array('url','language'));
			$this->load->js("plugins/ckeditor/ckeditor.js");
			$this->load->js("http://maps.googleapis.com/maps/api/js?key=".GOOGLE_MAP_API_KEY."&sensor=false&libraries=places",true);
			$this->page_type = 'add';
			$text = "Add City";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";
			$this->load->model("countries_model");
			$this->data["countries"] = $this->countries_model->get_all();
			$this->data["country_id"] = 0;
			$this->load->start_inline_scripting();
			echo "Appad.init_mng_cities_operation();";
			echo "Appad.init_common_methods();";			
			$this->load->end_inline_scripting(false,false);
			$this->view = $this->page."add_edit";
		}
	}
	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();
			if($this->input->post())
			{

				$google_place_id = $this->input->post('google_place_id');
				$country      = $this->input->post('country');
				$state        = $this->input->post('state');
				$city_name    = $this->input->post('city_name');
				$description  = $this->input->post('description');
				$latitude     = $this->input->post('latitude');
				$longitude   = $this->input->post('longitude');
				$meta_keyword     = $this->input->post('meta_keyword');
				$meta_desc        = $this->input->post('meta_desc');

				$where_ar = array('country'=>$country,'state'=>$state,'city_name'=>$city_name);
				$where_ar[] = array("id != '".$id."'",null,null);
				$exist_check = $this->cities_model->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."add");	
				}
				else{
					$data = array(
						'country'        => $country,
						'state'          => $state,
						'city_name'      => $city_name,
						'meta_keyword'  =>  $meta_keyword,
						'meta_desc'     =>  $meta_desc,
						'description'    => $description,
						'latitude'       => $latitude,
						'longitude'      => $longitude,
						'google_place_id'=> $google_place_id
						);
					if(!empty($data))
					{
						$update_status = $this->cities_model->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}
				}
			}
			else if(!$this->input->post()){
				$this->data["city_data"] = $this->cities_model->as_array()->get($id);
				if($this->data["city_data"])
				{
					$this->load->helper(array('url','language'));
					$this->load->js("plugins/ckeditor/ckeditor.js");
					$this->load->js("http://maps.googleapis.com/maps/api/js?key=".GOOGLE_MAP_API_KEY."&sensor=false&libraries=places",true);
					$text = "Edit - ".$this->data["city_data"]["city_name"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->load->model("countries_model");
					$this->data["countries"] = $this->countries_model->get_all();
					$this->data["country_id"] = $this->data["city_data"]["country"];	

					$this->load->model("states_model");
					$this->data["states"] = $this->states_model->get_all();
					$this->data["state_id"] = $this->data["city_data"]["state"];


					$this->data["action"] = "edit";
					$this->view = $this->page."add_edit";

					$this->load->start_inline_scripting();
					echo "Appad.init_mng_cities_operation();";
					echo "Appad.init_common_methods();";			
					$this->load->end_inline_scripting(false,false);

				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}
	
	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$city_id = $this->input->post('city_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($city_id > 0){
				$this->city_data = $this->cities_model->set_fields("id,status")->as_array()->get($city_id);
				if(!empty($this->city_data))
				{
					if($this->city_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->cities_model->update($city_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}
	public function delete($id){
		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->cities_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = "tblmng_cities";
			}
		}
	}
}
